%%NAME
%%  esubeps  -  insert eps-file in a subarea of the window
%%
%%SYNOPSIS
%%  esubeps(nRows,nColumns,row,column,epsFileName)
%%
%%PARAMETER(S)
%%  nRows         number of rows of the window
%%  nColumns      number of columns of the windows
%%  row           index of row
%%  column        index of column
%%  epsFileName   name of eps-file
% written by Stefan Mueller stefan.mueller@fgan.de

function esubeps(nRows,nColumns,row,column,epsFileName)
  if nargin~=5
    usage('esubeps(nRows,nColumns,row,column,epsFileName)');
  end
  eglobpar;
  tWidth=nColumns*eWinWidth;
  tHeight=nRows*eWinHeight;
  rFacW=eWinWidth/tWidth;
  rFacH=eWinHeight/tHeight;
  if rFacW<rFacH
   rFac=rFacW;
  else
   rFac=rFacH;
  end
  xOffset=-(ePageWidth-eWinWidth)/(2*nColumns);
  yOffset=-(ePageHeight-eWinHeight)/(2*nRows);
  xPos=rFac*eWinWidth*(column-1)+xOffset; 
  yPos=rFac*eWinHeight*(nRows-row)+yOffset;; 
  einseps(xPos,yPos,epsFileName,rFac,rFac); 
