%%NAME
%%  eshadoi  - draw shadow image of a matrix 
%%
%%SYNOPSIS
%%  eshadoi(matrix[,colorMap])
%%
%%PARAMETER(S)
%%  matrix             matrix for image 
%%                     each value of the matrix is a row index of the colormap
%%  colorMap           define own colormap  
%%
%%GLOBAL PARAMETER(S)
%%  eImageDefaultColorMap
% written by Stefan Mueller stefan.mueller@fgan.de

function eshadoi(matrix,colorMap)
  if nargin >2
    usage('eshadoi(matrix[,coloMap])');
  end
  eglobpar;
  if nargin==0
    x=-3*pi:0.1:3*pi;
    [a b]=meshgrid(x,x);
    R=sqrt(a.^2+b.^2) + eps;
    matrix=sin(R)./R;
    ePlotTitleText='sin(R)/R';
  end
  if nargin<2
    colorMap=ecolors(eImageDefaultColorMap);
  end
  if sum(2*colorMap(:,1)-colorMap(:,2)-colorMap(:,3))
    nColors=size(colorMap,1); 
    nBrL=64;
    minFac=0.4;
    colorMapNew=colorMap*(minFac+(1-minFac)*1/nBrL);
    for i=2:nBrL
      colorMapNew=[colorMapNew;colorMap*(minFac+(1-minFac)*i/nBrL)];
    end
  else
    nColors=1;
    colorMapNew=colorMap;
  end
  eimage(eshadow(matrix,nColors,colorMapNew,[1 1 1]),colorMapNew);
