%eplotlg ( epsFile,x,y,color,dash,lineWidth,textFont,textSize)
% this function write postscript commands in  epsFile
% written by Stefan Mueller stefan.mueller@fgan.de 1997

function eplotlg ( epsFile,x,y,color,dash,lineWidth,text,textFont,textSize)
  if (nargin~=9)
    usage ('eplotlg ( epsFile,x,y,color,dash,lineWidth,text,textFont,textSize)');
  end
  space=10;
  lineLength=40;

  % print text
  fprintf(epsFile,'%1.2f %1.2f moveto\n',x+lineLength+space,y);
  fprintf(epsFile,'/%s findfont %1.2f scalefont setfont\n',textFont,textSize);
  fprintf(epsFile,'(%s) show\n',text);
  fprintf(epsFile,'stroke\n');

  % draw line
  if isstr(dash)
    fprintf(epsFile,'currentrgbcolor %1.2f %1.2f %1.2f setrgbcolor\n',...
            color(1),color(2),color(3));
    fprintf(epsFile,'%1.2f %1.2f 2 copy translate 0 0 moveto\n',...
            x+lineLength/2,y+textSize*0.28);
    fprintf(epsFile,'%s neg exch neg exch translate\n',dash);
    fprintf(epsFile,'setrgbcolor\n');
  else
    if dash>0
      fprintf(epsFile,'[%1.2f %1.2f] 0 setdash\n',dash,dash);
    end
    if dash<0
      lineWidth=textSize*0.72;
    end
    fprintf(epsFile,'currentrgbcolor %1.2f %1.2f %1.2f setrgbcolor\n',...
            color(1),color(2),color(3));
    fprintf(epsFile,'newpath\n');
    fprintf(epsFile,'%1.2f %1.2f moveto\n',x,y);
    fprintf(epsFile,'0 %1.2f rmoveto\n',textSize/3);
    fprintf(epsFile,'%1.2f 0 rlineto\n',lineLength);
    fprintf(epsFile,'%1.2f setlinewidth\n',lineWidth);
    fprintf(epsFile,'stroke\n');
    fprintf(epsFile,'setrgbcolor\n');
    fprintf(epsFile,'[] 0 setdash\n');
  end 
