%%NAME
%%  eimagesc  - draw scaled image of a matrix 
%%
%%SYNOPSIS
%%  x=eimagesc(matrix[,colorMap[,legendOrientation[,legendScale]]])
%%
%%PARAMETER(S)
%%  x                  transformed output matrix with values of color numbers
%%  matrix             matrix for image 
%%  colorMap           define own colormap  
%%  legendOrientation  side of the image where the legend appears 
%%                     character 's'(south),'n'(north),'w'(west) or 'e'(east) 
%%                     (default orientation is south)
%%  legendScale        scale vector of legend [start step end]
%%                     special cases of scale vector are:
%%                     if start=0 and end=0 then autorange=on 
%%                     if step=0 then autoscale=on
%%                     (default scale vector=[0 0 0])
%%
%%GLOBAL PARAMETER(S)
%%  ePlotAreaPos
%%  ePlotAreaWidth
%%  ePlotAreaHeight
%%  eImageDefaultColorMap
%%  eYAxisWestScale
%%  eXAxisSouthScale
%%  eImageLegendScale
%%  eImageLegendVisible
%%  eImageLegendPos
%%  eImageLegendHeight
%%  eImageLegendWidth
%%  eImageLegendLabelDistance
%%  eImageLegendValueFormat
%%  eImageLegendLabelText
%%  eAxesTicLongLength
%%  eAxesTicShortLength
%%  eAxesTicLongMaxN
%%  eAxesValueSpace
%%  eAxesValueFontSize
%%  eAxesLabelFontSize
%%  eAxesLabelTextFont
%%  eAxesLineWidth
% written by Stefan Mueller stefan.mueller@fgan.de

function x=eimagesc(matrix,colorMap,legendOrientation,legendScale)
  if (nargin>4)
    usage('x=eimagesc (matrix [ ,colorMap[,legendOrientation[,legendScale]]])');
  end
  eglobpar;
  if nargin==0
    currentDir=pwd;
    eval(['cd ',ePath]);
    eval(['load default.img']);
    eval(['cd ',currentDir]);
    matrix=default;
    ePlotTitleText='Anna and Leah';
  end
  if nargin<4
    legendScale=eImageLegendScale;
  end
  if nargin<3
    legendOrientation='s';
  end
  if nargin<2
    colorMap=ecolors(eImageDefaultColorMap);
  end
  
  % scale image
  if legendScale(1)==legendScale(3)
    minval=min (min (matrix));
    maxval=max (max (matrix));
  else
    minval=legendScale(1);
    maxval=legendScale(3);
  end
  legendScale(1)=minval;
  legendScale(3)=maxval;
  if (maxval - minval)<=1000*eps
    maxval=minval+1000*eps;
  end
  x = fix ((matrix - minval) / (maxval - minval) *...
        (length (colorMap) - 1)) + 1;
  eimage(x,colorMap)

  % image axes
  if eYAxisWestScale(1)==eYAxisWestScale(3)
    eYAxisWestScale=[size(matrix,1) 0 0];
  end
  if eXAxisSouthScale(1)==eXAxisSouthScale(3)
    eXAxisSouthScale=[0 0 size(matrix,2)];
  end
  egrid;
  eaxes;

  % color legend
  if eImageLegendVisible
    if eImageLegendWidth==0
      if legendOrientation=='s' | ...
         legendOrientation=='n'
        xl=ePlotAreaWidth;
        yl=eImageLegendHeight;
        scaleLength=xl;
      else
        yl=ePlotAreaHeight;
        xl=eImageLegendHeight;
        scaleLength=yl;
      end
    else 
      if legendOrientation=='s' | ...
         legendOrientation=='n'
        xl=eImageLegendWidth;
        yl=eImageLegendHeight;
        scaleLength=xl;
      else
        xl=eImageLegendHeight;
        yl=eImageLegendWidth;
        scaleLength=yl;
      end
    end
    scaleSpace=eAxesTicLongLength+eAxesValueSpace+eAxesValueFontSize;
    if legendOrientation=='s'
     colorImage=(1:length(colorMap));
     legendPosX=ePlotAreaPos(1)+eImageLegendPos(1);
     legendPosY=ePlotAreaPos(2)+eImageLegendPos(2);
     scalePosX=legendPosX;
     scalePosY=legendPosY;
     textPosX=scalePosX+scaleLength/2;
     textPosY=scalePosY-scaleSpace-eAxesLabelFontSize*0.72-...
              eImageLegendLabelDistance;
     textAngle=0;
    elseif legendOrientation=='n'
     colorImage=(1:length(colorMap));
     legendPosX=(ePlotAreaPos(1)+eImageLegendPos(1));
     legendPosY=(ePlotAreaPos(2)+ePlotAreaHeight-eImageLegendPos(2));
     scalePosX=legendPosX;
     scalePosY=legendPosY+yl;
     textPosX=scalePosX+scaleLength/2;
     textPosY=scalePosY+scaleSpace+yl+eAxesLabelFontSize*0.72+...
              eImageLegendLabelDistance;
     textAngle=0;
    elseif legendOrientation=='e'
     colorImage=(length(colorMap):-1:1)';
     legendPosX=(ePlotAreaPos(1)+ePlotAreaWidth-eImageLegendPos(2));
     legendPosY=(ePlotAreaPos(2)+eImageLegendPos(1));
     scalePosX=legendPosX+xl;
     scalePosY=legendPosY;
     textPosX=scalePosX+scaleSpace+xl+eAxesLabelFontSize*0.72+...
              eImageLegendLabelDistance;
     textPosY=scalePosY+scaleLength/2;
     textAngle=90;
    elseif legendOrientation=='w'
     colorImage=(length(colorMap):-1:1)';
     legendPosX=(ePlotAreaPos(1)+eImageLegendPos(2)-xl);
     legendPosY=(ePlotAreaPos(2)-eImageLegendPos(1));
     scalePosX=legendPosX;
     scalePosY=legendPosY;
     textPosX=scalePosX-scaleSpace-eAxesLabelFontSize*0.72-...
              eImageLegendLabelDistance;
     textPosY=scalePosY+scaleLength/2;
     textAngle=90;
    end
    eimagexy(eFile,colorImage,colorMap,...
             legendPosX*eFac,legendPosY*eFac,xl*eFac,yl*eFac);
    erect(eFile,legendPosX*eFac,legendPosY*eFac,...
          xl*eFac,yl*eFac,eAxesLineWidth*eFac,[0 0 0]);
    escalexy(eFile,legendOrientation,...
             scalePosX*eFac,scalePosY*eFac,0,0,...
             scaleLength*eFac,...
             legendScale(1),...
             legendScale(2),...
             legendScale(3),...
             eImageLegendValueFormat,...
             eImageLegendVisible,...
             eAxesValueFontSize*eFac,...
             eAxesLineWidth*eFac,...
             eAxesTicShortLength*eFac,...
             eAxesTicLongLength*eFac,...
             eAxesTicLongMaxN,...
             eAxesValueSpace*eFac);
    if strcmp(eImageLegendLabelText,'')~=1
      etext(eImageLegendLabelText,...
             textPosX,...
             textPosY,...
             eAxesLabelFontSize,0,eAxesLabelTextFont,textAngle);  
    end
  end    
