%%NAME
%%  eclose - finish plot(s) and close EPS-file 
%%
%%SYNOPSIS
%%  eclose ([endOfPage])
%%
%%PARAMETER(S)
%%  endOfPage   switch for the postscript command 'showpage'
%%              if endOfPage=1 then append 'showpage' (default)
%%              else 'showpage' will not append
%%
%%GLOBAL PARAMETER(S)
%%  eWinFrameVisible
%%  eWinTimeStampVisible
% written by Stefan Mueller stefan.mueller@fgan.de

function eclose(endOfPage)
  eglobpar;
  if nargin>1
    usage('eclose([endOfPage])');
  end
  if nargin<1
    endOfPage=1;
  end
  if ePlotLineNr>0
    eplot
    ePlotLineNr=0;
  end
  if ePolarPlotLineNr>0
    epolar
    ePolarPlotLineNr=0;
  end
  if eWinTimeStampVisible
    timeStamp=clock;
    timeStampText=sprintf('epsTk %d.%d.%d %d:%d:%d File:%s',...
                          timeStamp(3),timeStamp(2),timeStamp(1),...
                          timeStamp(4),timeStamp(5),timeStamp(6),...
                          eFileName);
    etext(timeStampText,-1,0,eWinTimeStampFontSize,1,...
         eWinTimeStampFont,90);
  end
  if eWinFrameVisible
    erect(eFile,0,0,eWinWidth*eFac,eWinHeight*eFac,eWinFrameLineWidth,[0 0 0]);
  end
  if endOfPage==1
    eendpage(eFile);
  end
  fclose(eFile);
  message=sprintf('%s is written',eFileName);
  disp(message);
  if exist('close')
    close
  end
