%eclippol (epsFile,x,y,minRadius,maxRadius,angleStart,angleEnd)
% written by Stefan Mueller stefan.mueller@fgan.de 1997

function eclippol(epsFile,x,y,minRadius,maxRadius,angleStart,angleEnd)
  if nargin~=7 & nargin~=1
    usage ('eclippol(epsFile,x,y,minRadius,maxRadius,angleStart,angleEnd)');
  end
  if nargin~=1
    moveForm='%1.2f %1.2f 2 copy cos mul 3 1 roll sin mul moveto\n';
    arcForm='0 0 %1.2f %1.2f %1.2f arc\n';
    arcnForm='0 0 %1.2f %1.2f %1.2f arcn\n';
    fprintf(epsFile,'/clipPath { newpath\n');
    fprintf(epsFile,moveForm,minRadius,angleStart);
    fprintf(epsFile,arcForm,maxRadius,angleStart,angleEnd);
    fprintf(epsFile,arcnForm,minRadius,angleEnd,angleStart);
    fprintf(epsFile,'closepath}def\n');
    fprintf(epsFile,'gsave\n');
    fprintf(epsFile,'%1.2f %1.2f 2 copy translate clipPath clip\n',x,y);
    fprintf(epsFile,'neg exch neg exch translate\n');
  else
    fprintf(epsFile,'grestore\n');
  end
