/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips,
 * Celeste Fowler */

#include "instP.h"
#include "ooglutil.h"
#include "pickP.h"

static TmCoord (*coords2NDC(int system, Pick *p, Transform Tl2n))[4]
{
  switch(system) {
  case L_CAMERA: return p->Tc2n;
  case L_NDC:	 return TM3_IDENTITY;
  case L_SCREEN: return p->Ts2n;
  case L_GLOBAL: return p->Tw2n;
  default:	 return Tl2n;
  }
}

static TmCoord (*coordsbtwn(int from, int to, Pick *p, Transform Tl2n))[4]
{
    static Transform Tmap;

    if(from == L_NONE) from = L_LOCAL;
    if(to == L_NONE) to = L_LOCAL;
    if(from == to)
	return TM3_IDENTITY;

    if(to == L_NDC)
	return coords2NDC(from, p, Tl2n);

    TmInvert( coords2NDC(to, p, Tl2n), Tmap );
    TmConcat( coords2NDC(from, p, Tl2n), Tmap, Tmap );
    return Tmap;
}

Geom *
InstPick(Inst *inst, Pick *p, Appearance *ap, Transform T)
{
  int elem = 0, pathInd;
  Transform tT;
  GeomIter *it;
  Geom *v = NULL;

  if(inst == NULL || inst->geom == NULL)
    return NULL;

  if(inst->origin > L_LOCAL || inst->location > L_LOCAL) {
    TmTranslate( tT, p->x0, p->y0, 0. );
    TmConcat( T, tT, T );
    if(inst->origin > L_LOCAL) {
	Point3 originpt, originwas, delta;
	TmCoord (*l2o)[4], (*o2N)[4];
	Transform Tl2o;
	static HPoint3 zero = { 0, 0, 0, 1 };

	/* We have location2W, origin2W.
	 * We want to translate in 'origin' coords such that
	 * (0,0,0) in location coords maps to originpt in origin coords.
	 */
	o2N = coords2NDC(inst->origin, p, T);
	l2o = coordsbtwn(inst->location, inst->origin, p, T);
	HPt3TransPt3(l2o, &zero, &originwas);
	Pt3Sub(&inst->originpt, &originwas, &delta);
	TmTranslate( tT, delta.x, delta.y, delta.z );
	TmConcat( l2o, tT, Tl2o );
	TmConcat( T, Tl2o, tT );
	TmConcat( tT, o2N, T );

    } else {
	TmCopy( coords2NDC(inst->location, p, T), T );
    }
    TmTranslate( tT, -p->x0, -p->y0, 0. );
    TmConcat( T, tT, T );
  }

  pathInd = VVCOUNT(p->gcur);
  vvneeds(&p->gcur, pathInd + 1);
  VVCOUNT(p->gcur)++;
  it = GeomIterate((Geom *)inst, DEEP);
  while(NextTransform(it, tT)) {
    *VVINDEX(p->gcur, int, pathInd) = elem;
    TmConcat(tT,T, tT);
    if(GeomPick(inst->geom, p, ap, tT)) 
      v = (Geom *)inst;
    elem++;
  }
  VVCOUNT(p->gcur)--;
  return v;
}
