%{

#include <stdlib.h>
#include <string.h>
#include "parse.tab.h"

#define	yywrap()	1

static int inputpos=0;
static char *bufptr;
static int buflen;

void expr_lex_reset_input(char *buf)
{
  bufptr = buf;
  inputpos = 0;
  buflen = strlen(buf);
}

#undef YY_INPUT
#define YY_INPUT(buf,result,max_size) do_yy_input((buf),&(result),(max_size))

void do_yy_input(char *buf, int *result, int max_size)
{
  if (inputpos == buflen) {
    (*result) = 0;
  } else {
    int size = max_size < buflen-inputpos ? max_size : buflen-inputpos;
    memcpy (buf, bufptr+inputpos, size);
    (*result) = size;
    inputpos += size;
  }
}

%}

digit [0-9]
plusorminus [+-]
char .

%%


("."{digit}+|{digit}+("."{digit}*)?)("e"{plusorminus}?{digit}{digit}?)? { yylval.number = atof(yytext); return NUMBER; }
[a-zA-Z][a-zA-Z0-9_]* { yylval.string = malloc(strlen(yytext)+1); strcpy (yylval.string, yytext); return IDENT; }
{char} { if (*yytext != ' ' && *yytext != '\n' && *yytext != '\t') return *yytext; }
%%
/* more c stuff */
