static char rcsid[] = "$Id: scale_parms.c,v 1.3 1997/07/18 03:02:36 dhb Exp $";

/*
** $Log: scale_parms.c,v $
** Revision 1.3  1997/07/18 03:02:36  dhb
** Fix for getopt problem; getopt(), optopt and optind are now
** G_getopt(), G_optopt and G_optind.
**
** Revision 1.2  1993/02/24 21:14:54  dhb
** 1,4 to 2.0 command argument changes.
**
** removed old version of do_scale_parms under #ifdef OLD.
**
** Revision 1.1  1992/12/11  19:06:07  dhb
** Initial revision
**
*/

#include "sim_ext.h"

/*
** scale_parms : a utility function for parameter variations.
** scales the selected fields in a path by the given factors.
** The path and protopath are assumed to be wild card paths of elements,
** usually compartments in a cell model. The relpath is a fixed relative
** path off these compartments to a specific channel, whose field
** is to be scaled. Clearly, there should be complete correspondence
** between the prototype and the scaled path.
**
** By Upinder S. Bhalla, Caltech. March 1992
*/
do_scale_parms(argc,argv)
	int		argc;
	char	**argv;
{
	double scale;
	ElementList *proto,*dest;
	Info info;
	int		err_flag=0;
	int	 	offset;
	char	*address;
	short	datatype;
	char	protopath[200];
	char	destpath[200];
	char	*relpath,*field;
	int		i;

	initopt(argc, argv, "dest-path proto-path rel-path field scale-factor [additional_rel-path_field_scale-factor_args...]");
	if (G_getopt(argc, argv) != 0 || (optargc-3)%3 != 0)
	  {
	    printoptusage(argc, argv);
	    return;
	  }
	for(i=3;i+2<optargc;i++) {
		relpath=optargv[i]; i++;
		field=optargv[i]; i++;
		scale=Atod(optargv[i]);

		sprintf(destpath,"%s/%s",optargv[1],relpath);
		sprintf(protopath,"%s/%s",optargv[2],relpath);

		if (!(dest=WildcardGetElement(destpath,0))) {
			printf("Error : Could not get path %s\n",destpath);
			return;
		}
		if (strcmp(optargv[2],".")==0) {
			proto=dest;
		} else {
			if (!(proto=WildcardGetElement(protopath,0))) {
				printf("Error : Could not get path %s\n",protopath);
				FreeElementList(dest);
				return;
			}
		}
		if (proto->nelements != dest->nelements ||
			dest->nelements <= 0) {
			printf("Error : Invalid # of elms on  %s=%d;%s=%d have\n",
				destpath,dest->nelements,protopath,proto->nelements);
			err_flag=1;
		}

		if (!err_flag &&
			(address=CalculateAddress(dest->element[0],
			Type(dest->element[0]),field,&info)) == NULL) {
			printf("Error in %s. Field %s not found on path %s\n",
				optargv[0],field,optargv[1]);
			err_flag=1;
		}
		if (!err_flag) {
			offset=info.offset;
			datatype=GetDatatype(info.type);
		}
		if (!err_flag &&
			(address=CalculateAddress(proto->element[0],
			Type(proto->element[0]),field,&info)) == NULL) {
			printf("Error in %s. Field %s not found on path %s\n",
				optargv[0],field,optargv[2]);
			err_flag=1;
		}
		if (!err_flag &&
			offset!=info.offset || datatype != GetDatatype(info.type)) {
			printf("Error in %s. Field %s differs between %s and %s\n",
				optargv[0],field,destpath,protopath);
			err_flag=1;
		}
		if (!err_flag) {
			ScaleParm(proto,dest,offset,scale,datatype);
		}
		FreeElementList(dest);
		if (proto!= dest)
			FreeElementList(proto);
	}
}

ScaleParm(srcs,dests,offset,scale,datatype)
	ElementList *srcs,*dests;
	int		offset;
	double scale;
	short datatype;
{
	int i;
	switch(datatype) {
		case INT :
			for (i=0;i<dests->nelements;i++) {
				*((int *)((char *)(dests->element[i])+offset)) = 
				scale * *((int *)((char *)(srcs->element[i])+offset));
			}
		break;
		case FLOAT:
			for (i=0;i<dests->nelements;i++) {
				*((float *)((char *)(dests->element[i])+offset)) = 
				scale * *((float *)((char *)(srcs->element[i])+offset));
			}
		break;
		case DOUBLE:
			for (i=0;i<dests->nelements;i++) {
				*((double *)((char *)(dests->element[i])+offset)) = 
				scale* *((double *)((char *)(srcs->element[i])+offset));
			}
		break;
	}
}
