static char rcsid[] = "$Id: shell_setup.c,v 1.8 1995/07/28 01:24:44 dhb Exp $";

/*
** $Log: shell_setup.c,v $
** Revision 1.8  1995/07/28 01:24:44  dhb
** Removed the execute command from being addfunced at shell initialization.
**
** Revision 1.7  1995/06/16  05:59:42  dhb
** FreeBSD compatibility.
**
** Revision 1.6  1994/06/15  23:35:58  dhb
** Changed command result types for the debug, debugfunc and silent
** commands to int.
**
** Revision 1.5  1994/04/14  17:34:22  dhb
** Added extern char* getcwd() for SYSV systems
**
** Revision 1.4  1994/03/20  21:12:24  dhb
** Changes for C code startups
**
** Revision 1.3  1994/03/20  20:52:33  dhb
** 2.0 command names
** 	showcommands ==> listcommands
**
** Also removed a number of obsolete commands.
**
** Revision 1.2  1993/02/26  22:08:44  dhb
** 1.4 to 2.0 command name changes.
**
** Revision 1.1  1992/12/11  19:04:43  dhb
** Initial revision
**
*/

#include "shell.h"
#ifndef NEW
    ParseInit(){}
#endif

#ifdef NEW
SetUpFuncTable()
{
	AddFunc("debug",			do_debug	,"int");
	AddFunc("debugfunc",			do_debug_func	,"int");
	AddFunc("h",				ShowHistory	,"void");
	AddFunc("cd",				do_cd		,"int");
	AddFunc("echo",				do_echo		,"void");
	AddFunc("setprompt",			do_set_prompt	,"void");
	AddFunc("where",			do_where	,"void");
	AddFunc("exit",				do_exit		,"void");
	AddFunc("quit",				do_exit		,"void");
	AddFunc("tset",				tset		,"void");
	AddFunc("listcommands",			ShowFuncNames	,"void");
	AddFunc("printargs",			do_printargs	,"void");
	AddFunc("silent",			do_silent	,"int");
	AddFunc("setenv",			do_setenv	,"void");
	AddFunc("getenv",			do_getenv	,"char*");
	AddFunc("printenv",			do_printenv	,"void");
}

char *StripCR(s)
char *s;
{
char *ptr;

    ptr = s;
    for(ptr=s;*ptr != '\0' && *ptr != '\n';ptr++)
	;
    *ptr = '\0';
    return(s);
}

SetupInterp(file)
char	*file;
{
FILE *fp;
char *wd;
#ifdef SYSV
char *getcwd();
#else
char *getwd();
#endif
char tmp[300];
char tmpwd[300];

    /*
    ** check to see whether the executable can be opened
    */
    if((fp = SearchForExecutable(file,"r",&progname)) == NULL){
	return(0);
    }
    fclose(fp);
    /*
    ** construct the absolute pathname for the program if it has 
    ** has a relative specification
    */
    if(*progname  != '/'){
	/* getenv("PWD") */
/* mds3 changes */
#if defined(SYSV) || defined(__FreeBSD__)
      if((wd = (char *)getcwd(tmpwd, sizeof(tmpwd))) == NULL){
#else
      if((wd = getwd(tmpwd)) == NULL){
#endif
/* end of mds3 changes */
	    printf("unable to get the working directory\n");
	} else {
	    /* strcpy(tmpwd,wd); */
	    /*
	    ** get rid of CRs
	    */
	    wd = StripCR(tmpwd);
	    sprintf(tmp,"%s/%s",wd,progname);
	    progname = CopyString(tmp);
	}
    }
	if (IsSilent() < 2)
    	printf("%-20s%s\n","Executable:",progname);
    RecordStartTime();
    HashInit();
    if(Dynamic()){
	printf("initializing dynamic load module...\n");
	LoadFuncInit(file);
    }
    STARTUP_shell();
    SetUpFuncTable();
    DefaultPrompt();
    return(1);
}

Interpreter()
{
    yyparse();
}
#endif
