# $Id: pie.tcl,v 1.2 1998/10/19 23:26:04 cthulhu Exp $

# Pie

proc createPieGraph {cnt} {

    source "[xxl_library]/globalvars.tcl"
    global yScale xScale

    set cols [expr [lindex $graphRange 2]-[lindex $graphRange 0]+1]
    set rows [expr [lindex $graphRange 3]-[lindex $graphRange 1]+1]

    set ini [expr (($cols==1)? 0:1)]

    set canvas [canvasFromSheet $activeSheet]

    $canvas create rect $graphX $graphY \
            [expr $graphX+$graphWidth] [expr $graphY+$graphHeight] X \
            $graphCol $graphRow $graphCol $graphRow -fill white \
            -tag graph_$cnt

    
    #
    # Width of each bar
    #
    
    set gm $graphMargin

    if {$graphWidth > $graphHeight} {
	set gw [expr $graphHeight-2*$graphMargin]
	set gh  $gw 
	set gmx [expr ($graphWidth-$gw)/2]
	set gmy $graphMargin
    } else {
	set gh [expr $graphWidth-2*$graphMargin]
	set gw  $gh 
	set gmx $graphMargin
	set gmy [expr ($graphHeight-$gh)/2]
    }


    #
    # Find total
    #

    set total 0
    for {set j $ini} {$j < $cols} {incr j} {
        for {set i 0} {$i < $rows} {incr i} {
	    set temp [graphData $activeSheet $cnt $j $i 1]
	    if {$temp ==""} {set temp 0}
            set total [expr abs($temp) \
			   +$total]
        }
    }

	  
    if {$total==0} {set total 1}

    #
    # Draw axes
    # 

    $canvas create rect [expr $gmx+$graphX] [expr $gmy+$graphY] [expr $gmx+$gw+$graphX] \
	[expr $gmy+$gh+$graphY] X \
	$graphCol $graphRow $graphCol $graphRow \
	-fill gray80 -outline gray80 -tag graph_$cnt
    
    #
    # Draw legends
    #
    if {$ini!=0} {
	
        $canvas create rect [expr $graphX+$graphWidth] [expr $gmy+$graphY] \
	    [expr $graphX+$graphWidth+90] [expr $gmy+30*[expr $rows+1]+$graphY] X \
	    $graphCol $graphRow $graphCol $graphRow -fill white \
	    -tag graph_$cnt
	
	$canvas create text $graphCol $graphRow X \
	    [expr 2*$gmx+$gw+$graphX] [expr $gmy+$graphY+5] \
	    -text "Legend:" -anchor w -tag graph_$cnt
	
	for {set i 1} {$i <= $rows} {incr i} {
	    $canvas create rect \
		[expr 2*$gmx+$gw+3+$graphX] [expr $gmy+30*$i+$graphY] \
		[expr 2*$gmx+5*$gm/2+$gw+$graphX] \
		[expr $gmy+30*$i+15+$graphY] \
		X  $graphCol $graphRow $graphCol $graphRow -fill \
		[colorIndex [expr $i-1]] -tag graph_$cnt
	    
	    $canvas create text $graphCol [expr $graphRow-1] X \
		[expr 2*$gmx+[expr 5*$gm/2]+$gw+$graphX] \
		[expr $gmy+30*$i+18+$graphY] \
		-text  [string range [graphData $activeSheet $cnt 0 [expr $i-1]] 0 6] \
		-anchor w -tag graph_$cnt
	}
    }
    #
    # Draw pie slices
    #
    
    set parcial 0
    for {set i 0} {$i < $rows} {incr i} {
	set temp [graphData $activeSheet $cnt $ini $i 1]
	if {$temp ==""} {set temp 0}
	set x [expr -[expr abs($temp)]]
	
	$canvas create arc $graphCol $graphRow $graphCol $graphRow X\
	    [expr $gmx+$graphX] [expr $gmy+$graphY] [expr $gmx+$gw+$graphX] [expr $gmy+$gh+$graphY] \
	    -extent [expr 360.0*$x/$total] \
	    -start [expr 360.0*$parcial/$total] \
	    -fill [colorIndex $i] -tag graph_$cnt
	set parcial [expr $parcial+$x]

	#
	# Draw labels
	#
	
	set x1 [expr $graphX+$gmx-20+$gw/2.0+$gw/2.0*cos([expr 2.0*3.14*($parcial-$x/2.0)/$total])]
	set y1 [expr $graphY+$gmy-5+$gw/2.0-$gw/2.0*sin([expr 2.0*3.14*($parcial-$x/2.0)/$total])]

        $canvas create text $graphCol $graphRow X \
	    $x1 $y1 -text "[format %2.1f [expr 100*(-$x)/$total]]%" -anchor w  -tag graph_$cnt
    }

}

# $Log: pie.tcl,v $
# Revision 1.2  1998/10/19 23:26:04  cthulhu
# Fixed bug when displaying graphs with total col/row values adding up to zero.
#
# Revision 1.1  1998/08/17 20:11:22  cthulhu
# Initial revision
#
