// $Id: xxl_max.cc,v 1.3 1997/01/07 01:07:36 aml Exp $

#include "xxl_funcs.hh"
#include "sheet.hh"


Stack_elem *Max::eval(Stack_elem *p,Sheet *sheet, short col, short row) {
    double x;
    Range_iter r(p->contents.rg_val);
    Ref ref;
    Stack_elem *s;

    sheet->propagate_error(p,se);
    switch(p->type) {
      case FORM_FP:
      case FORM_INT:
      case FORM_REF:
      case FORM_STRING:
        x = sheet->stack_value(p);
        max = MAX(x,max);
        se->type = FORM_FP;
        se->contents.fp_val = max;
        return(se);
      case FORM_RANGE:
        short i,j;

        for(r.first(ref); !r.last();  r.next(ref)){
            i = cell_address(ref.col,col);
            j = cell_address(ref.row,row);
            s = sheet->cellRef(i,j);
            sheet->propagate_error(s,se);
            x = sheet->stack_value(s);
            max = MAX(x,max);
        }
        se->type = FORM_FP;
        se->contents.fp_val = max;
        return(se);
      default:
        internal_error();
    }
}

Max::Max() {
    max = -1.0e30; /* AML */
    se = new Stack_elem;
}

Max::~Max() {
    delete se;
}

// $Log: xxl_max.cc,v $
// Revision 1.3  1997/01/07  01:07:36  aml
// Error propagation for formulas fixed.
// Edit operations in place.
//
// Revision 1.2  1996/12/11  21:39:48  aml
// Sumif implemented.
// Diverse time functions implemented.
// Fixed needtoscroll2 to avoid out of control scroll.
//
// Revision 1.1  1996/03/08 12:49:05  aml
// Initial revision
//
