;;; mmelmo-1.el -- mm-backend (for FLIM 1.12.x) by ELMO.

;; Copyright 1998,1999,2000 Yuuichi Teranishi <teranisi@gohome.org>

;; Author: Yuuichi Teranishi <teranisi@gohome.org>
;; Keywords: mail, net news
;; Time-stamp: <2000-01-07 00:21:51 teranisi>

;; This file is part of ELMO (Elisp Library for Message Orchestration).

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.
;;

;;; Commentary:
;; 

;;; Code:
;; 

(require 'mime)
(require 'mime-parse)
(eval-when-compile
  (require 'std11))

(defvar mmelmo-force-reload nil)
(defvar mmelmo-sort-field-list nil)

;;; mmelmo: Only the initialization method is different from mmbuffer.
(mm-define-backend elmo (buffer))

(mm-define-method initialize-instance ((entity elmo))
  (mime-entity-set-buffer-internal 
   entity
   (get-buffer-create (concat mmelmo-entity-buffer-name "0")))
    (save-excursion
      (set-buffer (mime-entity-buffer-internal entity))
      (mmelmo-original-mode)
      (let ((buffer-read-only nil)
	    (location (mime-entity-location-internal entity))
	    header-start header-end body-start body-end)
	(erase-buffer)
	(setq mime-message-structure entity)
	(elmo-read-msg-with-buffer-cache (nth 0 location)
					 (nth 1 location)
					 (current-buffer)
					 (nth 2 location)
					 mmelmo-force-reload)
	(setq header-start (point-min))
	(setq body-end (point-max))
	(goto-char header-start)
	(if (re-search-forward 
	     (concat "^" (regexp-quote mail-header-separator) "$\\|^$" )
	     nil t)
	    (setq header-end (match-beginning 0)
		  body-start (if (= header-end body-end)
				 body-end
			       (1+ (match-end 0))))
	  (setq header-end (point-min)
		body-start (point-min)))
	(save-restriction
	  (narrow-to-region header-start header-end)
	  (mime-entity-set-content-type-internal
	   entity
	   (let ((str (std11-fetch-field "Content-Type")))
	     (if str
		 (mime-parse-Content-Type str)
	       )))
	  )
	(mime-entity-set-header-start-internal entity header-start)
	(mime-entity-set-header-end-internal entity header-end)
	(mime-entity-set-body-start-internal entity body-start)
	(mime-entity-set-body-end-internal entity body-end)
	)))

(defun mmelmo-mime-insert-header-from-buffer (buffer 
					      start end
					      &optional invisible-fields
					      visible-fields)
  (let ((the-buf (current-buffer))
	(mode-obj (mime-find-field-presentation-method 'wide))
	field-decoder
	f-b p f-e field-name len field field-body
        vf-alist (sl mmelmo-sort-field-list))
    (save-excursion
      (set-buffer buffer)
      (save-restriction
	(narrow-to-region start end)
	(goto-char start)
	(while (re-search-forward std11-field-head-regexp nil t)
	  (setq f-b (match-beginning 0)
		p (match-end 0)
		field-name (buffer-substring f-b p)
		len (string-width field-name)
		f-e (std11-field-end))
	  (when (mime-visible-field-p field-name
				      visible-fields invisible-fields)
	    (setq field (intern
			 (capitalize (buffer-substring f-b (1- p))))
		  field-body (buffer-substring p f-e)
		  field-decoder (inline (mime-find-field-decoder-internal
					 field mode-obj)))
            (setq vf-alist (append (list
                                    (cons field-name
                                          (list field-body field-decoder)))
                                   vf-alist))))
        (and vf-alist
             (setq vf-alist
                   (sort vf-alist
                         (function (lambda (s d)
                                     (let ((n 0) re
                                           (sf (car s))
                                           (df (car d)))
                                       (catch 'done
                                         (while (setq re (nth n sl))
                                           (setq n (1+ n))
                                           (and (string-match re sf)
                                                (throw 'done t))
                                           (and (string-match re df)
                                                (throw 'done nil)))
                                         t)))))))
        (with-current-buffer the-buf
          (while vf-alist
            (let* ((vf (car vf-alist))
                   (field-name (car vf))
                   (field-body (car (cdr vf)))
                   (field-decoder (car (cdr (cdr vf)))))
              (insert field-name)
	      (insert (if field-decoder
			  (funcall field-decoder field-body
                                   (string-width field-name))
			;; Don't decode
			field-body))
              (insert "\n"))
            (setq vf-alist (cdr vf-alist))))))))

(mm-define-method insert-header ((entity elmo)
				 &optional invisible-fields visible-fields)
  (mmelmo-mime-insert-header-from-buffer
   (mime-entity-buffer entity)
   (mime-entity-header-start-internal entity)
   (mime-entity-header-end-internal entity)
   invisible-fields visible-fields)
  )


(provide 'mmelmo-1)

;;; mmelmo-1.el ends here
