/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __SERVER_H__
#define __SERVER_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <sys/types.h>
#include <sys/socket.h>
/*#include <sys/param.h>*/
#include <arpa/inet.h>
#include <netdb.h>
#include <netinet/in.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "defines.h"
#undef MIN
#undef MAX
#include <glib.h>

/* apparently this is not defined for RedHat 5.2?? */
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif

/* define IPv4 dotted-decimal string length */
#ifndef INET_ADDRSTRLEN
#define INET_ADDRSTRLEN 16
#endif

/* define IPv6 hex string length */
#ifndef INET6_ADDRSTRLEN
#define INET6_ADDRSTRLEN 46
#endif

typedef guint port_t;

struct _server_
{
   gchar *hostname;
   gchar ip[INET_ADDRSTRLEN + 1];     /* IPv4 dotted decimal -> 16 chars + NULL */
   struct sockaddr_in sin;
   port_t port;
};

/* PLEASE use this typedef when creating a variable of this type */
typedef struct _server_ Server;

/* kept for compatability with old code */
typedef struct _server_ SmtpHost;
typedef struct _server_ Pop3Host;

/* use this resolve function if yer gonna use my Server type */
gint Resolve (Server *server);

/* use this resolve function if yer not gonna use type Server */
gint resolve (gchar *host_ip, gchar *hostname);

/* this resolve function is oogly...don't use it */
gint ipv4_resolve(gchar *host_ip, gchar *hostname);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
