/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __PARSE_H__
#define __PARSE_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <glib.h>
#undef MIN
#undef MAX
#include <stdio.h>
#include <string.h>
#include "mime.h"

/* getopts_long argument type */
typedef enum { no_arg, required_arg, optional_arg } golarg_t;

typedef struct {
   const gchar *name;
   golarg_t has_arg;
   /*gint *flag;*/
   gint val;
} longopts_t;

/* returns the position of the string or -1 if not found */
gint find_string(gchar *haystack, gchar *needle);

/* temporary replacement for strcasestr() since it isn't a standard function apparently */
gchar *strstrcase(gchar *haystack, gchar *needle);

/* inserts a string in the "pos" position... */
#define insert_string(a, b, c)   strninsert((a), (b), (c), sizeof(a))
void strninsert (gchar *string, gchar *insertstr, guint pos, size_t strmax);

/* removes the numchars number of chars starting at index */
#define remove_string(a, b, c)   strcut((a), (b), (c))
void strcut(gchar *line, guint index, guint numchars);

/* replaces 1 string with another string (first occurence only) */
gboolean replace_string(gchar *line, gchar *remove, gchar *replace);

/* trims all the spaces and tabs from the leading edge of the string */
void trim_leadspc (gchar *string);

/* trims all the trailing spaces/tabs/newlines from the string */
void trim_tailspc (gchar *string);

/* trims all the spaces/tabs/newlines from lead/tail of the string */
void trim_whtspc (gchar *string);

/* strips every occurance of a char in the string */
void strip(gchar *string, gchar c);

/* returns the number of fields in a string separated by the delimeter */
guint get_num_fields(gchar *string, gchar delim);

/* returns the field in the string given the delimiter */
gchar *get_field(gchar *string, guint field, gchar delim);

/* decode the 8-bit text */
gint parse_8bit(gchar *text);

/* 8-bit encode text */
gchar *make_8bit(unsigned char *text);

/* word wrap a body of text to `len` chars per line */
gchar *word_wrap(gchar *text, guint len);

/* quote a body of text by placing a "> " before each line */
gchar *quote_body (gchar *body, gchar *rcpt, gchar *date);

/* parse command-line for option chars */
gint getopts_short (gint argc, gchar *argv[], gchar *optstring);

/* parse the command-line for long options */
gint getopts_long (gint argc, gchar *argv[], gchar *optstring,
                   longopts_t *longopts, gint *longindex, gchar *param);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
