/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __FILTERS_H__
#define __FILTERS_H__

#include <gtk/gtk.h>
#undef MIN
#undef MAX
#include <stdio.h>
#include <stdlib.h>
#define __USE_GNU
#include <string.h>

#include "gtkmanip.h"
#include "globals.h"
#include "server.h"
#include "parse.h"
#include "rc.h"

struct filter
{
	gchar name[64];
	gint action;
	gchar to[128];
	gchar match[128];
	gchar in[128];
};

GtkWidget* create_frmFilters (void);

GtkWidget* create_dlgNewFilter (void);

void on_frmFilters_destroy (GtkObject *object, gpointer user_data);

void on_cmdFiltersCancel_clicked (GtkObject *object, gpointer user_data);

void on_dlgNewFilter_destroy (GtkObject *object, gpointer user_data);

void on_cmdFiltersOK_clicked (GtkWidget *object, gpointer user_data);

void on_cmdFiltersMoveComboButton_clicked (GtkWidget *object, gpointer user_data);

void on_cmdFiltersNew_clicked (GtkWidget *object, gpointer user_data);

void on_cmdFiltersDelete_clicked (GtkWidget *object, gpointer user_data);

void on_cmdFiltersApply_clicked (GtkWidget *object, gpointer user_data);

void on_dlgNewFilterOk_clicked (GtkWidget *object, gpointer user_data);

void on_clistrow_selected (GtkWidget *object, gint row, gint column, GdkEventButton *event, gpointer user_data);

void filters_refresh(void);

void filters_save(void);

int filters_read(void);

int check_filters(FILE *file);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
