

#include <stdio.h>
#include <stdlib.h>	/* defines getenv(3) */
#include <pwd.h>
#include <ctype.h>
#include <string.h>
#include <sys/param.h>

#include "sortmail.h"

#define	MAXLINE	256

#ifdef	DEBUG
#define	register
#endif

static	char	spooldir[] = SPOOLDIR ;

static	void	read_initfile() ;
static	void	parse_var() ;
static	void	set_var() ;
static	void	add_pat() ;
static	void	get_dest() ;

#define	NN(str)	((str)==NULL ? "-none-" : (str))

read_initfiles()
{
	struct passwd	*passwd ;

	/* first, try to set up some of the defaults */

	if( user == NULL ) {
	  if( (user = (char *) malloc(L_cuserid)) == NULL )
	    die("out of memory") ;
	  if( cuserid(user) == NULL )
	    die("can't determine username") ;
	}

	if( home == NULL ) {
	  if( (passwd = getpwnam(user)) != NULL )
	    home = strdup(passwd->pw_dir) ;
	  else if( (home = getenv("HOME")) == NULL )
	    die("can't determine %s's directory",user) ;
	}

	if( mailbox == NULL ) {
	  mailbox = (char *) malloc(sizeof(spooldir) + strlen(user)) ;
	  strcpy(mailbox, spooldir) ;
	  strcat(mailbox, user) ;
	}

	if( mailrc == NULL ) {
	  mailrc = (char *) malloc(strlen(home) + sizeof("/.mailrc") ) ;
	  strcpy(mailrc, home) ;
	  strcat(mailrc, "/.mailrc") ;
	}

	if( sortmailrc == NULL ) {
	  sortmailrc = (char *) malloc(strlen(home) + sizeof("/.sortmailrc") ) ;
	  strcpy(sortmailrc, home) ;
	  strcat(sortmailrc, "/.sortmailrc") ;
	}

	if( mbox == NULL )
	  mbox = MBOX ;

	if( folder == NULL )
	  folder = FOLDER ;

	read_initfile(mailrc) ;
	read_initfile(sortmailrc) ;
	if( verbose >= 2 ) {
	  fprintf(logfile,"$USER = %s\n", NN(user)) ;
	  fprintf(logfile,"$HOME = %s\n", NN(home)) ;
	  fprintf(logfile,"mailbox = %s\n", NN(mailbox)) ;
	  fprintf(logfile,"mailrc = %s\n", NN(mailrc)) ;
	  fprintf(logfile,"sortmailrc = %s\n", NN(sortmailrc)) ;
	  fprintf(logfile,"mbox = %s\n", NN(mbox)) ;
	  fprintf(logfile,"deflt = %s\n", NN(deflt)) ;
	  fprintf(logfile,"vacation = %s\n", NN(vacation)) ;
	  fprintf(logfile,"folder = %s\n", NN(folder)) ;
	}
}


static	void
read_initfile(file)
	char	*file ;
{
register FILE	*ifile ;
	char	line[MAXLINE] ;
register char	*ptr ;

	if( (ifile = fopen(file, "r")) != NULL ) {
	  while( fgets(line, MAXLINE, ifile) != NULL ) {
	    if( line[0] != '#' )
	    {
	      for( ptr = line; isspace(*ptr); ++ptr );

	      if( strmatch(ptr,"set") )	/* variable */
		parse_var(ptr) ;
	      else if( *ptr == '/' )	/* pattern */
		add_pat(ptr) ;
	      /* else ignore it */
	    }
	  }
	  fclose(ifile) ;
	}
}


static	void
parse_var(ptr)
register char	*ptr ;
{
	ptr += 3 ;	/* skip "set" */
	if( !isspace(*ptr) )
	  return ;		/* something was wrong */
	
	for(; isspace(*ptr); ++ptr );

	if( strmatch(ptr,"user") )
	  set_var(&user, ptr+4) ;
	else if( strmatch(ptr,"home") )
	  set_var(&home, ptr+4) ;
	else if( strmatch(ptr,"mailbox") )
	  set_var(&mailbox, ptr+7) ;
	else if( strmatch(ptr,"mailrc") )
	  set_var(&mailrc, ptr+6) ;
	else if( strmatch(ptr,"sortmailrc") )
	  set_var(&sortmailrc, ptr+10) ;
	else if( strmatch(ptr,"mbox") )
	  set_var(&mbox, ptr+4) ;
	else if( strmatch(ptr,"folder") )
	  set_var(&folder, ptr+6) ;
	else if( strmatch(ptr,"default") )
	  set_var(&deflt, ptr+7) ;
	else if( strmatch(ptr,"vacation") )
	  set_var(&vacation, ptr+8) ;
	else if( strmatch(ptr,"logfile") ) {
	  set_var(&logfilename, ptr+7) ;
	  if( (logfile = fopen(logfilename, "a")) == NULL )
	    logfile = stderr ;
	}
	/* else ignore it */
}

static	void
set_var(var, ptr)
register char	**var ;
register char	*ptr ;
{
	for(; isspace(*ptr); ++ptr );	/* consume blanks before '=' */

	if( *ptr != '=' )
	{
	  *var = "" ;
	  return ;
	}

	for(++ptr; isspace(*ptr); ++ptr ); /* consume blanks after '=' */

	if( *ptr == '\'' ) {
	  ++ptr ;
	  *var = strdup(ptr) ;
	  for(ptr=*var; *ptr != '\'' && *ptr != '\n' && *ptr != '\0'; ++ptr);
	  *ptr = '\0' ;
	}

	else if( *ptr == '"' ) {
	  ++ptr ;
	  *var = strdup(ptr) ;
	  for(ptr=*var; *ptr != '"' && *ptr != '\n' && *ptr != '\0'; ++ptr);
	  *ptr = '\0' ;
	}

	else {
	  *var = strdup(ptr) ;
	  for(ptr=*var; *ptr != '\n' && *ptr != '\0'; ++ptr);
	  *ptr = '\0' ;
	}
}



	/* try to make sense out of patterns in the form
		/regular expression/modifs:command
	*/

static	void
add_pat(ptr)
register char	*ptr ;
{
	char	buffer[1024] ;		/* KLUDGE! should be unlimited */
register char	*optr = buffer ;
register PatInfo *pat ;
register int	done, done2 ;

	++ptr ;				/* skip leading '/' */

	for(done=0;!done;)
	  switch( *ptr ) {
	    case '\0':
	      fprintf(logfile, "sortmail: missing '/' in pattern\n") ;
	      return ;
	    case '\\':			/* '\' quotes anything */
	      *optr++ = *ptr++ ;
	      *optr++ = *ptr++ ;
	      break ;
	    case '/':			/* '/' terminates */
	      ++ptr ;
	      done = 1 ;
	      break ;
	    case '[':			/* '[' starts a set */
	      *optr++ = *ptr++ ;
	      for(done2=0; !done2;)
		switch(*ptr) {
		  case '\0':		/* premature EOS, reject */
		    fprintf(logfile, "sortmail: missing ']' in pattern\n") ;
		    return ;
		  case ']':		/* ']' terminates a set */
		    done2=1 ;
		    *optr++ = *ptr++ ;
		    break ;
		  default:
		    *optr++ = *ptr++ ;
		    break ;
		}
	      break ;
	    default:
	      *optr++ = *ptr++ ;
	  }
	*optr++ = '\0' ;

	pat = (PatInfo *) malloc(sizeof(PatInfo)) ;
	pat->next = NULL ;
	if( patterns == NULL )
	  patterns = pat ;
	else
	  lastpat->next = pat ;
	lastpat = pat ;

	pat->pattern = strdup(buffer) ;
	pat->flags = P_SUBJECT ;
	pat->command = C_MAIL ;
	pat->dest = NULL ;

	/* parse modifiers part */

	for(done=0;!done;)
	  switch( *ptr ) {
	    case '\0': done = 1 ; break ;
	    case ':': ++ptr ; done = 1 ; break ;
	    case 't': pat->flags = P_TO ; ++ptr ; break ;
	    case 'f': pat->flags = P_FROM ; ++ptr ; break ;
	    case 's': pat->flags = P_SUBJECT ; ++ptr ; break ;
	    case 'h': pat->flags = P_HEADER ; ++ptr ; break ;
	    case 'a': pat->flags = P_ALL ; ++ptr ; break ;
	    default: ++ptr ; break ;
	  }

	while( isspace(*ptr) )
	  ++ptr ;

	/* parse command part */

	switch( *ptr ) {
	  case '\0': break ;
	  case 'm':
	    pat->command = C_MAIL ;
	    get_dest(pat, ++ptr) ;
	    break ;
	  case 'j': pat->command = C_JUNK ; ++ptr ; break ;
	  case 'f':
	    pat->command = C_FILE ;
	    get_dest(pat, ++ptr) ;
	    break ;
	  case '+':
	    pat->command = C_FILE ;
	    get_dest(pat, ptr) ;
	    break ;
	  case '|':
	    pat->command = C_PIPE ;
	    get_dest(pat, ++ptr) ;
	    break ;
	  default: ++ptr ; break ;
	}
}


static	void
get_dest(pat,ptr)
register PatInfo *pat ;
register char	*ptr ;
{
	for(; isspace(*ptr); ++ptr);

	pat->dest = strdup(ptr) ;
	if( (ptr = strchr(pat->dest, '\n')) != NULL )
	  *ptr = '\0' ;
}




int
filename_expand(dest, src)
	char	*dest ;
	char	*src ;		/* file to match */
{
	char		*lastsl ;	/* last '/' in template */
	char		*dirstr ;
	struct passwd	*passent ;

	if( src[0] == '/' ) {		/* absolute */
	  strcpy(dest, src) ;		/* that was easy */
	  return 0 ;
	}

	if( src[0] == '+' ) {		/* folder name */
	  strcpy(dest, home) ;
	  strcat(dest, "/") ;
	  strcat(dest, folder) ;
	  strcat(dest, "/") ;
	  strcat(dest, src+1) ;
	  return 0 ;
	}

	if( strmatch(src, "$HOME/") )
	{
	  strcpy(dest, home) ;
	  strcat(dest, src+5) ;
	  return 0 ;
	}

	if( src[0] != '~' ) {		/* relative path, assume relative */
	  strcpy(dest, home) ;		/* to $HOME	*/
	  strcat(dest, "/") ;
	  strcat(dest, src) ;
	  return 0 ;
	}



	/* cases:
	 *  "~"		fail
	 *  "~/		get home directory
	 *  "~xx	username matching
	 */

	if( src[1] == '/' )
	{
	  strcpy(dest, home) ;
	  strcat(dest, src+1) ;
	}
	else
	{
	  dirstr = strchr(src, '/') ;
	  if( dirstr != NULL )
	    *dirstr = '\0' ;
	  passent = getpwnam(src+1) ;
	  if( dirstr != NULL )
	    *dirstr = '/' ;
	  if( passent == NULL )
	    return -1 ;

	  strcpy(dest, passent->pw_dir) ;
	  if( dirstr != NULL )
	    strcat(dest, dirstr) ;
	  strcpy(src,dest) ;
	}
	return 0 ;
}
