/* DSTART                                                                    */
/*                                                                           */
/*           maildrop - mail delivery agent with filtering abilities         */
/*                                                                           */
/*  Copyright 1998-1999, Double Precision Inc.                               */
/*                                                                           */
/*  This program is distributed under the terms of the GNU General Public    */
/*  License. See COPYING for additional information.                         */
/* DEND                                                                      */
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	"config.h"
#include	"xconfig.h"
#include	"setgroupid.h"
#if HAVE_UNISTD_H
#include        <unistd.h>
#endif
#if HAVE_FCNTL_H
#include	<fcntl.h>
#endif
#if HAVE_SYS_STAT_H
#include	<sys/stat.h>
#endif

static const char rcsid[]="$Id: maildirmake.c 1.4 1999/09/09 05:03:28 mrsam Exp $";

static void usage()
{
	printf("Usage: maildirmake [-f folder] maildir\n");
	exit(1);
}

int main(int argc, char *argv[])
{
const char *maildir, *folder=0;
char *p;
int	argn;

	for (argn=1; argn<argc; argn++)
	{
		if (argv[argn][0] != '-')	break;
		if (strcmp(argv[argn], "-") == 0)	break;
		if (strncmp(argv[argn], "-f", 2) == 0)
		{
			folder=argv[argn]+2;
			if (*folder == 0 && argn+1 < argc)
				folder=argv[++argn];
			continue;
		}
		usage();
	}

	if (argn == argc)	usage();
	maildir=argv[argn];

	if (folder && *folder == '.')
	{
		printf("Invalid folder name: %s\n", folder);
		exit(1);
	}

#if	RESET_GID
	setgroupid(getgid());
#endif
	setuid(getuid());	/* Drop any setuid privileges. */

	if (folder)
	{
		if ((p=(char *)malloc(strlen(folder)+2)) == 0)
		{
			perror("maildirmake");
			exit(1);
		}
		p[0]='.';
		strcpy(p+1, folder);
		folder=p;
	}

	if ((folder && chdir(maildir)) ||
		mkdir(folder ? folder:maildir, 0700) < 0 ||
		chdir(folder ? folder:maildir) < 0 ||
		mkdir("tmp", 0700) < 0 ||
		mkdir("new", 0700) < 0 ||
		mkdir("cur", 0700) < 0 ||
		(folder && open("maildirfolder", O_CREAT|O_WRONLY, 0600) < 0))
	{
		perror("maildirmake");
		exit(1);
	}
	exit(0);
	return (0);
}
