
static char rcsid[] = "@(#)$Id: wordwrap.c,v 1.3 1999/04/11 18:11:35 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.3 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/***  Routines to wrap lines when using the "builtin" editor

***/

#include "headers.h"
#include <errno.h>
#include "me.h"

extern int errno;		/* system error number */

unsigned alarm();

#define isstopchar(c)		(c == ' ' || c == '\t')
#define isslash(c)		(c == '/')
#define erase_a_char()		{ Writechar(BACKSPACE); Writechar(' '); \
			          Writechar(BACKSPACE); fflush(stdout); }

	/* WARNING: this macro destroys nr */
#define erase_tab(nr)		do Writechar(BACKSPACE); while (--(nr) > 0)

static int line_wrap P_((char *,char *,int *,int *, int)); /* Prototype */

int wrapped_enter(string, tail, x, y, edit_fd, append_current,
		  size_string, size_tail)
     char *string, *tail;
     int  x,y, *append_current;
     FILE *edit_fd;
     int size_string, size_tail;
{
	/** This will display the string on the screen and allow the user to
	    either accept it (by pressing RETURN) or alter it according to
	    what the user types.   The various flags are:
	         string    is the buffer to use (with optional initial value)
		 tail	   contains the portion of input to be wrapped to the
			   next line
	 	 x,y	   is the location we're at on the screen (-1,-1 means
			   that we can't use this info and need to find out
			   the current location)
		 append_current  means that we have an initial string and that
			   the cursor should be placed at the END of the line,
			   not the beginning (the default).
	      
	    If we hit an interrupt or EOF we'll return non-zero.
	**/

	int ch, wrapcolumn = 70, iindex = 0;
	int addon = 0;	/* Space added by tabs. iindex+addon == column */
	int tindex = 0;	/* Index to the tabs array. */
	int tabs[10];	/* Spaces each tab adds. size <= wrapcolumn/8+1 */
	register int ch_count = 0, escaped = OFF;
	long newpos, pos;
	char line[SLEN];

	clearerr(stdin);

	if(!(x >=0 && y >= 0))
	  GetXYLocation(&x, &y);
	PutLineX(x, y, FRM("%s"), string);	

	CleartoEOLN();

	if (! *append_current) {
	  MoveCursor(x,y);
	}
	else
	  iindex = strlen(string);

	/** now we have the screen as we want it and the cursor in the 
	    right place, we can loop around on the input and return the
	    string as soon as the user presses <RETURN> or the line wraps.
	**/

	do {
	  ch = ReadCh(0|READCH_NOCURSOR);

	  if (ch == eof_char && !escaped 
	      || ch == EOF) {		/* we've hit EOF */
	    *append_current = 0;
	    return(1);
	  }

	  if (ch_count++ == 0) {
	    if (ch == '\n' || ch == '\r') {
	      *append_current = 0;
	      return(0);
	    }
	    else if (! *append_current) {
	      CleartoEOLN();
	      iindex = (*append_current? strlen(string) : 0);
	    }
	  }

	  /* the following is converted from a case statement to
	     allow the variable characters (backspace, kill_line
	     and break) to be processed.  Case statements in
	     C require constants as labels, so it failed ...
	  */

	  if (ch == backspace) {
	    escaped = OFF;
	    if (iindex > 0) {
  	      iindex--;
	      if (string[iindex] == '\t') {
		addon -= tabs[--tindex] - 1;
		erase_tab(tabs[tindex]);
	      } else erase_a_char();

#ifdef FTRUNCATE

	    } else { /** backspace to end of previous line **/

	      fflush(edit_fd);
	      if ((pos = ftell(edit_fd)) <= 0L) { /** no previous line **/
		Writechar('\007');

	      } else {

		/** get the last 256 bytes written **/
		if ((newpos = pos - (long)(sizeof line)) <= 0L) 
		  newpos = 0;
		fseek(edit_fd, newpos, SEEK_SET);
		fread(line, sizeof(*line), (int) (pos-newpos),
		      edit_fd);
		pos--;

		/** the last char in line should be '\n'
			change it to null **/
		if (line[(int) (pos-newpos)] == '\n')
		  line[(int) (pos-newpos)] = '\0';

		/** find the end of the previous line ('\n') **/
		for (pos--; pos > newpos && line[(int) (pos-newpos)] != '\n';
			pos--);
		/** check to see if this was the first line in the file **/
		if (line[(int) (pos-newpos)] == '\n') /** no - it wasn't **/
		  pos++;
		(void) strfcpy(string, &line[(int) (pos-newpos)],
			       size_string);
		line[(int) (pos-newpos)] = '\0';

		/** truncate the file to the current position
			THIS WILL NOT WORK ON SYS-V **/
		(void) fseek(edit_fd, newpos, SEEK_SET);
		(void) fputs(line, edit_fd);
		fflush(edit_fd);
		(void) ftruncate(fileno(edit_fd), (int) ftell(edit_fd));
		(void) fseek(edit_fd, ftell(edit_fd), SEEK_SET);

		/** rewrite line on screen and continue working **/
		GetXYLocation(&x, &y);
		if (x > 0) x--;
		PutLineX(x, y, FRM("%s"), string);
		CleartoEOLN();
		iindex = strlen(string);

		/* Reload tab positions */
		addon = tindex = 0;
		for (pos = 0; pos < iindex; pos++)
		  if (string[pos] == '\t')
		    addon += (tabs[tindex++] = 8 - ((pos+addon) & 07)) - 1;
	      }

#endif

	    }
	    fflush(stdout);
	  }
	  else if (ch == EOF || ch == '\n' || ch == '\r') {
	    escaped = OFF;
	    string[iindex] = '\0';
	    *append_current = 0;
	    return(0);
	  }
	  else if (ch == word_erase && !escaped) {	/* back up a word! */
	    escaped = OFF;
	    if (iindex == 0)
	      continue;		/* no point staying here.. */
	    iindex--;
	    if (isslash(string[iindex])) {
	      erase_a_char();
	    }
	    else {
	      while (iindex >= 0 && isspace(string[iindex])) {
		if (string[iindex] == '\t') {
		  addon -= tabs[--tindex] - 1;
		  erase_tab(tabs[tindex]);
		} else erase_a_char();
	        iindex--;
	      }

	      while (iindex >= 0 && ! isstopchar(string[iindex])) {
	        iindex--;
	        erase_a_char();
	      }
	      iindex++;	/* and make sure we point at the first AVAILABLE slot */
	    }
	  }
	  else if (ch == reprint_char && !escaped) {
	    escaped = OFF;
	    string[iindex] = '\0';
	    PutLineX(x,y, FRM("%s"), string);	
	    CleartoEOLN();
	  }
	  else if (!escaped && ch == kill_line) {
	    /* needed to test if escaped since kill_line character could
	     * be a desired valid printing character */
	    escaped = OFF;
	    MoveCursor(x,y);
	    CleartoEOLN();
	    iindex = 0;
	  }
	  else if (ch == '\0' || 
		   ch == interrupt_char && !escaped) {
	    escaped = OFF;
	    fflush(stdin); 	/* remove extraneous chars, if any */
	    string[0] = '\0'; /* clean up string, and... */
	    *append_current = 0;
	    return(-1);
	  }
	  else if (
		   (
#ifdef ASCII_CTYPE
		    !isascii(ch)||
#endif
		    !isprint(ch)) 
		   && ch != '\t') {
	    /* non-printing character - warn with bell*/
	    /* don't turn off escaping backslash since current character
	     * doesn't "use it up".
	     */
	    Writechar('\007');
	  }
	  else {  /* default case */
	      if(escaped && (ch == backspace || ch == kill_line)) {
		/* if last character was a backslash,
		 * and if this character is escapable
		 * simply write this character over it even if
		 * this character is a backslash.
		 */
		Writechar(BACKSPACE);
		iindex--;
		string[iindex++] = ch;
		Writechar(ch);
	        escaped = OFF;
	      } else if (iindex < size_string-2) {
		if (ch == '\t')
		  addon += (tabs[tindex++] = 8 - ((addon+iindex) & 07)) - 1;

		string[iindex++] = ch;
		Writechar(ch);
		escaped = ( ch == '\\' ? ON : OFF);
	      }
	  }
	} while (iindex+addon < wrapcolumn && 
		 iindex < size_string-2);

	string[iindex] = '\0';
	*append_current = line_wrap(string,tail,&iindex,&tabs[tindex-1],
				    size_tail);

	return(0);
}

static int line_wrap(string,tail,count,tabs, size_tail)
     char *string;	/* The string to be wrapped */
     char *tail;	/* The part of the string which is wrapped */
     int *count;	/* Offset of string terminator */
     int *tabs;	/* List of how many spaces each tab adds */
     int size_tail;
{
	/** This will check for line wrap.  If the line was wrapped,
	    it will back up to white space (if possible), write the
	    shortened line, and put the remainder at the beginning
	    of the string.  Returns 1 if wrapped, 0 if not.
	**/

	int n = *count;
	int i, j;

	/* Look for a space */
	while (n && !isstopchar(string[n]))
	  --n;

	/* If break found */
	if (n) {

	  /* Copy part to be wrapped */
	  for (i=0,j=n+1;
	       j<=*count &&
		 i < size_tail-1;
	       tail[i++]=string[j++]);

	  tail[i] = '\0';
	  /* Skip the break character and any whitespace */
	  while (n && isstopchar(string[n]))
	    --n;

	  if (n) n++; /* Move back into the whitespace */
	}

	/* If no break found */
	if (!n) {
	  (*count)--;
	  strfcpy(tail, &string[*count], size_tail);
	  erase_a_char();
	} else /* Erase the stuff that will wrap */
	  while (*count > n) {
	    --(*count);
	    if (string[*count] == '\t') erase_tab(*tabs--);
	    else erase_a_char();
	  }

	string[*count] = '\0';
	return(1);
}

