static char rcsid[] = "@(#)$Id: pgp.c,v 1.6.4.2 1999/10/10 15:57:05 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.6.4.2 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *
 *  Initially written by: Michael Elkins <elkins@aero.org>, 1995
 *****************************************************************************/

#include "headers.h"
#include "me.h"
#include "s_elm.h"

#ifdef USE_PGP
#include <sys/time.h>
#include <errno.h>
#include "menu.h"

extern int errno;

/* the column in which the userid begins in the 'pgp -kv' command output */
#define PGP2_USERID_OFFSET 30
#define PGP5_USERID_OFFSET 5
#define GPG_USERID_OFFSET 30

static char * PGPSelectKey P_((char *n, char **k, int len));

/* 'n' is the key we are looking for.  'k' is the list of possible matches
   which contains 'len' entries.  prompt the user for which key s/he really
   wants to use. */
static char * PGPSelectKey (n, k, len)
     char *n;
     char **k;
     int len;
{
    int i;
    char buf[STRING];
    menu_t menu;
    
    elm_sfprintf(buf, sizeof buf,
		 CATGETS(elm_msg_cat, ElmSet, ElmPgpMultipleKeys,
			 "Multiple keys match '%s':"), 
		 n);
    MenuInit (&menu, buf, catgets(elm_msg_cat, ElmSet, ElmPgpSelectKey,
				  "Select key or 'q' to quit: "),
	      0);
    
    for (i = 0; i < len; i++)
	MenuAdd(&menu, k[i]);
    
    for (;;) {
	switch (MenuLoop(&menu)) {
	case 'q':
	    MenuDestroy(&menu);
	    return(0);
	case '\n':
	case '\r':
	    MenuDestroy(&menu);
	    return(k[MenuCurrent(menu)]);
	}
    }
    /* not reached */
}

static int GetPGPKey P_((char *name, char *target,
			 int targetsize, enum pgp_version v));

static int GetPGPKey (name, target, targetsize, v)
	char *name;
	char *target;
	int targetsize;
	enum pgp_version v;
{
    /* given "name", return the string to use during the pgp call to specify 
       the key which the user means.  return -1 on error. */
    
    char buf[STRING], address[STRING], *c, **keys=0, *pc, userpart[STRING];
    int i=0, keys_len=0, keys_max=0, return_val=0, start=0;
    FILE *p;
    
    if (!name || !target) {
	dprint (9, (debugfile, "GetPGPKey=-1\n"));
	return -1;
    }
    dprint (9, (debugfile, "GetPGPKey: name=%s,v=%d\n",name,v));

    if (index(name, '@') == NULL && index(name, '(') == NULL && 
	index(name, '<') == NULL) {
	/* this is either just a username, or someone's real name.  in either
	   case it only needs to be checked once. */
	
	strfcpy(address, name, sizeof address);
	i = 2;
    }
    else {
	get_address_from (name, address, sizeof address);
	
	i=0;
	while (address[i] && address[i] != '@') {
	    userpart[i] = address[i];
	    i++;
	}
	userpart[i] = '\0';
	
	i = 0;
    }
    c = address;
    
    /* the following loop first checks to see if any keys with the full
       address, or real name, or finally the username exist */

    for (;;) {
	int fd[2];
	
	if (pipe (fd) == -1) {
	    dprint (1, (debugfile, "GetPGPKey()=-1: ERROR: pipe (errno %d)\n",
			errno));

	    return -1;
	}

	while (*c && isspace (*c)) c++; /* move past any leading space! */

	dprint (40, (debugfile, "GetPGPKey: c=%s\n",c));    

	if (fork () == 0) {
	    int tmp;
	    
	    setgid(groupid);
	    setuid(userid);
	    
	    close (fd[0]);
	    close (1);
	    dup (fd[1]);
	    close (fd[1]);

	    switch(v) {
		char *path;
	    case pgp2:	
		
		execl(pgp2_path, 
		      pgp2_path,"+verbose=0", "+language=en", "-kv", c, 
		      (char *)0);
		tmp = errno;
		perror(pgp2_path);
		break;
	    case pgp5:
		path = elm_message(FRM("%s/pgpk"),pgp5_dir);
		execl(path,
		      path, "+verbose=0","+language=en", 
		      "-l", c, (char *)0);       	
		tmp = errno;
		perror(path);
		break;
	    case gpg:
		execl(gpg_path, 
		      gpg_path,"--list-public-keys",c,(char *)0);
		tmp = errno;
		perror(path);
		break;
	    }
	    _exit(tmp);
	}

	close (fd[1]);
	p = fdopen (fd[0], "r");
	if (p == NULL) {
	    dprint (1, (debugfile, 
			"GetPGPKey()=-1: ERROR: fdopen (errno %d)\n", errno));
	    return -1;
	}

	while (fgets(buf, STRING, p) != NULL) {
	    dprint (40, (debugfile, "GetPGPKey: %s\n",buf));
	    switch(v) {
	    case pgp2:	
	    case gpg:

		/* see if we've reached the beginning of the key listings... */
		
		if (!start && strncmp(buf, "pub", 3)==0)
		    start=1;
		
		if (start) {
		    int Len;
		    
		    /* if we've read all the keys, stop here */
		    if (buf[0] != 'p' && buf[0] != ' ')
			break;
		    
		    if (keys_len == keys_max)
			keys = (char**)DynamicArray(keys, sizeof(char*), 
						    &keys_max, 5);
		    
		    pc = rindex(buf, '\n');
		    if (!pc) /* this shouldn't happen! */
			continue;
		    *pc = '\0';
		    switch(v) {
		    case pgp2: pc = buf + PGP2_USERID_OFFSET; break;
		    case gpg:  pc = buf + GPG_USERID_OFFSET; break;
		    }
		    Len = strlen(pc)+1;
		    keys[keys_len] = (char*)safe_malloc(Len);
		    strfcpy(keys[keys_len], pc, Len);
		    ++keys_len;
		}
		break;
	    case pgp5:	
		if (strncmp(buf, "uid", 3)==0) {
		    int Len;

		    if (keys_len == keys_max)
			keys = (char**)DynamicArray(keys, sizeof(char*), 
						    &keys_max, 5);
		    
		    pc = rindex(buf, '\n');
		    if (!pc) /* this shouldn't happen! */
			continue;
		    *pc = '\0';
		    
		    pc = buf + PGP5_USERID_OFFSET;
		    Len = strlen(pc)+1;
		    keys[keys_len] = (char*)safe_malloc(Len);
		    strfcpy(keys[keys_len], pc, Len);
		    ++keys_len;
		}
	    }
	}
	fclose(p);
	if (keys_len > 0 || i > 1)
	    break;
	else {
	    if (i == 0) {
		strfcpy(address,name, sizeof address);
		parse_arpa_who(name,address, 
			       decode_who_none,		       
			       sizeof address);

		/* if there was no real name, go on to the userpart check */
		if (strcmp(name, address) == 0) {
		    c = userpart;
		    i++;
		}
	    } else if (i == 1)
		c = userpart;
	    i++;
	}
    }
    
    if (keys_len == 1) /* perfect match! */
	get_address_from(keys[0], target, targetsize);
    else if (keys_len > 1) { /* ask the user which, if any, s/he meant */
	c = PGPSelectKey(name, keys, keys_len);
	if (c)
	    get_address_from(c, target, targetsize);
	else {
	    target[0] = '\0';
	    return_val = -1;
	}
    } else
	return_val = -1;
    
    DestroyDynamicArray(keys);
    
    dprint (9, (debugfile, "GetPGPKey(name=%s)=%d\n",name,return_val));
    return return_val;
}

static int pgp_call P_((char *filename,int opts,
			struct mailing_headers *headers,
			enum pgp_version v));

static int pgp_encrypt P_((char *filename, char *ids, char *sig,
			   int opts, int metoo,
			   enum pgp_version v));

static int pgp_call (filename, opts, headers, v)
	char *filename;
	int opts;
	struct mailing_headers *headers;
	enum pgp_version v;
{
    char tobuf[VERY_LONG_STRING] = {0};
    char frombuf[VERY_LONG_STRING] = {0};
    int status;
    int r;
    
    do {
	if (opts & PGP_MESSAGE) {
	    struct addr_item *x;
	    /* build up the list of recipients */
	    tobuf[0] = '\0';
	    
	    for (x = headers->to.addrs; 
		 x < headers->to.addrs + headers->to.addrs_len;
		 x++) {
		if (tobuf[0])
		    strfcat(tobuf, ", ", sizeof tobuf);
	    strfcat(tobuf, x->addr, sizeof tobuf);
	    }
	    for (x = headers->cc.addrs; 
		 x < headers->cc.addrs + headers->cc.addrs_len;
		 x++) {
		if (tobuf[0])
		    strfcat(tobuf, ", ", sizeof tobuf);
		strfcat(tobuf, x->addr, sizeof tobuf);
	    }
	    for (x = headers->bcc.addrs; 
		 x < headers->bcc.addrs + headers->bcc.addrs_len;
		 x++) {
		if (tobuf[0])
		    strfcat(tobuf, ", ", sizeof tobuf);
		strfcat(tobuf, x->addr, sizeof tobuf);
	    }
	    
	    /* If the message is to be encrypted, give the user a chance to 
	     * edit the list of ids to encrypt to since the given address may 
	     * not always be correct.
	     */
	redraw:
	    PutLineX (elm_LINES-2, 0, CATGETS(elm_msg_cat, ElmSet, ElmPgpTo,
					      "To%s"),
		      ": ");
	    status = optionally_enter (tobuf, elm_LINES-2, 4, 
				       OE_APPEND_CURRENT|OE_REDRAW_MARK,
				       sizeof tobuf);
	    if (REDRAW_MARK == status)
		goto redraw;
	    if (status < 0 || tobuf[0] == '\0')
		return FALSE;
	}

	if (pgp_askpgpsig && (opts & PGP_SIGNED_MESSAGE)) {
	    /* If the message is to be signed, give the user a chance to 
	     * specify with which signature.
	     */
	    strfcat(frombuf, username, sizeof frombuf);
	redraw2:
	    PutLineX (elm_LINES-2, 0, CATGETS(elm_msg_cat, ElmSet, ElmPgpFrom,
					      "From%s"),
		      ": ");
	    status = optionally_enter (frombuf, elm_LINES-2, 6,
				       OE_APPEND_CURRENT|OE_REDRAW_MARK,
				       sizeof frombuf);
	    if (REDRAW_MARK == status)
		goto redraw2;
	    if (status < 0 || frombuf[0] == '\0')
		return FALSE;
	}
	r = pgp_encrypt (filename, tobuf, frombuf, opts, auto_cc, v);
    } while (r < 0);
    if (r < 0)
	r = 0;
    return (r);
}

static void close_it P_((struct run_state *rs));
static void close_it(rs)
     struct run_state *rs;
{
    int *close_fd = rs->ext_init_data;

    if (*close_fd != -1)
	close(*close_fd);
}

static int pgp_encrypt (filename, ids, sig, opts, metoo, v)
     char *filename, *ids, *sig;
     int opts, metoo;
     enum pgp_version v;
{
    int i, id_len=0, id_max=0, usepgppass=FALSE, fd[2];
    char
	keyid[STRING], buf[VERY_LONG_STRING], buf2[STRING], **id_array=0, *c,
	*p;
    char ** joined = NULL;
    int close_fd;  
#define MAX_ARG 1000
    char * argv[MAX_ARG];
    char * env[2];
    int a;
    int ret;
    struct run_state RS;
    int exit_code;

    dprint (2, (debugfile, 
		"pgp_encrypt(): ids=\"%s\", signwith=\"%s\", encrypt=%s, sign=%s\n", 
		ids, sig, 
		opts & PGP_MESSAGE ? "TRUE" : "FALSE", 
		opts & PGP_SIGNED_MESSAGE ? "TRUE" : "FALSE"));

    p = ids;
    /* If this message is to be encrypted, look up the keys of all the
       recipients */
    if (opts & PGP_MESSAGE) {
	i=0;
	while ((c = strtok(p, ",")) != NULL) {
	    int Len;
	    
	    while (whitespace(*c))
		c++;
	    if ('\0' == *c)
		goto next_recipient;

	    if (GetPGPKey(c, keyid, sizeof keyid, v) == -1) {
		while(1) {
		    int x_coord, y_coord, ans;
		    int def_ans = 'q';
		    MoveCursor (elm_LINES-3, 0);
		    CleartoEOS ();
		    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmPgpNoMatch,
				      "Couldn't find key matching '%s'!"),
			      c);
		    Centerline (elm_LINES-2, 
				catgets(elm_msg_cat, ElmSet, ElmPgpKeyError,
					"e)dit recipient list, s)kip recipient, q)uit"));
		    PutLineX (elm_LINES-3, 0, CATGETS(elm_msg_cat, ElmSet, 
						      ElmPgpSelect,
						      "Select [e/s/q]: "));
		    GetXYLocation(&x_coord, &y_coord);
		    PutLineX (x_coord, y_coord,FRM("%c"),def_ans);
		    MoveCursor(x_coord, y_coord);
		    
		    switch((ans = ReadCh(REDRAW_MARK))) {
		    case '\n':
		    case '\r':
			ans = def_ans;
		    }

		    switch(ans) {
		    case 'e':
			Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
						ElmPgpEditRec,
						"Edit recipients"));
			return -1; /* Indicate KEY error */
		    case 's':
			Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
						ElmPgpSkipRec,
						"Skip recipients"));
			goto next_recipient;
		    case 'q':
			Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
						ElmPgpQuit,
						"Quit"));
			return 0;
		    }
		}
	    }
	    if (id_len == id_max)
		id_array = (char**)DynamicArray(id_array, sizeof(char*), &id_max, 25);
	    Len = strlen(keyid) + 1;
	    id_array[id_len] = (char*)safe_malloc(Len);
	    strfcpy(id_array[id_len], keyid, Len);
	    id_len++;
	next_recipient:
	    p=NULL;
	}
	/* If all recpients s)kipped */
	if (id_len < 1 || !id_array[0]) {
	    return 0;
	}
    }
    if (id_len == id_max)
	id_array = (char**)DynamicArray(id_array, sizeof(char*), &id_max, 1);
    id_array[id_len] = NULL;

    if ((opts & PGP_SIGNED_MESSAGE) && pgp_keeppass && 
	pgp_goodPassphrase(v)) {
	usepgppass = TRUE;
	pipe(fd);
    }

    close_fd = -1;
    env[0] = NULL;
    RS.ext_env = env; 
    RS.ext_init_data = &close_fd;
    RS.ext_init      = close_it;

    switch(v) {
    case pgp2:
    case pgp5:
	if (usepgppass) {
	    static char buffer[20];
	    elm_sfprintf(buffer, sizeof buffer,FRM("PGPPASSFD=%d"),
			 fd[0]);
	    env[0] = buffer;
	    close_fd = fd[1];
	}
	env[1] = NULL;
    }

    /* copy the file into it's final destination */
    elm_sfprintf(buf, sizeof buf,
		 FRM("%s.asc"), filename);

    Raw(OFF);
    ClearScreen();
    Write_to_screen(CATGETS(elm_msg_cat, ElmSet,ElmRunningPgp,
			      "Running PGP..."));
    Write_to_screen(FRM("\n\n"));

    a = 0;
    switch(v) {
	static char path[1000];
	int i;	
    case pgp2:	
	argv[a++] = pgp2_path;
	if (metoo)
	    argv[a++] = "+encrypttoself=on";
	if (usepgppass || !(opts & PGP_SIGNED_MESSAGE))
	    argv[a++] = "+batchmode";
	if (opts & PGP_SIGNED_MESSAGE)
	    argv[a++] = "+clearsig=on";
	argv[a++] = "+verbose=0";
	switch (opts & (PGP_SIGNED_MESSAGE|PGP_MESSAGE)) {
	case PGP_SIGNED_MESSAGE|PGP_MESSAGE:
	    argv[a++] = "-atwse";
	    break;
	case PGP_SIGNED_MESSAGE:
	    argv[a++] = "-atws";
	    break;
	case PGP_MESSAGE:
	    argv[a++] = "-atwe";
	    break;
	}

	if (pgp_askpgpsig && (opts & PGP_SIGNED_MESSAGE)) {
	    argv[a++] = "-u";
	    argv[a++] = sig;
	}
	argv[a++] = filename;
	argv[a] = NULL;
	
	joined = join_argv(argv,id_array);

	ret = start_run(&RS,SY_RUN_STATE_ENV|SY_RUN_STATE_INIT,
			joined,-1,-1);

	break;
    case pgp5:
	if (opts & PGP_MESSAGE) 
	    elm_sfprintf(path, sizeof path,FRM("%s/pgpe"),pgp5_dir);
	else
	    elm_sfprintf(path, sizeof path,FRM("%s/pgps"),pgp5_dir);
	argv[a++] = path;
	if (metoo)
	    argv[a++] = "+encrypttoself=on";
	if (usepgppass || !(opts & PGP_SIGNED_MESSAGE))
	    argv[a++] = "+batchmode";
	if (opts & PGP_SIGNED_MESSAGE)
	    argv[a++] = "+clearsig=on";
	argv[a++] = "+verbose=0";
	switch (opts & (PGP_SIGNED_MESSAGE|PGP_MESSAGE)) {
	case PGP_SIGNED_MESSAGE|PGP_MESSAGE:
	    argv[a++] = "-ats";
	    break;
	case PGP_SIGNED_MESSAGE:
	    argv[a++] = "-atws";
	    break;
	case PGP_MESSAGE:
	    argv[a++] = "-at";
	    break;
	}
	if (pgp_askpgpsig && (opts & PGP_SIGNED_MESSAGE)) {
	    argv[a++] = "-u";
	    argv[a++] = sig;
	}
	argv[a++] = "-o";
	argv[a++] = buf;

	for (i = 0; a < MAX_ARG -5 && id_array[i]; i++) {
	    argv[a++] = "-r";
	    argv[a++] = id_array[i];
	}
	argv[a++] = filename;
	argv[a] = NULL;
	
	ret = start_run(&RS,SY_RUN_STATE_ENV|SY_RUN_STATE_INIT,
			argv,-1,-1);

	break;
    case gpg:
	argv[a++] = gpg_path;
	if (usepgppass) {
	    static char buffer[10];
	    argv[a++] = "--passphrase-fd";
	    elm_sfprintf(buffer, sizeof buffer,FRM("%d"),
			 fd[0]);
	    argv[a++] = buffer;
	    close_fd = fd[1];
	}	
	if (usepgppass || !(opts & PGP_SIGNED_MESSAGE))
	    argv[a++] ="--batch";
	if (metoo) {
	    argv[a++] = "--encrypt-to";
	    if (pgp_askpgpsig && (opts & PGP_SIGNED_MESSAGE)) {
		static char buffer[STRING];
		elm_sfprintf(buffer, sizeof buffer,FRM("<%s>"),sig);
		argv[a++] = buffer;
	    }
	    else {
		static char buffer[STRING];
		elm_sfprintf(buffer, sizeof buffer,
			     FRM("<%s@%s>"),username,hostfullname);
		argv[a++] = buffer;
	    }
	}
	argv[a++] = "--no-verbose";
	if (pgp_askpgpsig && (opts & PGP_SIGNED_MESSAGE)) {
	    static char buffer[STRING];
	    argv[a++] = "--local-user";
	    elm_sfprintf(buffer, sizeof buffer,FRM("<%s>"),sig);
	    argv[a++] = buffer;
	}
	argv[a++] = "--output";
	argv[a++] = buf;
	for (i = 0; a < MAX_ARG -5 && id_array[i]; i++) {
	    argv[a++] = "--recipient";
	    /* Modify id_array so that there is space
	     * alloced also for <addr> form 
	     */
	    argv[a++] = kludge_addr(&(id_array[i]));
	}
	switch (opts & (PGP_SIGNED_MESSAGE|PGP_MESSAGE)) {
	case PGP_SIGNED_MESSAGE|PGP_MESSAGE:
	    argv[a++] = "--sign";
	    argv[a++] = "--armor";
	    argv[a++] = "--encrypt";
	    break;
	case PGP_MESSAGE:
	    argv[a++] = "--armor";
	    argv[a++] = "--encrypt";
	    break;
	case PGP_SIGNED_MESSAGE:
	    argv[a++] = "--clearsign";
	    break;
	}
	argv[a++] = filename;
	argv[a] = NULL;
	
	ret = start_run(&RS,SY_RUN_STATE_ENV|SY_RUN_STATE_INIT,
			argv,-1,-1);

	break;
    }


    if (ret) {
	if (usepgppass) {	
	    write(fd[1], pgp_passphrase[v], strlen(pgp_passphrase[v]));
	    write(fd[1], "\n", 1); /* pgp expects this as a line terminator! */
	    close(fd[1]);
	}
	ret = wait_end(&RS,&exit_code);
	Raw(ON);
    } else {
	Raw(ON);
	if (RS.save_errno)
	    lib_error(CATGETS(elm_msg_cat, ElmSet,ElmFailErrno,
			      "Failed: %.30s: %.40s"),
		      argv[0],error_description(RS.save_errno));
	else
	    lib_error(CATGETS(elm_msg_cat, ElmSet,ElmCantStart,
			      "Can't start %.30s"),
		      argv[0]);
	if (usepgppass) {	
	    close(fd[1]);
	}
	DestroyDynamicArray(id_array); /* don't need this any more... */
	if (joined)
	    free(joined);

	return FALSE;
    }
    
    DestroyDynamicArray(id_array); /* don't need this any more... */
    if (joined)
	free(joined);
    
    
    if (ret < 0) {
	lib_error(CATGETS(elm_msg_cat, ElmSet,ElmFailSignal,
			  "%.30s fail: Signal?"),
		  argv[0]);
	return FALSE;
    } else if (ret > 0) {
	if (RS.save_errno) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet,ElmFailErrno,
			      "Failed: %.30s: %.40s"),
		      argv[0],error_description(RS.save_errno));
	    return FALSE;
	} else if (exit_code) {	
	    lib_error(CATGETS(elm_msg_cat, ElmSet,ElmPgpErrorStatus,
			      "Pgp returned error status %d"),
		      exit_code);
	    if (pgp_keeppass)
		pgp_void_passphrase ();
	    return FALSE;
	} else {
#ifdef RENAME
	    if (rename(buf, filename) < 0) {
		lib_error(CATGETS(elm_msg_cat, ElmSet,ElmCantRenameTmpFile,
				  "Could not rename temporary file!"));
		return FALSE;
	    }
#else
	    if (link(buf, filename) < 0) {
		lib_error(CATGETS(elm_msg_cat, ElmSet,ElmCantLinkTmpFile,
				  "Could not create link to temporary file!"));
		return FALSE;
	    }
	    /* this is not fatal, but a warning should be given */
	    if (unlink(buf) < 0)
		lib_error(CATGETS(elm_msg_cat, ElmSet,ElmCantUnLinkTmpFile,
				  "Could not unlink temporary file!"));
#endif
	}
    } else {
	lib_error(CATGETS(elm_msg_cat, ElmSet,ElmLostErrno,
			  "%.30s lost: %.40s"),
		  argv[0],error_description(RS.save_errno));
	return TRUE;
    }
    return opts;
}

int
pgp_menu (filename, headers)
     char *filename;
     struct mailing_headers *headers;
{
    int update = TRUE;
    enum pgp_version v = send_pgp_version;
    enum pgp_version version;
    int x_coord = 0, y_coord = 0;
    int def_ans = 'q';

    if (!(version = have_pgp(v)))
	return FALSE;
    
    for (;;) {
	int ans;
	if (update) {
	    MoveCursor (elm_LINES-3, 0);
	    CleartoEOS ();
	    Centerline (elm_LINES-2, 
			catgets(elm_msg_cat, ElmSet, ElmPgpEncSign,
				"e)ncrypt, s)ign, b)oth encrypt and sign or q)uit"));
	    PutLineX (elm_LINES-3, 0, CATGETS(elm_msg_cat, ElmSet, ElmPgpP,
					      "pgp: "));
	    GetXYLocation(&x_coord, &y_coord);
	    
	    update = FALSE;
	}
	PutLineX (x_coord, y_coord,FRM("%c"),def_ans);
	MoveCursor(x_coord, y_coord);
	
	switch((ans = ReadCh(REDRAW_MARK))) {
	case '\n':
	case '\r':
	    ans = def_ans;
	}
	if (isascii(ans) && isupper(ans))
	    ans = tolower(ans);

	switch(ans) {
	case 'e':
	    Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmPgpEncrypt,
				    "Encrypt"));
	    return (pgp_call (filename, PGP_MESSAGE, headers, version));
	case 's':
	    Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmPgpSign,
				    "Sign"));
	    return (pgp_call (filename, PGP_SIGNED_MESSAGE, headers,
			      version));
	case 'b':
	    Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmPgpSignEncrypt,
				    "Sign and Encrypt"));
	    return (pgp_call (filename, PGP_MESSAGE | PGP_SIGNED_MESSAGE, 
			      headers, version));
	case 'q':
	    Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmPgpQuit,
				    "Quit"));
	    return FALSE;
	case REDRAW_MARK:
	case ctrl('L'):
	    update = 1;
	}
    }
    /* not reached */
}

int pgp_mail_public_key ()
{
    int ret;
    struct run_state RS;
    char * argv[20];
    int argc = 0;
    char userid[SLEN], pgpkey[SLEN], tmpfil[STRING], cmd[STRING], subj[STRING];
    int status;
    int need_redraw = FALSE;
    enum pgp_version v = send_pgp_version;
    enum pgp_version version;

    userid[0] = '\0';
    pgpkey[0] = '\0';

    if (!(version = have_pgp(v)))
	return FALSE;
    
    PutLineX(elm_LINES-2, 0, 
	     CATGETS(elm_msg_cat, ElmSet, ElmPgpEntUser,
		     "Enter userid of public key: "));
    CleartoEOS ();
    status = optionally_enter(userid, elm_LINES-2, 28, OE_REDRAW_MARK,
			      sizeof userid);
    while(REDRAW_MARK == status) {
	PutLineX(elm_LINES-2, 0,   CATGETS(elm_msg_cat, ElmSet, ElmPgpEntUser,
					   "Enter userid of public key: "));
	status = optionally_enter(userid, elm_LINES-2, 28, 
				  OE_REDRAW_MARK|OE_APPEND_CURRENT,
				  sizeof userid);
	need_redraw = TRUE;
    }
    if ( status != 0)
	return(need_redraw);
    
    if (GetPGPKey(userid, pgpkey, sizeof pgpkey, version) < 0) {
	Centerline(elm_LINES, catgets(elm_msg_cat, ElmSet, ElmPgpSorryUserId,
				      "Sorry, couldn't find that userid."));
	ClearLine(elm_LINES-2);
	return(TRUE);
    }
    elm_sfprintf(tmpfil, sizeof tmpfil,
		 FRM("%selm.%d.asc"), temp_dir, getpid());
    
    switch(version) {
	static char path[1000];
	static char buffer[200];
    case pgp2:	
	argv[argc++] = pgp2_path;
	argv[argc++] = "+verbose=0";
	argv[argc++] = "-kxa";
	argv[argc++] = pgpkey;
	argv[argc++] = tmpfil;

	break;
    case pgp5:	
	elm_sfprintf(path, sizeof path,FRM("%s/pgpk"),pgp5_dir);
	argv[argc++] = path;
	argv[argc++] = "+verbose=0";
	argv[argc++] = "-x";
	argv[argc++] = pgpkey;
	argv[argc++] = "-o";
	argv[argc++] = tmpfil;
	break;
    case gpg:	
	argv[argc++] = gpg_path;
	argv[argc++] = "--no-verbose";
	argv[argc++] = "--armor";
	argv[argc++] = "--output";
	argv[argc++] = tmpfil;
	argv[argc++] = "--export";
	elm_sfprintf(buffer, sizeof buffer,FRM("<%s>"),pgpkey);
	argv[argc++] = buffer;
	break;
    }
    argv[argc++] = NULL;
    
    ret = start_run(&RS,SY_NOTTY,argv,-1,-1);
    
    if (ret) {
	int exit_code;
	ret = run_already_done(&RS,&exit_code);
	if (0 == ret) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet,ElmRunningPgp,
			      "Running PGP..."));
	    fflush(stdout);
	    ret = wait_end(&RS,&exit_code);
	}
	if (ret < 0) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet,ElmFailSignal,
			      "%.30s fail: Signal?"),
		      argv[0]);
	    return TRUE;
	} else if (ret > 0) {
	    if (RS.save_errno) {
		lib_error(CATGETS(elm_msg_cat, ElmSet,ElmFailErrno,
				  "Failed: %.30s: %.40s"),
			  argv[0],error_description(RS.save_errno));
		return TRUE;
	    } else if (exit_code) {	
		lib_error(CATGETS(elm_msg_cat, ElmSet,ElmPgpErrorStatus,
				  "Pgp returned error status %d"),
			  exit_code);
		return TRUE;
	    } else {
		lib_error(CATGETS(elm_msg_cat, ElmSet,ElmPgpDone,
				  "Running PGP... Done."));
		strfcpy(included_file,tmpfil,sizeof included_file);
	    }
	} else {
	    lib_error(CATGETS(elm_msg_cat, ElmSet,ElmLostErrno,
			      "%.30s lost: %.40s"),
		      argv[0],error_description(RS.save_errno));
	    return TRUE;
	}	
    } else {
	if (RS.save_errno)
	    lib_error(CATGETS(elm_msg_cat, ElmSet,ElmFailErrno,
			      "Failed: %.30s: %.40s"),
		      argv[0],error_description(RS.save_errno));
      else
	  lib_error(CATGETS(elm_msg_cat, ElmSet,ElmCantStart,
			    "Can't start %.30s"),
		    argv[0]);
	return TRUE;
    }
    
    /* set the default subject for this message */
    elm_sfprintf(subj, sizeof subj,
		 CATGETS(elm_msg_cat, ElmSet, ElmPgpPublicKey,
		       "PGP public key for %s"), 
		 pgpkey);
    
    pgp_status = PGP_PUBLIC_KEY;
    
    /* Now send the message off! */
    send_msg_l(NULL,NULL, NULL, subj, 0, 0);
    
    unlink (included_file); /* make sure to clean up. */
    included_file[0] = '\0';
    pgp_status = 0; /* reset */
    return(TRUE);
}

int pgp_extract_public_key ()
{
    char tempfile[STRING], buf[STRING];
    struct run_state RS;
    char *argv[20];
    int argc = 0;
    FILE *fpout;
    int err,res;
    enum pgp_version v = send_pgp_version;
    enum pgp_version version;

    if (!current_folder)
	return FALSE;
    
    if (!(version = have_pgp(v)))
	return FALSE;
    
    elm_sfprintf(tempfile,sizeof tempfile,
		 FRM("%selm.%d"),temp_dir,getpid());
    fpout=safeopen_rdwr(tempfile);
    if (!fpout) {
	lib_error(CATGETS(elm_msg_cat, ElmSet,ElmOpenTmpWriting,
			  "Could not open temp file %.30s for writing!"), 
		  tempfile);
	return FALSE;
    }
    copy_message(MAILFILE(current_folder),headers[current-1],
		 "",fpout,0);
    fclose(fpout);
    
    switch(version) {
	static char path[1000];
    case pgp2:	
	argv[argc++] = pgp2_path;
	argv[argc++] = "+verbose=0";
	argv[argc++] = "-ka";
	argv[argc++] = tempfile;
	break;
    case pgp5:	
	elm_sfprintf(path, sizeof path,FRM("%s/pgpk"),pgp5_dir);
	argv[argc++] = path;
	argv[argc++] = "+verbose=0";
	argv[argc++] = "-a";
	argv[argc++] = tempfile;
	break;
    case gpg:
	argv[argc++] = gpg_path;
	argv[argc++] = "--no-verbose";
	argv[argc++] = "--import";
	argv[argc++] = tempfile;
	break;
    }
    argv[argc++] = NULL;
    
    res=start_run(&RS,SY_CLRWAIT,argv,-1,-1);
    if (res) {
	int exit_code;
	wait_end(&RS,&exit_code);
    }
    unlink(tempfile);
    return TRUE;
}

#endif /* USE_PGP */



/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
