
static char rcsid[] = "@(#)$Id: mailmsg1.c,v 1.9 1999/04/13 14:43:26 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.9 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** Interface to allow mail to be sent to users.  Part of ELM  **/

#include "headers.h"
#include "s_elm.h"
#include "me.h"



void zero_mailing_headers (hdrs)
     struct mailing_headers *hdrs;
{
    hdrs->subject     = NULL;
    hdrs->in_reply_to = NULL;
    hdrs->expires     = NULL;
    hdrs->action      = NULL;
    hdrs->priority    = NULL;
    zero_expanded_address(&(hdrs->reply_to));
    zero_expanded_address(&(hdrs->to));
    zero_expanded_address(&(hdrs->cc));
    hdrs->user_defined_header = NULL;
    zero_expanded_address(&(hdrs->bcc));
    hdrs->precedence   = NULL;
    hdrs->expires_days = NULL;
}

void free_mailing_headers (hdrs)
     struct mailing_headers *hdrs;
{
    if (hdrs->subject)
	hdrs->subject = NULL;
    hdrs->subject     = NULL;
    if (hdrs->in_reply_to)
	free(hdrs->in_reply_to);
    hdrs->in_reply_to = NULL;
    if (hdrs->expires)
	free(hdrs->expires);
    hdrs->expires     = NULL;
    if (hdrs->action)
	free(hdrs->action);
    hdrs->action      = NULL;
    if (hdrs->priority)
	free(hdrs->priority);
    hdrs->priority    = NULL;
    free_expanded_address(&(hdrs->reply_to));
    free_expanded_address(&(hdrs->to));
    free_expanded_address(&(hdrs->cc));
    if (hdrs->user_defined_header)
	free(hdrs->user_defined_header);
    hdrs->user_defined_header = NULL;
    free_expanded_address(&(hdrs->bcc));
    if (hdrs->precedence)
	free(hdrs->precedence);
    hdrs->precedence   = NULL;
    if (hdrs->expires_days)
	free(hdrs->expires_days);
    hdrs->expires_days = NULL;
}

char *format_long(), *strip_commas(), *tail_of_string();

static int to_line, to_col;

static int copy_the_msg P_((struct mailing_headers *headers,
			    int *is_a_response, int options));


static void output_abbreviated_to P_((struct addr_item *addrs));

static void output_abbreviated_to (addrs)
     struct addr_item *addrs;
{
    /** Output just the fields in parens, separated by commas if need
	be, and up to COLUMNS-50 characters...This is only used if the
	user is at level BEGINNER.
    **/

    char *newaddress = NULL;
    struct addr_item *p;

    for (p = addrs; p && p->fullname && p->addr; p++) {
	if (newaddress)
	    newaddress = strmcat(newaddress,", ");
	if (p->fullname[0])
	    newaddress = strmcat(newaddress,p->fullname);
	else
	    newaddress = strmcat(newaddress,p->addr);
    }
    
    if (!newaddress)
	return;
    
    if (mail_only)
	if (strlen(newaddress) > 80) 
	    PutLineX(to_line, to_col, 
		     CATGETS(elm_msg_cat, ElmSet, ElmToParen, "To: (%s)"), 
		     tail_of_string(newaddress, 60));
	else
	    PutLineX(to_line, to_col, 
		     CATGETS(elm_msg_cat, ElmSet, ElmToNoParen, "To: %s"), 
		     newaddress);
    else if (strlen(newaddress) > 50) 
	PutLineX(to_line, to_col, 
		 CATGETS(elm_msg_cat, ElmSet, ElmToParen, "To: (%s)"), 
		 tail_of_string(newaddress, 40));
    else {
	if (strlen(newaddress) > 30)
	    PutLineX(to_line, to_col, 
		     CATGETS(elm_msg_cat, ElmSet, ElmToNoParen, "To: %s"), 
		     newaddress);
	   else
	       PutLineX(to_line, to_col, 
			CATGETS(elm_msg_cat, ElmSet, ElmToNoParen2, 
				"          To: %s"), 
			newaddress);
	CleartoEOLN();
    }
    
    free(newaddress);
    return;    
}

void display_to(address)
     struct expanded_address address;
{
    /** Simple routine to display the "To:" line according to the
	current configuration (etc) 			      
    **/
    register int open_paren;
    char *addr_string;

    to_line = mail_only ? 3 : elm_LINES - 3;
    to_col = mail_only ? 0 : elm_COLUMNS - 50;

    if (names_only) {
	output_abbreviated_to(address.addrs);
	return;
    }

    addr_string = hdr_to_expval(address);
    if (!addr_string)
	return;

    if(mail_only)
	if(strlen(addr_string) > 80)
	    PutLineX(to_line, to_col, 
		     CATGETS(elm_msg_cat, ElmSet, ElmToParen, "To: (%s)"), 
		     tail_of_string(addr_string, 75));
	  else
	      PutLineX(to_line, to_col, 
		       CATGETS(elm_msg_cat, ElmSet, ElmToNoParen, "To: %s"), 
		       addr_string);
    else if (strlen(addr_string) > 45) 
	PutLineX(to_line, to_col, 
		 CATGETS(elm_msg_cat, ElmSet, ElmToParen, "To: (%s)"), 
		 tail_of_string(addr_string, 40));
    else {
	if (strlen(addr_string) > 30) 
	    PutLineX(to_line, to_col, 
		     CATGETS(elm_msg_cat, ElmSet, ElmToNoParen, "To: %s"), 
		     addr_string);
	else
	    PutLineX(to_line, to_col, 
		     CATGETS(elm_msg_cat, ElmSet, ElmToNoParen2, 
			     "          To: %s"), 
		     addr_string);
	CleartoEOLN();
    }
    free(addr_string);
}

int get_to(to)
     struct expanded_address *to;
{
    char buffer[LONG_STRING];

    /** prompt for the "To:" field, expanding into address if possible.
	This routine returns ZERO if errored, or non-zero if okay **/
    
    expanded_to_edit_buffer(buffer, sizeof buffer, *to);

    if (to->surface_len == 0) {
	
	if (user_level < 2) {
	    int code;

	    PutLine0(elm_LINES-2, 0, 
		     catgets(elm_msg_cat, ElmSet, ElmSendTheMessageTo,
			     "Send the message to: "));
	    code = optionally_enter(buffer, elm_LINES-2, 21, 
				    OE_REDRAW_MARK, sizeof buffer); 
	    while (REDRAW_MARK == code) {
		PutLine0(elm_LINES-2, 0, 
			 catgets(elm_msg_cat, ElmSet, ElmSendTheMessageTo,
				 "Send the message to: "));
		code = optionally_enter(buffer, elm_LINES-2, 21, 
					OE_REDRAW_MARK|OE_APPEND_CURRENT,
					sizeof buffer); 
	    }
	    if (0 != code)
		return 0;
	}
	else {
	    int code;
	    PutLine0(elm_LINES-2, 0, 
		     catgets(elm_msg_cat, ElmSet, ElmTo, "To: "));
	    code = optionally_enter(buffer, elm_LINES-2, 4, OE_REDRAW_MARK,
				    sizeof buffer); 
	    while (code == REDRAW_MARK) {
		PutLine0(elm_LINES-2, 0, 
			 catgets(elm_msg_cat, ElmSet, ElmTo, "To: "));
		code = optionally_enter(buffer, elm_LINES-2, 4, 
					OE_REDRAW_MARK|OE_APPEND_CURRENT,
					sizeof buffer); 
		if (0 != code)
		    return 0;
	    }
	}
	if (strlen(buffer) == 0) {
	    free_expanded_address(to);
	    ClearLine(elm_LINES-2);	
	    return(0);
	}
	update_expanded_from_edit_buffer(to,buffer);
    }
  
    build_address_l(to);
    
    if (to->addrs_len == 0) {	/* bad address!  Removed!! */
	ClearLine(elm_LINES-2);
	return(0);
    }
    
    return(1);		/* everything is okay... */
}

static int get_copies P_((struct expanded_address * cc,
			  int copy_message));
static int get_subject P_((char *, int));

static int send_msg_middle P_((
			       struct header_rec * current_header,
			       struct expanded_address *given_to, 
			       struct expanded_address *given_cc,
			       char *given_subject,
			       int   options, int form_letter));

static int send_msg_middle(current_header,
			   given_to, given_cc, given_subject, options, 
			   form_letter)
     struct header_rec * current_header;
     struct expanded_address *given_to, *given_cc;
     char *given_subject;
     int   options, form_letter;
{
    int res;
    int copy_msg = FALSE, is_a_response = FALSE;
    char *p;
    struct mailing_headers headers;

    zero_mailing_headers(&headers);
    if (given_subject)
	headers.subject = safe_strdup(given_subject);
    if (given_to)
	copy_expanded_address(&headers.to,*given_to);
    if (given_cc)
	copy_expanded_address(&headers.cc,*given_cc);

    if ((p = getenv("REPLYTO")) != NULL)
	update_expanded_from_edit_buffer(&headers.reply_to,p);

    /* auto bcc line */
    if ((p = getenv("BCC")) != NULL)
	update_expanded_from_edit_buffer(&headers.bcc,p);

    /* copy msg into edit buffer? */
    copy_msg = copy_the_msg(&headers,
			    &is_a_response, options);
    if (copy_msg) options |= MAIL_COPY_MSG;

    /* get the To: address and expand */
    if (! get_to(&headers.to))
	return(0);

    /* expand the Cc: address */
    if (&headers.cc.surface_len)
	build_address_l(&headers.cc);

    /* expand the Reply-To: address */
    if (&headers.reply_to.surface_len)
	build_address_l(&headers.reply_to);

    /* expand the bcc address */
    if (&headers.bcc.surface_len)
	build_address_l(&headers.bcc);

    /** if we're batchmailing, let's send it and GET OUTTA HERE! **/
    
    if (batch_only) {
	/** if we're batchmailing, let's send it and GET OUTTA HERE! **/
	res = mail(NULL, 0, form_letter,&headers);
    } else {
	int subject_size = LONG_STRING, l=0;
	
	display_to(headers.to);

	/* get the Subject: field */

	if (headers.subject)
	    l = strlen(headers.subject);
	if (subject_size < l)
	    subject_size = l + 1;
	headers.subject = safe_realloc(headers.subject,subject_size);
	if (0 == l)
	    headers.subject[0] = '\0';

	if (get_subject(headers.subject, subject_size) == 0) {
	    res = 0;
	    goto free_it;
	}

	if (prompt_for_cc) {
	    if (get_copies(&headers.cc, copy_msg) == 0) {
		res = 0;
		goto free_it;
	    }
	}

	MoveCursor(elm_LINES,0);	/* so you know you've hit <return> ! */

	/** generate the In-Reply-To: header... **/
	
	if (is_a_response && 0 != (options & MAIL_REPLYING))
	    generate_reply_to(current_header,&headers);

	/* and mail that puppy outta here! */
	
	dprint(3, (debugfile, "\nsend_msg() ready to mail...\n"));
	dump_expanded_address(3,"to",headers.to);
	if (headers.subject) {
	    dprint(4, (debugfile, "subject=\"%s\"\n",headers.subject));
	}
	dump_expanded_address(5,"cc",headers.cc);
	dump_expanded_address(5,"bcc",headers.bcc);

	res=mail(current_header,options, form_letter,&headers);
    }

 free_it:    
    free_mailing_headers(&headers);
    return res;
}

int send_msg_l(current_header,
	       given_to, given_cc, given_subject, options, form_letter)
     struct header_rec * current_header;
     struct addr_item *given_to, *given_cc;
     char *given_subject;
     int   options, form_letter;
{
    int ret;
    struct expanded_address A, B;

    zero_expanded_address(&A);
    zero_expanded_address(&B);

    addr_to_expanded(&A,given_to);
    addr_to_expanded(&B,given_cc);

    ret = send_msg_middle(current_header,&A,&B,
			  given_subject,options,form_letter);
    free_expanded_address(&A);
    free_expanded_address(&B);
    return ret;
}

int send_msg_argv(argv, given_subject, options, form)
     char *argv[];
     char *given_subject;
     int   options;
     int form;
{
    int ret;
    struct expanded_address A, B;

    zero_expanded_address(&A);
    zero_expanded_address(&B);

    argv_to_expanded(&A,argv);

    ret = send_msg_middle(NULL,&A,&B,
			  given_subject,options,form);

    free_expanded_address(&A);
    free_expanded_address(&B);
    return ret;
}

static int get_subject(subject_field, size)
     char *subject_field;
     int size;
{
	char	ch, msgbuf[SLEN];
	int code;

	/** get the subject and return non-zero if all okay... **/
	int len = 9, prompt_line;

	prompt_line = mail_only ? 4 : elm_LINES-2;

redraw:
	if (user_level == 0) {
	  PutLine0(prompt_line,0, catgets(elm_msg_cat, ElmSet, ElmSubjectOfMessage,
		"Subject of message: "));
	  len = 20;
	}
	else
	  PutLine0(prompt_line,0, catgets(elm_msg_cat, ElmSet, ElmSubject, "Subject: "));

	CleartoEOLN();

	code = optionally_enter(subject_field, prompt_line, len,
				OE_APPEND_CURRENT|OE_REDRAW_MARK,
				size);
	if (REDRAW_MARK == code)
	  goto redraw;

	if(code==-1){
	  /** User hit the BREAK key! **/
	  MoveCursor(prompt_line,0); 	
	  CleartoEOLN();
	  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmMailNotSent, 
			    "Mail not sent."));
	  return(0);
	}

	if (strlen(subject_field) == 0) {	/* zero length subject?? */
	  elm_sfprintf(msgbuf, sizeof msgbuf,
		       CATGETS(elm_msg_cat, ElmSet, ElmNoSubjectContinue,
			       "No subject - Continue with message? (%c/%c) "),
		       *def_ans_yes, *def_ans_no);

	  ch = want_to(msgbuf, *def_ans_no, prompt_line, 0);
	  if (ch != *def_ans_yes) {	/* user says no! */
	    if (sleepmsg > 0)
		sleep((sleepmsg + 1) / 2);
	    ClearLine(prompt_line);
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmMailNotSend, 
			      "Mail not sent."));
	    return(0);
	  }
	  else {
	    PutLine0(prompt_line,0,"Subject: <none>");
	    CleartoEOLN();
	  }
	}

	return(1);		/** everything is cruising along okay **/
}

static int get_copies(struct expanded_address *cc,
		      int copy_message);

static int get_copies(cc,copy_message)
     struct expanded_address * cc; 
     int copy_message;
{
    /* Get the list of people that should be cc'd, returning ZERO if
     * any problems arise.  
     *
     * If copy-message, that means that we're going to have to invoke
     * a screen editor, so we'll need to delay after displaying the
     * possibly rewritten Cc: line...
     */

    int prompt_line;
    int code;
    char *buffer = NULL;
    int size = 0;

    prompt_line = mail_only ? 5 : elm_LINES - 1;
    PutLine0(prompt_line,0, 
	     catgets(elm_msg_cat, ElmSet, ElmCopiesTo, "Copies to: "));

    fflush(stdout);

    hdr_to_buffer(*cc,&buffer,&size);
    
    code = optionally_enter(buffer, prompt_line, 11, OE_REDRAW_MARK, size);
    while (REDRAW_MARK == code) {
	PutLine0(prompt_line,0, 
		 catgets(elm_msg_cat, ElmSet, ElmCopiesTo, "Copies to: "));
	code = optionally_enter(buffer, prompt_line, 11, 
				OE_REDRAW_MARK|OE_APPEND_CURRENT,
				size);
    }
    if (code == -1) {
	ClearLine(prompt_line-1);
	ClearLine(prompt_line);
	  
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmMailNotSend, 
			  "Mail not sent."));
	
	buffer_to_header(cc,buffer,TRUE);
	return(0);
    }
	
    /** The following test is that if the build_address routine had
	reason to rewrite the entry given, then, if we're mailing only
	print the new Cc line below the old one.  If we're not, then
	assume we're in screen mode and replace the incorrect entry on
	the line above where we are (e.g. where we originally prompted
	for the Cc: field).
    **/

    buffer_to_header(cc,buffer,FALSE);

    if (build_address_l(cc)) {
	char * B = hdr_to_expval(*cc);
	if (B) {
	    PutLineX(prompt_line, 11, FRM("%s"), B);
	    if ((strcmp(editor, "builtin") != 0 && strcmp(editor, "none") != 0)
		|| copy_message)
		sleep_message();
	    free(B);
	}
    }
    
    return(1);		/* everything looks okay! */
}
	
static int copy_the_msg(headers,is_a_response, options)
     struct mailing_headers *headers;
     int *is_a_response;
     int options;
{
  int forwarding = 0 != (options & MAIL_FORWARDING);

  /** Returns True iff the user wants to copy the message being
    replied to into the edit buffer before invoking the editor! 
    Sets "is_a_response" to true if message is a response...
    **/

  char msg[SLEN];
  int answer = FALSE;
  
  if (forwarding)
    answer = TRUE;
  else if (headers->to.addrs_len > 0 && !mail_only) {  
    /* predefined 'to' line! */
    if (auto_copy) 
      answer = TRUE;
    else {
      elm_sfprintf(msg, sizeof msg,
		   CATGETS(elm_msg_cat, ElmSet, ElmCopyMessageYN,
			   "Copy message? (%c/%c) "), 
		   *def_ans_yes, *def_ans_no);
      answer = (want_to(msg, *def_ans_no, elm_LINES-3, 0) == *def_ans_yes);
    }
    *is_a_response = TRUE;
  }
  
  return(answer);
}

int a_sendmsg(edit_message, form_letter)
     int   edit_message, form_letter;
{
    /** Prompt for fields and then call mail() to send the specified
	message.  If 'edit_message' is true then by defualt go to
	editor. 'form_letter' can be "YES" "NO" or "MAYBE".
	if YES, then add the header.  If MAYBE, then add the M)ake form
	option to the last question (see mailsg2.c) etc. etc. 
	
	Return TRUE if the main part of the screen has been changed
	(useful for knowing whether a redraw is needed.
    **/

    register int tagged = 0, i;
    int ret;
    int subject_size = LONG_STRING, l=0;

    struct mailing_headers headers;
    
    zero_mailing_headers(&headers);

    tagged = aliases_to_expanded(&headers.to);
    
    dprint(4, (debugfile, "%d aliases tagged for mailing (a_sndmsg)\n",
	       tagged));

    /******* And now the real stuff! *******/
    
    /* build the To: address and expand */
    if (build_address_l(&headers.to) == 0)   
	return(0);

    display_to(headers.to);	/* display the To: field on screen... */

    /* get the Subject: field */
    headers.subject = safe_realloc(headers.subject,subject_size);
    headers.subject[0] = '\0';

    if (get_subject(headers.subject, subject_size) == 0) {
	ret = 0;
	goto free_it;
    }

    if (prompt_for_cc) {
	if (get_copies(&headers.cc, FALSE) == 0) {
	    ret = 0;
	    goto free_it;
	}
    }
	
    MoveCursor(elm_LINES,0);	/* so you know you've hit <return> ! */
    
    /* and mail that puppy outta here! */
    
    dprint(3, (debugfile, "\na_sendmsg() ready to mail...\n"));
    dump_expanded_address(3,"to",headers.to);
    if (headers.subject) {
	dprint(4, (debugfile, "subject=\"%s\"\n",headers.subject));
    }
    dump_expanded_address(5,"cc",headers.cc);
    dump_expanded_address(5,"bcc",headers.bcc);
	
    main_state();
    ret = mail(NULL, edit_message ? MAIL_EDIT_MSG : 0, form_letter,
	       &headers);
    main_state();
    
    /*
     *	Since we got this far, it must be okay to clear the tags.
     */
    i = 0;
    while (tagged) {
	if (ison(aliases[i]->status, TAGGED)) {
	    clearit(aliases[i]->status, TAGGED);
	    show_msg_tag(i);
	    tagged--;
	}
	i++;
    }
    
 free_it:    
    free_mailing_headers(&headers);
    return ret;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
