
static char rcsid[] = "@(#)$Id: delete.c,v 1.2.8.1 1999/08/27 04:06:11 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.2.8.1 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *
 *****************************************************************************/

/**  Delete or undelete files: just set flag in header record! 
     Also tags specified message(s)...

**/

#include "headers.h"
#include "me.h"
#include "s_elm.h"

char *show_status();

void delete_msg(real_del, update_screen)
     int real_del, update_screen;
{
	/** Delete current message.  If real-del is false, then we're
	    actually requested to toggle the state of the current
	    message... **/

	if (real_del) {
	  if (inalias) {
	    if (aliases[current-1]->type & SYSTEM)
	      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmNoDelSysAlias,
				"Can't delete a system alias!"));
	    else
	      setit(aliases[current-1]->status, DELETED);
	  }
	  else
	    setit(headers[current-1]->status, DELETED);
	}
	else {
	  if (inalias) {
	    if (aliases[current-1]->type & SYSTEM)
	      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmNoDelSysAlias,
				"Can't delete a system alias!"));
	    else if (ison(aliases[current-1]->status, DELETED))
	      clearit(aliases[current-1]->status, DELETED);
	    else
	      setit(aliases[current-1]->status, DELETED);
	  }
	  else if (ison(headers[current-1]->status, DELETED))
	    clearit(headers[current-1]->status, DELETED);
	  else
	    setit(headers[current-1]->status, DELETED);
	}

	if (update_screen)
	  show_msg_status(current-1);
}

void undelete_msg(update_screen)
     int update_screen;
{
	/** clear the deleted message flag **/

	if (inalias)
	  clearit(aliases[current-1]->status, DELETED);
	else
	  clearit(headers[current-1]->status, DELETED);

	if (update_screen)
	  show_msg_status(current-1);
}

void show_msg_status(msg)
     int msg;
{
	/** show the status of the current message only.  **/

	char tempbuf[3];

	strfcpy(tempbuf, show_status(ifmain(headers[msg]->status,
					    aliases[msg]->status),
				     ifmain(headers[msg], NULL)),
		sizeof tempbuf);

	if (on_page(msg)) {
	  MoveCursor(((compute_visible(msg+1)-1) % headers_per_page) + 4, 2);
	  if (msg+1 == current && !arrow_cursor) {
	    StartBold();
	    Writechar( tempbuf[0] );
	    EndBold();
	  }
	  else
	    Writechar( tempbuf[0] );
	}
}

int
tag_message(update_screen)
int update_screen;
{
	/** Tag current message and return TRUE.
	    If already tagged, untag it and return FALSE. **/

	int istagged;

	if (ison(ifmain(headers[current-1]->status,
	                aliases[current-1]->status), TAGGED)) {
	  if (inalias)
	    clearit(aliases[current-1]->status, TAGGED);
	  else
	    clearit(headers[current-1]->status, TAGGED);
	  istagged = FALSE;
	} else {
	  if (inalias)
	    setit(aliases[current-1]->status, TAGGED);
	  else
	    setit(headers[current-1]->status, TAGGED);
	  istagged = TRUE;
	}

	if(update_screen)
	    show_msg_tag(current-1);
	return(istagged);
}

void show_msg_tag(msg)
     int msg;
{
	/** show the tag status of the current message only.  **/

	if (on_page(msg)) {
	  MoveCursor(((compute_visible(msg+1)-1) % headers_per_page) + 4, 4);
	  if (msg+1 == current && !arrow_cursor) {
	    StartBold();
	    Writechar( ison(ifmain(headers[msg]->status,
	                           aliases[msg]->status), TAGGED)? '+' : ' ');
	    EndBold();
	  }
	  else
	    Writechar( ison(ifmain(headers[msg]->status,
	                           aliases[msg]->status), TAGGED)? '+' : ' ');
	}	
}

void show_new_status(msg)
     int msg;
{
	/** If the specified message is on this screen, show
	    the new status (could be marked for deletion now,
	    and could have tag removed...)
	**/

	if (on_page(msg)) 
	  if (msg+1 == current && !arrow_cursor) {
	    StartBold();
	    PutLineX(((compute_visible(msg+1)-1) % headers_per_page) + 4,
		   2, FRM("%s%c"), show_status(ifmain(headers[msg]->status,
						      aliases[msg]->status),
					       ifmain(headers[msg], NULL)),
		     ison(ifmain(headers[msg]->status,
				 aliases[msg]->status), TAGGED )? '+' : ' ');
	    EndBold();
	  }
	  else
	    PutLineX(((compute_visible(msg+1)-1) % headers_per_page) + 4,
		     2, FRM("%s%c"), show_status(ifmain(headers[msg]->status,
							aliases[msg]->status),
						 ifmain(headers[msg], NULL)),
		     ison(ifmain(headers[msg]->status,
				 aliases[msg]->status), TAGGED )? '+' : ' ');
}

int DeleteTagged()
{
/** delete all tagged messages.  return TRUE if the current message was
    deleted. **/
  int iindex, count = 0;
  char buf[STRING];

  if (!inalias) {
    for (iindex=0; iindex < message_count; iindex++)
      if (headers[iindex]->status & TAGGED) {
        headers[iindex]->status |= DELETED;
        count++;
        show_new_status(iindex);
      }
    if (count == 1)
      elm_sfprintf(buf, sizeof buf,
		   CATGETS(elm_msg_cat, ElmSet, ElmMsgDeleted,
			   "Message deleted."));
    else
      elm_sfprintf(buf, sizeof buf,
		   CATGETS(elm_msg_cat, ElmSet, ElmMsgsDeleted,
			   "%d messages deleted."), 
		   count);
    Centerline(elm_LINES, buf);
    return(headers[current-1]->status & DELETED ? 1 : 0);
  }
  return FALSE;
}
