
static char rcsid[] = "@(#)$Id: args.c,v 1.10.4.2 1999/11/08 15:42:58 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.10.4.2 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** starting argument parsing routines for ELM system...

**/

#include "headers.h"
#include "patchlevel.h"
#include "s_elm.h"
#include "me.h"

extern char *optarg;		/* optional argument as we go */
extern int   optind;			/* argnum + 1 when we leave   */


static void args_version P_((int i));
static void args_help P_((void));

char * parse_arguments(argc, argv, to_whom, size_r)
     int argc;
     char *argv[];
     char ***to_whom;
     int *size_r;
{
	/** Set flags according to what was given to program.  If we are 
	    fed a name or series of names, put them into the 'to_whom' buffer
	    and if the check_only flag wasn't presented, set mail_only to ON,
	    and if stdin is not a tty, set batch_only  to ON;
	    Return req_mfile, which points to a named mail file or is empty.
	    **/

	register int c = 0;
	int v = 0;
	static char req_mfile[SLEN];

	*size_r = sizeof req_mfile;

	*to_whom = NULL;
	batch_subject[0] = '\0';
	included_file[0] = '\0';

        while ((c = getopt(argc, argv, "?aA:cd:f:hi:kKms:tVvwz")) != EOF) {
	  switch (c) {
	  case 'a' : arrow_cursor++;		break;
	  case 'A' : 
	    if(!Attach_it(optarg)) exit(1);
	    break;
	  case 'c' : check_only++; use_tite = 0;	break;
	  case 'd' : debug = atoi(optarg);	break;
	  case 'f' : strfcpy(req_mfile, optarg,sizeof req_mfile);	
	    break;
	  case '?' :
	  case 'h' : args_help();
	  case 'i' : strfcpy(included_file, optarg, sizeof included_file);  
	    break;
	       /* case 'k' : hp_terminal++;	break;
		  case 'K' : hp_terminal++; hp_softkeys++;	break;
		  */
	  case 'm' : mini_menu = 0;	break;
	  case 's' : strfcpy(batch_subject, optarg, sizeof batch_subject);
	    break;
	  case 't' : use_tite = 0;	break;
	  case 'V' : sendmail_verbose++;     break;
	  case 'v' : v++; break;
	  case 'w' : write_elmrc++; break;
	  case 'z' : check_size++; use_tite = 0;   break;
	  }
	}

	if (v)
	  args_version(v);

#ifndef DEBUG
	if (debug)
	  printf(catgets(elm_msg_cat, ElmSet, ElmArgsIngoringDebug,
     "Warning: system created without debugging enabled - request ignored\n"));
	debug = 0;
#endif

	if (optind < argc) {
	  *to_whom = argv + optind;
	  if(!check_only)
	    mail_only++;
	  check_size = 0;	/* NEVER do this if we're mailing!! */
	}

	 if (strlen(batch_subject) > 0 && ! mail_only) 
	   exit(printf(catgets(elm_msg_cat, ElmSet, ElmArgsSubjectNotSend,
     "\n\rDon't understand specifying a subject and no-one to send to!\n\r")));

	if (!isatty(fileno(stdin)) && !check_only) {
	  batch_only = ON;
	  if(*batch_subject == '\0')
	    strfcpy(batch_subject, DEFAULT_BATCH_SUBJECT, 
		    sizeof batch_subject);
	}

	if (attach_files) {
	  if (! mail_only) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsAttachFileNotSend,
			      "Can't specify an attached files with no-one to send to!"));
	    exit(1);
	  }
	}

	if (strlen(included_file) > 0
	    ) {
	  if (! mail_only) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsInclFileNotSend,
			      "Can't specify an included file with no-one to send to!"));
	    exit(1);
	  }
	  if (batch_only) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsInclFileBatch,
			      "Can't specify an included file in batch mode!"));
	    exit(1);
	  }
        }

	return(req_mfile);
}

static void args_help()
{
	/**  print out possible starting arguments... **/

	printf(catgets(elm_msg_cat, ElmSet, ElmArgsHelp1,
	  "\nPossible Starting Arguments for ELM program:\n\n\r\
\targ\t\t\tMeaning\n\r\
\t -a \t\tArrow - use the arrow pointer regardless\n\r\
\t -A \t\tAttach file (requires .elm/mime.types)\n\r\
\t -c \t\tCheckalias - check the given aliases only\n\r\
\t -dn\t\tDebug - set debug level to 'n'\n\r\
\t -fx\t\tFolder - read folder 'x' rather than incoming mailbox\n\r\
\t -h \t\tHelp - give this list of options\n\r\
\t -ix\t\tInclude prepared file 'x' in edit buffer for send\n\r"));
	printf(catgets(elm_msg_cat, ElmSet, ElmArgsHelp2,
	  "\t -m \t\tMenu - Turn off menu, using more of the screen\n\r\
\t -sx\t\tSubject 'x' - for batch mailing\n\r\
\t -t \t\tTiTe - don't use termcap/terminfo ti/te entries.\n\r\
\t -V \t\tEnable sendmail voyeur mode.\n\r\
\t -v \t\tPrint out ELM version information.\n\r\
\t -w \t\tWrite .elm/elmrc\n\r\
\t -z \t\tZero - don't enter ELM if no mail is pending\n\r\
\n\n"));
	/*
	  \t -k \t\tKeypad - enable HP 2622 terminal keyboard\n\r
	  \t -K \t\tKeypad&softkeys - enable use of softkeys + \"-k\"\n\r\
	  */
	exit(1);
}

static void args_version(i)
     int i;
{
        time_t    curr_time = time(NULL);
 
	/** print out version information **/

	printf("\nElm Version and Identification Information:\n\n");
	printf("\tElm %s PL%s, of %s\n",VERSION,PATCHLEVEL,VERS_DATE);
	if (curr_time < LAST_REPORT_TIME && i != 2) {
	  printf("\tSend bug reports to %s\n",BUG_REPORT_ADDR);
	  printf("\n\tWARNING: Elm is not intended to be distributed in\n");
	  printf(  "\t         binary form. If that is done, then it is very\n");
	  printf(  "\t         likely that compile time configuration does not\n");
	  printf(  "\t         match to your system. This is NOT bug of ELM ME+\n");
	  printf(  "\t         and bug reports for that reason will be rejected.\n\n");
	}
	if (i == 1)
	  printf("\n\tBased on Elm 2.4 PL24 - PL25\n");

	if (i < 3) {
	  printf("\t(C) Copyright 1988-1992 USENET Community Trust\n");
	  printf("\tBased on Elm 2.0, (C) Copyright 1986,1987 Dave Taylor\n");
	}
	if ( i < 2 ) {
	  printf ("\n\tTo print configuration, use option: -vv\n");
	  exit(1);
	}
	if (i < 3) {
	  printf("\t----------------------------------\n");
	  printf("\tConfigured %s\n", CONFIGURE_DATE);
	  printf("\t----------------------------------\n");

#ifdef MMDF
	  printf("\tUse MMDF Mail Transport Agent/Mailbox Delimiters: MMDF\n");
#else /* MMDF */
	  printf("\tUse UNIX Mailbox Delimiters and %s Mail Transport Agent: not MMDF\n", mailer);
#endif /* MMDF */
	  
#ifdef DONT_ADD_FROM
	  printf("\tLet the MTA add the From: header: DONT_ADD_FROM\n");
#else /* DONT_ADD_FROM */
	  printf("\tElm will add the From: header: not DONT_ADD_FROM\n");
#endif /* DONT_ADD_FROM */
	  
	  printf("\tFollowing mail spool locking protocols will be used:");
#ifdef USE_DOTLOCK_LOCKING
	  printf(" USE_DOTLOCK_LOCKING (.lock)");
#endif
#ifdef USE_FLOCK_LOCKING
	  printf(" USE_FLOCK_LOCKING");
#endif
#ifdef USE_FCNTL_LOCKING
	  printf(" USE_FCNTL_LOCKING");
#endif
	  printf("\n");
#ifdef SYSCALL_LOCKING
	  printf("\tFolder locking is available: SYSCALL_LOCKING\n");
#else
	  printf("\tFolder locking in not possible: not SYSCALL_LOCKING\n");
#endif

#ifdef USE_8BITMIME
	  printf("\tUse 8BIT content_transfer_encoding and -B8BITMIME -option: USE_8BITMIME\n");
#else /* USE_8BITMIME */
	  printf("\tDon't use 8BIT content_transfer_encoding with -B8BITMIME -option: not USE_8BITMIME\n");
#endif /* USE_8BITMIME */
	  
#ifdef USE_BINARYMIME
	  printf("\tUse BINARY content_transfer_encoding and -BBINARYMIME -option: USE_BINARYMIME");
#else /* USE_BINARYMIME */
	  printf("\tDon't use BINARY content_transfer_encoding with -BBINARYMIME -option: not USE_BINARYMIME");
#endif /* USE_BINARYMIME */
	  printf(" (This option isn't fully implemented yet.)\n");

#ifdef USE_DSN
	  printf("\tUse DSN and options -N -R -V: USE_DSN\n");
#else /* USE_DSN */
	  printf("\tDon't use DSN with -N -R -V -options: not USE_DSN\n");
#endif /* USE_DSN */

#ifdef DEBUG
	  printf("\tDebug options are available: DEBUG\n");
#else /* DEBUG */
	  printf("\tNo debug options are available: not DEBUG\n");
#endif /* DEBUG */
		
#ifdef CRYPT
	  printf("\tCrypt function enabled: CRYPT\n");
#else /* CRYPT */
	  printf("\tCrypt function disabled: not CRYPT\n");
#endif /* CRYPT */

#ifdef ALLOW_MAILBOX_EDITING
	  printf("\tMailbox editing included: ALLOW_MAILBOX_EDITING\n");
#else /* ALLOW_MAILBOX_EDITING */
	  printf("\tMailbox editing not included: not ALLOW_MAILBOX_EDITING\n");
#endif /* ALLOW_MAILBOX_EDITING */

#ifdef ALLOW_SUBSHELL
	  printf("\tSubshell menu items included: ALLOW_SUBSHELL\n");
#else /* ALLOW_SUBSHELL */
	  printf("\tSubshell menu items not included: not ALLOW_SUBSHELL\n");
#endif /* ALLOW_SUBSHELL */

#ifdef ISPELL
	  printf("\tSpell checking feature enabled: ISPELL\n");
	  printf("\t\t(Default spelling checker is %s options '%s')\n", ISPELL_PATH, ISPELL_OPTIONS);
#else /* ISPELL */
	  printf("\tSpell checking feature disabled: not ISPELL\n");
#endif /* ISPELL */

#ifdef ENABLE_CALENDAR
	  printf("\tCalendar file feature enabled: ENABLE_CALENDAR\n");
	  printf("\t\t(Default calendar file is %s)\n",dflt_calendar_file);
#else /* ENABLE_CALENDAR */
	  printf("\tCalendar file feature disabled: not ENABLE_CALENDAR\n");
#endif /* ENABLE_CALENDAR */

#ifdef USE_PGP
	  printf("\tPGP support enabled: USE_PGP\n");
#else
	  printf("\tPGP support disabled: not USE_PGP\n");
#endif
#ifdef ASCII_CTYPE
	  printf("\t\"ctype\" functions are ASCII -only: ASCII_CTYPE\n");
#else
	  printf("\t\"ctype\" functions are 8-bit clean: not ASCII_CTYPE\n");
#endif
#ifdef BROKE_CTYPE
          printf("\tUsing replacement toupper() and tolower() routines: BROKE_CTYPE\n");
#else
          printf("\tUsing standard \"ctype\" toupper() and tolower() routines: not BROKE_CTYPE\n");
#endif
#ifdef I_LOCALE
          printf("\tSystem support multiple character sets or languages: I_LOCALE\n");
#else
          printf("\tMultiple display character sets are not supported: not I_LOCALE\n");
#endif
	  printf("\n\n");

	  printf("\tTo read global initialization file %s, use Elm -vvv\n",
		 system_rc_file);
	  exit(1);
	}

	switch (i) {
	case 3:
	printf("\t------------------------------------------\n");
	printf("\tSystem RC file: %s\n",system_rc_file);
	printf("\t------------------------------------------\n\n");
	
	user_init();
	init_defaults();
	post_init_check();

	printf("\tShort host name:           %s\n",hostname);
	printf("\tHost's domain:             %s\n",hostdomain);
	printf("\tQualified host name:       %s\n",hostfullname);
	printf("\tMailbox:                   %s\n",defaultfile);

	printf("\tDisplay character-set:     %s\n",
	       display_charset->MIME_name ? 
	       display_charset->MIME_name :
	       "<no MIME name>");
	printf("\tSending character-set:     %s\n",
	       charset->MIME_name ? charset->MIME_name : "<no MIME name>");
	printf("\n\tTo list configuration files, use Elm -vvvv\n");
	break;

	case 4:
	printf("\t------------------------------------------\n");
	printf("\tElm ME+ configuration files: \n");
	printf("\t------------------------------------------\n\n");
	user_init();

	printf("System configuration files:\n");
	printf("\tRC file:                  %s\n",system_rc_file);
	printf("\tAliases database:         %s\n",system_data_file);
	printf("\tAliases file:             %s\n",system_text_file);
	printf("\tMapping to content-type:  %s\n",system_mime_types);
	printf("\tMapping to charset:       %s\n",system_mime_charsets);
	printf("\tDomain-name file:         %s\n",hostdomfile);
	printf("User configuration files:\n");
	printf("\tRC file:                  %s\n",user_rc_file);
	printf("\tAliases database:         %s\n",user_data_file);
	printf("\tAliases file:             %s\n",user_text_file);
	printf("\tMapping to content-type:  %s\n",user_mime_types);
	printf("\tMapping to charset:       %s\n",user_mime_charsets);
	printf("\tAdditional mail-headers:  %s\n",user_mailheaders);
	printf("\n\tTo read user configuration, use Elm -vvvvv\n");
	break;

	case 5:
	user_init();
	init_defaults();
	printf("\t------------------------------------------\n");
	printf("\tUser RC file: %s\n",user_rc_file);
	printf("\t------------------------------------------\n\n");

	read_rc_file();
	post_init_check();

	printf("\tLocale (LC_CTYPE):         %s\n",display_locale);
	printf("\tDisplay character-set:     %s\n",
	       display_charset->MIME_name ?
	       display_charset->MIME_name :
	       "<no MIME name>");
	printf("\tSending character-set:     %s\n",
	       charset->MIME_name ? charset->MIME_name : "<no MIME name>");

	}
	exit(1);
}

