
static char rcsid[] = "@(#)$Id: mail_gets.c,v 1.3 1999/05/22 13:49:47 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.3 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1992 USENET Community Trust
 *****************************************************************************/

/** get a line from the mail file, but be tolerant of nulls

  The length of the line is returned

**/

#include "headers.h"

int mail_gets(buffer, size, mailfile)
     char *buffer;
     int size;
     FILE *mailfile;
{
	register int line_bytes = 0, ch;
	register char *c = buffer;

	size--; /* allow room for zero terminator on end, just in case */

	while (!feof(mailfile) && !ferror(mailfile) && line_bytes < size) {
	  ch = getc(mailfile); /* Macro, faster than  fgetc() ! */

	  if (ch == EOF)
	  {
	    if (line_bytes > 0 && *c != '\n')
	    {
	        ++line_bytes;
	    	*c++ = '\n';
	    }
	    break;
	  }

	  *c++ = ch;
	  ++line_bytes;

	  if (ch == '\n')
	    break;
	}
	*c = 0;	/* Actually this should NOT be needed.. */
	return line_bytes;
}
