/*
** Copyright 1998 - 1999 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"config.h"
#include	<sys/types.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<netinet/in.h>
#include	<arpa/inet.h>

#include	"soxwrap/soxwrap.h"
#include	"rfc1035.h"
#include	"rfc1035_res.h"

static const char rcsid[]="$Id: testlookup.c,v 1.5 2000/02/28 05:03:23 mrsam Exp $";

static void setns(const char *p)
{
struct in_addr ia[4];
int	i=0;
char	*q=malloc(strlen(p)+1), *r;

	strcpy(q, p);
	for (r=q; (r=strtok(r, ", ")) != 0; r=0)
		if (i < 4)	ia[i++].s_addr=rfc1035_aton(r);

	rfc1035_init_ns(&rfc1035_default_resolver, ia, i);
}

int main(int argc, char **argv)
{
struct	rfc1035_reply *replyp;
int	argn;
const char *q_name;
int	q_type;
int	q_class;
int	q_xflag=0;

	argn=1;
	while (argn < argc)
	{
		if (argv[argn][0] == '@')
		{
			setns(argv[argn]+1);
			++argn;
			continue;
		}

		if (strcmp(argv[argn], "-x") == 0)
		{
			q_xflag=1;
			++argn;
			continue;
		}
		break;
	}

	if (argn >= argc)	exit(0);

	q_name=argv[argn++];

	if (q_xflag)
	{
	struct in_addr ia;

		ia.s_addr=rfc1035_aton(q_name);
		if (ia.s_addr)
		{
		const char *p=inet_ntoa(ia);
		unsigned char a=0,b=0,c=0,d=0;
		static char buf[30];

			while (*p >= '0' && *p <= '9')
				a= (int)a * 10 + (*p++ - '0');
			if (*p)	p++;
			while (*p >= '0' && *p <= '9')
				b= (int)b * 10 + (*p++ - '0');
			if (*p)	p++;
			while (*p >= '0' && *p <= '9')
				c= (int)c * 10 + (*p++ - '0');
			if (*p)	p++;
			while (*p >= '0' && *p <= '9')
				d= (int)d * 10 + (*p++ - '0');

			sprintf(buf, "%d.%d.%d.%d.in-addr.arpa",
				(int)d, (int)c, (int)b, (int)a);
			q_name=buf;
		}
	}

	q_type= -1;

	if (argn < argc)
		q_type=rfc1035_type_strtoi(argv[argn++]);

	if (q_type < 0)
		q_type=q_xflag ? RFC1035_TYPE_PTR:RFC1035_TYPE_ANY;

	q_class= -1;
	if (argn < argc)
		q_class=rfc1035_class_strtoi(argv[argn]);
	if (q_class < 0)
		q_class=RFC1035_CLASS_IN;

	replyp=rfc1035_resolve(&rfc1035_default_resolver,
		RFC1035_OPCODE_QUERY, 1, q_name, q_type, q_class);

	if (!replyp)
	{
		perror(argv[0]);
		exit(1);
	}

	rfc1035_dump(replyp, stdout);
	rfc1035_replyfree(replyp);
	return (0);
}
