/* $Id: liblock.h,v 1.3 1999/12/06 13:18:55 mrsam Exp $ */

#ifndef liblock_h
#define liblock_h

/*
** Copyright 1998 - 1999 Double Precision, Inc.  See COPYING for
** distribution information.
*/

#ifdef	__cplusplus
extern "C" {
#endif

#include	<sys/types.h>

#define	ll_whence_start	0
#define	ll_whence_curpos 1
#define	ll_whence_end 2

#ifndef	LL_OFFSET_TYPE
#include	"liblock_offsettype.h"
#endif

#define	ll_readlock	0
#define	ll_writelock	4
#define	ll_unlock	8
#define	ll_wait		16

int	ll_lockfd(int,	/* File descriptor */
		int,	/* ll_ bitmask */
		LL_OFFSET_TYPE,	/* Start */
		LL_OFFSET_TYPE);	/* Length */


/* Some useful macros: ll_lock_ex - exclusive lock on a file,
		ll_lock_ex_test - attempt an exclusive lock on a file
		ll_unlock_ex - unlock a file
*/

#define	ll_lock_ex(f)	\
	ll_lockfd( (f), ll_writelock|ll_whence_start|ll_wait, 0, 0)

#define	ll_lock_ex_test(f)	\
	ll_lockfd( (f), ll_writelock|ll_whence_start, 0, 0)

#define	ll_unlock_ex(f)	\
	ll_lockfd( (f), ll_unlock|ll_whence_start, 0, 0)

#ifdef	__cplusplus
} ;
#endif

#endif
