/*
** Copyright 1998 - 1999 Double Precision, Inc.  See COPYING for
** distribution information.
*/

#ifndef	authstaticlist_h
#define	authstaticlist_h

#if	HAVE_CONFIG_H
#include	"config.h"
#endif
#include	<sys/types.h>

#ifdef	__cplusplus
extern "C" {
#endif

static const char authstaticlist_h_rcsid[]="$Id: authstaticlist.h,v 1.4 2000/02/28 05:02:27 mrsam Exp $";

struct authinfo;

struct authstaticinfo {
	const char *auth_name;
	char * (*auth_func)(const char *, const char *, char *, int);
	int (*auth_prefunc)(const char *, const char *,
			int (*)(struct authinfo *, void *),
                        void *);
	void (*auth_cleanupfunc)();
	int (*auth_changepwd)(const char *, const char *, const char *,
			const char *);	/* NOT IMPLEMENTED YET */
	} ;

extern struct authstaticinfo authstaticlist[];

/*
** Call statically-linked authentication modules, according to the order
** specified in configuration file 'configfile'.  If configfile does not
** exist, the installed order is used.
**
** The first time this function is called, the contents of configfile
** are read and saved in a memory buffer, and subsequent invocations will
** use the saved copy of the module list.
*/

int authstaticlist_search(
	const char *userid,		/* userid to authenticate */
	const char *service,		/* service to authenticate */
	const char *configfile,		/* configuration file */
	int (*callback)(struct authinfo *, void *),	/* callback function */
	void *callback_arg);		/* argument to the callback function */

/*
**	If an authentication module is not found for this userid, a negative
**	value is returned.  If there was a temporary error (database offline,
**	etc) a positive value is returned.  Otherwise, the callback function
**	is invoked, and the exit code from the callback function is returned
**	(which should be zero).
*/

#ifdef	__cplusplus
}
#endif

#endif
