
/* Test program to check the resolution of the SDL timer on the current
   platform
*/

#include <stdio.h>

#include "SDL.h"

#define DEFAULT_RESOLUTION	1

static int ticks = 0;

static Uint32 ticktock(Uint32 interval)
{
	++ticks;
	return(interval);
}

main(int argc, char *argv[])
{
	int desired;

	if ( SDL_Init(SDL_INIT_TIMER) < 0 ) {
		fprintf(stderr, "Couldn't load SDL: %s\n", SDL_GetError());
		exit(1);
	}
	atexit(SDL_Quit);

	/* Start the timer */
	desired = 0;
	if ( argv[1] ) {
		desired = atoi(argv[1]);
	}
	if ( desired == 0 ) {
		desired = DEFAULT_RESOLUTION;
	}
	SDL_SetTimer(desired, ticktock);

	/* Wait 10 seconds */
	printf("Waiting 10 seconds\n");
	SDL_Delay(10*1000);

	/* Stop the timer */
	SDL_SetTimer(0, NULL);

	/* Print the results */
	if ( ticks ) {
		fprintf(stderr,
		"Timer resolution: desired = %d ms, actual = %f ms\n",
					desired, (double)(10*1000)/ticks);
	}
	exit(0);
}
