/* $Id: visual.c,v 1.21 1999/01/29 22:29:25 marcus Exp $
******************************************************************************

   Terminfo target

   Copyright (C) 1998 MenTaLguY         [mentalg@geocities.com]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "TIvisual.h"

void _GGI_terminfo_freedbs(ggi_visual *vis) {
	int i;

	for (i=LIBGGI_APPLIST(vis)->num-1; i >= 0; i--) {
		free(LIBGGI_APPBUFS(vis)[i]->write);
		_ggi_db_free(LIBGGI_APPBUFS(vis)[i]);
		_ggi_db_del_buffer(LIBGGI_APPLIST(vis), i);
	}
}

/* Constructs an approximate mapping from IBM-ASCII to the charset of the
   current display */
static void construct_charmap(chtype charmap[256])
{
	int i;

	/* low ascii ( control characters ) */
	for ( i = 0 ; i < 32 ; i++ ) charmap[i] = '*';
	charmap[4] = ACS_DIAMOND;
	charmap[7] = ACS_BULLET;
	charmap[8] = ACS_BULLET | A_REVERSE;
	charmap[9] = 'o';
	charmap[10] = 'o' | A_REVERSE;
	charmap[16] = '>';
	charmap[17] = '<';
	charmap[24] = ACS_UARROW;
	charmap[25] = ACS_DARROW;
	charmap[26] = ACS_RARROW;
	charmap[27] = ACS_DARROW;
	charmap[30] = '^';
	charmap[31] = 'v';

	for ( ; i < 127 ; i++ ) charmap[i] = i;
	charmap[127] = '^';
	for ( ; i < 256 ; i++ ) charmap[i] = '*';

	/* "international" characters */
	charmap[128] = 'C'; /* capital cedila */
	charmap[129] = 'u'; /* u + umlaut */
	charmap[130] = 'e';
	charmap[131] = charmap[132] = charmap[133] = charmap[134] = 'a';
	charmap[135] = 'c'; /* lower-case cedila */
	charmap[136] = charmap[137] = charmap[138] = 'e';
	charmap[139] = charmap[140] = charmap[141] = 'i';
	charmap[142] = charmap[143] = 'A';
	charmap[144] = 'E';
	charmap[145] = 'e'; /* ae digraph */
	charmap[146] = 'E'; /* AE digraph */
	charmap[147] = charmap[148] = charmap[149] = 'o';
	charmap[150] = charmap[151] = 'u';
	charmap[152] = 'y';
	charmap[153] = 'O';
	charmap[154] = 'U'; /* U + umlaut */
	charmap[160] = 'a';
	charmap[161] = 'i';
	charmap[162] = 'o';
	charmap[163] = 'u';
	charmap[164] = 'n'; /* n + ~ */
	charmap[165] = 'N'; /* N + ~ */
	charmap[168] = '?'; /* spanish inverted question mark */
	charmap[169] = '!'; /* spanish inverted exclamation mark */

	/* line drawing characters */
	charmap[179] = ACS_VLINE;
	charmap[180] = charmap[181] = charmap[182] = ACS_RTEE;
	charmap[183] = charmap[184] = ACS_LLCORNER;
	charmap[185] = ACS_RTEE;
	charmap[186] = ACS_VLINE;
	charmap[187] = ACS_LLCORNER;
	charmap[188] = charmap[189] = charmap[190] = ACS_ULCORNER;
	charmap[191] = ACS_LLCORNER;
	charmap[192] = ACS_URCORNER;
	charmap[193] = ACS_BTEE;
	charmap[194] = ACS_TTEE;
	charmap[195] = ACS_LTEE;
	charmap[196] = ACS_HLINE;
	charmap[197] = ACS_PLUS;
	charmap[198] = charmap[199] = ACS_LTEE;
	charmap[200] = ACS_URCORNER;
	charmap[201] = ACS_LRCORNER;
	charmap[202] = ACS_BTEE;
	charmap[203] = ACS_TTEE;
	charmap[204] = ACS_LTEE;
	charmap[205] = ACS_HLINE;
	charmap[206] = ACS_PLUS;
	charmap[207] = charmap[208] = ACS_BTEE;
	charmap[209] = charmap[210] = ACS_TTEE;
	charmap[211] = charmap[212] = ACS_URCORNER;
	charmap[213] = charmap[214] = ACS_LRCORNER;
	charmap[215] = charmap[216] = ACS_PLUS;
	charmap[217] = ACS_ULCORNER;
	charmap[218] = ACS_LRCORNER;

	charmap[218] = ACS_ULCORNER;
	charmap[192] = ACS_LLCORNER;
	charmap[191] = ACS_URCORNER;
	charmap[217] = ACS_LRCORNER;
	charmap[180] = ACS_RTEE;
	charmap[195] = ACS_LTEE;
	charmap[193] = ACS_BTEE;
	charmap[194] = ACS_TTEE;
	charmap[196] = ACS_HLINE;
	charmap[179] = ACS_VLINE;
	charmap[197] = ACS_PLUS;

	/* block drawing characters */
	charmap[176] = ACS_CKBOARD;
	charmap[177] = ACS_CKBOARD;
	charmap[178] = ACS_CKBOARD;
	charmap[219] = ACS_BLOCK;

	/* miscellaneous characters */
	charmap[155] = 'c'; /* cents */
#ifdef ACS_STERLING
	charmap[156] = ACS_STERLING; /* pounds sterling symbol */
#endif
	charmap[157] = 'Y'; /* yen symbol */
	charmap[158] = 'P'; /* Pt symbol */
	charmap[159] = 'f'; /* cursive 'f' */
	charmap[174] = '<'; /* << */
	charmap[175] = '>'; /* >> */
#ifdef ACS_PI
	charmap[227] = ACS_PI;
#endif ACS_PI
	charmap[232] = ACS_LANTERN; /* iota */
#ifdef ACS_LEQUAL
	charmap[243] = ACS_LEQUAL;
#endif
#ifdef ACS_GEQUAL
	charmap[242] = ACS_GEQUAL;
#endif
	charmap[248] = ACS_DEGREE;
	charmap[241] = ACS_PLMINUS;
	charmap[249] = charmap[250] = ACS_BULLET;
	charmap[251] = 'J'; /* radical sign */
	charmap[253] = '2'; /* superscript 2 */
	/* what, no euro symbol? :) */
}

int GGIdlinit(ggi_visual *vis, const char *args, void *argptr)
{
	struct TIhooks *tiinfo;
	int i;

	char *term_type;
	char *term_path;
	char *finger;

	term_type = NULL;
	if ( args == NULL ) {
		term_path = alloca(1);
		*term_path = '\000';
	} else {
		term_path = alloca(strlen(args) + 1);
	}

	for ( finger = term_path ; *finger != '\000' ; finger++ ) {
		if ( *finger == ':' ) {
			*finger = '\000';
			term_type = finger + 1;
			break;
		}
	}

	GGIDPRINT("display-terminfo: initializing %s on %s.\n", term_type, ( ( *term_path == '\000' ) ? "stdin/stdout" : term_path ));

	tiinfo = (struct TIhooks *)_ggi_malloc(sizeof(struct TIhooks));

	tiinfo->splitline = 0;

	tiinfo->virgin = 1;

	if ( *term_path == '\000' ) {
		tiinfo->f_in = fdopen(fileno(stdin), "r");
		tiinfo->f_out = fdopen(fileno(stdout), "w");
	} else {
		tiinfo->f_in = tiinfo->f_out = fopen(term_path, "rw");
	}

	_terminfo_init_ncurses();

	tiinfo->scr = _terminfo_new_screen(term_type, tiinfo->f_out, tiinfo->f_in);
	if ( tiinfo->scr == NULL ) {
		fprintf(stderr, "display-terminfo: error creating ncurses"
				" SCREEN\n");
		fclose(tiinfo->f_in);
		fclose(tiinfo->f_out);
		free(tiinfo);
		return GGI_DL_ERROR;
	}

	LIBGGI_FD(vis) = fileno(tiinfo->f_out);

	if ( has_colors() ) {
		static const int vga_color[8] = {
			COLOR_BLACK,
			COLOR_BLUE,
			COLOR_GREEN,
			COLOR_CYAN,
			COLOR_RED,
			COLOR_MAGENTA,
			COLOR_YELLOW,
			COLOR_WHITE
		};
		int j;
		GGIDPRINT("display-terminfo: terminal supports %d colors\n", COLORS);
		GGIDPRINT("display-terminfo: initializing %d - 1 color pairs\n", COLOR_PAIRS);
		for ( i = 1 ; i < COLOR_PAIRS ; i++ ) {
			if ( init_pair(i, COLORS - ( i % COLORS ) - 1, i / COLORS) == ERR ) {
				GGIDPRINT("display-terminfo: error initializing color pair %d to %d,%d\n", i, COLORS - ( i % COLORS ) - 1, i / COLORS);
				fprintf(stderr, "display-terminfo: error initializing colors\n");
				break;
			}
		}
		for ( i = 0 ; i < 16 ; i++ ) {
			for ( j = 0 ; j < 16 ; j++ ) {
				tiinfo->color16_table[i+(j<<4)] =
					COLOR_PAIR(((COLORS-vga_color[i&0x07]%COLORS-1)
					 +(vga_color[j&0x07]%COLORS*COLORS))%COLOR_PAIRS)
					| ( ( i > 7 ) ? A_BOLD : A_NORMAL )
					| ( ( j > 7 ) ? A_BLINK : A_NORMAL );
			}
		}

	} else {
		GGIDPRINT("display-terminfo: terminal lacks color support\n");
	}
	construct_charmap(tiinfo->charmap);
#if ( NCURSES_MOUSE_VERSION == 1 ) 
	GGIDPRINT("display-terminfo: mouse support is enabled\n");
	mousemask(REPORT_MOUSE_POSITION | BUTTON1_PRESSED | BUTTON1_RELEASED |
			BUTTON2_PRESSED | BUTTON2_RELEASED | BUTTON3_PRESSED |
			BUTTON3_RELEASED | BUTTON4_PRESSED | BUTTON4_RELEASED,
			NULL);
#else
	GGIDPRINT("display-terminfo: mouse support is disabled\n");
#endif
	LIBGGI_PRIVATE(vis) = tiinfo;
	LIBGGI_GC(vis) = _ggi_malloc(sizeof(ggi_gc));

	/* mode management */
	vis->opdisplay->flush     = GGI_terminfo_flush;
	vis->opdisplay->getmode   = GGI_terminfo_getmode;
	vis->opdisplay->setmode   = GGI_terminfo_setmode;
	vis->opdisplay->checkmode = GGI_terminfo_checkmode;
	vis->opdisplay->getapi    = GGI_terminfo_getapi;
	vis->opdisplay->setflags  = GGI_terminfo_setflags;

	/* event management */
	{
		gii_input *inp;
		inp = _giiInputAlloc();

		if ( inp == NULL ) {
			fprintf(stderr, "display-terminfo: error allocating gii_input\n");
			_terminfo_destroy_screen();
			return GGI_DL_ERROR;
		}

#if ( NCURSES_MOUSE_VERSION == 1 )
		inp->targetcan =emKey | emPtrButton | emPtrAbsolute,
#else
		inp->targetcan =emKey, /* without mouse support */
#endif
		inp->GIIseteventmask(inp,inp->targetcan);

		inp->GIIeventpoll = GII_terminfo_eventpoll;
		inp->GIIsendevent = GII_terminfo_sendevent;

		tiinfo->vis = vis;
		inp->priv = (void *)tiinfo;

		inp->maxfd=0;   /* This is polled. */
		inp->flags|=GII_FLAGS_HASPOLLED;

		vis->input = giiJoinInputs(vis->input, inp);
	}

	_terminfo_release_screen();
 
	return GGI_DL_OPDISPLAY;
}

int GGIdlcleanup(ggi_visual *vis) {
	struct TIhooks *tiinfo;

	tiinfo = LIBGGI_PRIVATE(vis);
	if ( tiinfo != NULL ) {
		if ( tiinfo->scr != NULL ) {
			_terminfo_select_screen(tiinfo->scr);
			if ( !tiinfo->virgin ) {
				wclear(stdscr);
				refresh();
			}
			_terminfo_destroy_screen();
		}
		if ( tiinfo->f_in != NULL ) {
			fclose(tiinfo->f_in);
		}
		if ( ( tiinfo->f_out != NULL ) && ( tiinfo->f_out != tiinfo->f_in ) ) {
			fclose(tiinfo->f_out);
		}

		_GGI_terminfo_freedbs(vis);

		free(tiinfo);
	}	

	free(LIBGGI_GC(vis));

	_terminfo_finalize_ncurses();

	return 0;
}

#include <ggi/internal/ggidlinit.h>
