/* $Id: box.c,v 1.10 1998/12/18 21:36:23 marcus Exp $
******************************************************************************

   SVGAlib target: box stubs

   Copyright (C) 1998 Marcus Sundberg   [marcus@ggi-project.org]
   Copyright (C) 1997 Jason McMullan    [jmcc@ggi-project.org]
   Copyright (C) 1995 Andreas Beck      [becka@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <ggi/internal/ggi-dl.h>
#include <ggi/display/svgalib.h>

/**********************/
/* draw/get/put a box */
/**********************/
int GGI_svga_drawbox(ggi_visual *vis,int x,int y,int width,int length)
{
	int x2;
  
	if (y< (LIBGGI_GC(vis)->cliptl.y)) {
		int diff=(LIBGGI_GC(vis)->cliptl.y)-y;
		y     +=diff;
		length-=diff;
	}
	if (y+length>(LIBGGI_GC(vis)->clipbr.y)) {
		length=(LIBGGI_GC(vis)->clipbr.y)-y;
	}
	if (x< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-x;
		x     +=diff;
		width-=diff;
	}
	if (x+width>(LIBGGI_GC(vis)->clipbr.x)) {
		width=(LIBGGI_GC(vis)->clipbr.x)-x;
	}

	if (length<=0 || width<=0 ) 
		return 0;

	vga_setcolor(LIBGGI_GC_FGCOLOR(vis));
	x2 = width+x-1;
	while(length--) {
		vga_drawline(x,y,x2,y);
		y++;
	}
	return 0;
}

int GGI_svga_putbox(ggi_visual *vis,int x,int y,int width,int length,void *buffer)
{ 
	int rowadd = (LIBGGI_PIXFMT(vis)->size+7)/8 * width;
	ggi_coord  tl=LIBGGI_GC(vis)->cliptl, br=LIBGGI_GC(vis)->clipbr;

	/* Pre-Clipping, so we don't call PutHline without need. */
	if (y< tl.y) {
		int diff=tl.y-y;
		y     +=diff;
		length-=diff;
		buffer = (uint8 *)(buffer)+rowadd*diff; 
	}
	if (y+length>=br.y) {
		length=br.y-y;
	}
	if (x< tl.x) {
		int diff=tl.x-x;
		x     +=diff;
		width -=diff;
		buffer = (uint8 *)(buffer)+diff;
		}
	if (x+width>=br.x) {
		width=br.x-x;
	}
	if (length<0||width<0)
		return 0;

	if (SVGA_PRIV(vis)->ismodex
		&& width%4 == 0
		&& x%4 == 0) {
		vga_copytoplanar256(buffer, rowadd, ((y*LIBGGI_MODE(vis)->virt.x+x))/4,
							LIBGGI_MODE(vis)->virt.x/4, width, length);
	} else
		while(length--) {
			ggiPutHLine(vis,x,y++,width,buffer);
			buffer= (uint8 *)(buffer)+rowadd; 
		}
	
	return 0;
}
