/* $Id: visual.c,v 1.11 1999/01/29 22:29:24 marcus Exp $
******************************************************************************

   Display-file: initialization

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <ggi/internal/ggi-dl.h>
#include <ggi/display/file.h>

#define NUM_OPTS  3
static gg_option file_options[NUM_OPTS] =
{
	{ "flushcmd", "" },
	{ "flushframe",  "0" },
	{ "flushtime",  "0.0" }
};

int GGIdlinit(ggi_visual *vis, const char *args,void *argptr)
{
	FileHook *ff;
	double fltime;
	
	LIBGGI_FD(vis) = -1;


	/* initialize */

	if (!args || !args[0]) {
		fprintf(stderr, "display-file: Missing filename.\n");
		return GGI_DL_ERROR;
	}

	GGIDPRINT("display-file: coming up (filename='%s').\n", args);
	
	LIBGGI_PRIVATE(vis) = ff = _ggi_malloc(sizeof(FileHook));
	LIBGGI_GC(vis) = _ggi_malloc(sizeof(ggi_gc));

	ff->flags = 0;
	ff->writer = (file_writer_func *) NULL;
	ff->fb_ptr = ff->file_mmap = NULL;

	/* handle arguments */
	if (getenv("GGI_FILE_OPTIONS") != NULL) {
		if (ggParseOptions(getenv("GGI_FILE_OPTIONS"),
			file_options, NUM_OPTS) == NULL) {
			
			fprintf(stderr, "display-file: error in "
				"$GGI_FILE_OPTIONS.\n");
			free(ff);
			return GGI_DL_ERROR;
		}
	}
	
	args = ggParseOptions((char *) args, file_options, NUM_OPTS);
			
	if (args == NULL) {
		fprintf(stderr, "display-file: error in "
			"arguments.\n");
		free(ff);
		return GGI_DL_ERROR;
	}

	ff->filename   = strdup(args);
	ff->flushcmd   = file_options[0].result[0] ? strdup(file_options[0].result) : NULL;
	ff->flushevery = atoi(file_options[1].result);
	fltime         = atof(file_options[2].result);
	ff->flushcnt   = 0;
	ff->flushtotal = 0;
	gettimeofday(&ff->flushlast,NULL);
	ff->flushstep.tv_sec  = fltime;
	ff->flushstep.tv_usec = (fltime-ff->flushstep.tv_sec)*1000000;
                                                	
	
	if (_ggi_file_ppm_detect(ff->filename)) {
		ff->writer = &_ggi_file_ppm_write;
	} else {
		ff->flags |= FILEFLAG_RAW;
	}


	vis->opdisplay->getmode=GGI_file_getmode;
	vis->opdisplay->setmode=GGI_file_setmode;
	vis->opdisplay->getapi=GGI_file_getapi;
	vis->opdisplay->checkmode=GGI_file_checkmode;
	vis->opdisplay->setflags=GGI_file_setflags;
	
	return GGI_DL_OPDISPLAY;
}

int GGIdlcleanup(ggi_visual *vis)
{
	FileHook *ff = FILE_PRIV(vis);

	GGIDPRINT("display-file: going down.\n");
	
	if (ff->fb_ptr != NULL) {
		GGI_file_resetmode(vis);
	}

	free(ff->filename);
	free(ff->flushcmd);

	free(FILE_PRIV(vis));
	free(LIBGGI_GC(vis));

	LIBGGI_PRIVATE(vis) = LIBGGI_GC(vis) = NULL;

	return 0;
}

#include <ggi/internal/ggidlinit.h>
