/**
 *
 * $Header: /cvsroot/hungry/lesstif/include/Motif-2.0/Xm/ActivatableT.h,v 1.1 1997/12/26 16:06:54 u27113 Exp $
 *
 * Copyright (C) 1997 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/


#ifndef XM_ACTIVATABLE_T_H
#define XM_ACTIVATABLE_T_H

#include <X11/Intrinsic.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * XmActivatableCallBackProc :
 *	Widget	w;		the widget
 *	XtCallbackProc	cb;	a callback procedure to be added or removed
 *	XtPointer cd;		client_data associated with the above
 *	Boolean setunset;	if true, cb gets added, otherwise it's removed
 */
typedef void (*XmActivatableCallBackProc)(Widget,
					XtCallbackProc,
					XtPointer,
					Boolean);

typedef struct {
	int				version;
	XmActivatableCallBackProc	changeCB;
} XmActivatableTraitRec, *XmActivatableTrait;

extern XrmQuark	XmQTactivatable;

#ifdef __cplusplus
}
#endif

#endif /* XM_ACTIVATABLE_T_H */

