/*
 * Unicode Conversion Library (Shift_JIS to UCS2)
 * 1999 by yoshidam
 *
 */

#ifdef USE_SJIS

#include <string.h>
#include "uconv.h"
#include "s2u.h"
#include "ustring.h"

int s2u_conv2(const unsigned char* s, UString* u, unknown_sjis unknown_s_conv)
{
  int i;
  int ui = 0;
  int len = strlen(s);

  allocUString(u);

  for (i = 0; i < len; i++) {
    if (s[i] < 128) {	/* ASCII */
      addUChar2(u, s[i], 0);
    }
    else if (s[i] >= 0xa0 && s[i] <= 0xdf) { /* JIS X 0201 kana */
      addUChar2(u, s[i] - 0x40, 0xff);
    }
    else if (s[i] < 0xfc && s[i + 1] >= 0x40 && s[i + 1] <= 0xfc) {
                                             /* JIX X 0208 */
      int hi = s[i];
      int low = s[i + 1];
      int key;
      unsigned short sc = 0;

      if (hi > 0xe0)
	key = (hi - 0xc1)*188;
      else
	key = (hi - 0x81)*188;
      if (low >= 0x80)
	key += low - 0x41;
      else
	key += low - 0x40;
      if (key < 11280)
	sc = s2u_tbl[key];
      if (sc == 0) {
	sc = '?';
	if (unknown_s_conv != NULL) {
	  unsigned char us[3] = {s[i], s[i+1], 0};
	  sc = unknown_s_conv(us);
	}
      }
      addUChar2(u, sc & 0xff, sc >> 8);
      i++;
    }
    else { /* Illegal sequence */
      unsigned short sc = '?';
      if (unknown_s_conv != NULL) {
	unsigned char us[2] = {s[i], 0};
	sc = unknown_s_conv(us);
      }
      addUChar2(u, sc & 0xff, sc >> 8);
    }
  }

  return u->len;
}

#if 0
unsigned short
conv(const unsigned char* s)
{
  return '?';
}

int
main(void)
{
  UString u;
  s2u_conv2("Abc\x82\xa0\x82\xa2\x82\xa4", &u, conv);
  dumpUString(&u);
  return 0;
}
#endif

#endif /* USE_SJIS */
