/* A YACC parser generated from "parser.y" */

# line 19
#ifndef lint
#define lint
#endif
#define defTycon(n,l,lhs,rhs,w)	 tyconDefn(intOf(l),lhs,rhs,w); sp-=n
#define sigdecl(l,vs,t)		 ap(SIGDECL,triple(l,vs,t))
#define fixdecl(l,ops,a,p)	 ap(FIXDECL,\
				    triple(l,ops,mkInt(mkSyntax(a,intOf(p)))))
#define grded(gs)		 ap(GUARDED,gs)
#define bang(t)			 ap(BANG,t)
#define only(t)			 ap(ONLY,t)
#define letrec(bs,e)		 (nonNull(bs) ? ap(LETREC,pair(bs,e)) : e)
#define qualify(ps,t)		 (nonNull(ps) ? ap(QUAL,pair(ps,t)) : t)
#if IGNORE_MODULES
#define exportSelf()		 NIL
#else
#define exportSelf()		 singleton(ap(MODULEENT,mkCon(module(currentModule).text)))
#endif
#define yyerror(s)		 /* errors handled elsewhere */
#define YYSTYPE			 Cell

static Cell   local gcShadow	 Args((Int,Cell));
static Void   local syntaxError	 Args((String));
static String local unexpected	 Args((Void));
static Cell   local checkPrec	 Args((Cell));
static Cell   local buildTuple	 Args((List));
static List   local checkCtxt	 Args((List));
static Cell   local checkPred	 Args((Cell));
static Pair   local checkDo	 Args((List));
static Cell   local checkTyLhs	 Args((Cell));
#if !TREX
static Void   local noTREX	 Args((String));
#endif
#if !IPARAM
static Void   local noIP	 Args((String));
#endif

/* For the purposes of reasonably portable garbage collection, it is
 * necessary to simulate the YACC stack on the Hugs stack to keep
 * track of all intermediate constructs.  The lexical analyser
 * pushes a token onto the stack for each token that is found, with
 * these elements being removed as reduce actions are performed,
 * taking account of look-ahead tokens as described by gcShadow()
 * below.
 *
 * Of the non-terminals used below, only start, topDecl & begin
 * do not leave any values on the Hugs stack.  The same is true for the
 * terminals EXPR and SCRIPT.  At the end of a successful parse, there
 * should only be one element left on the stack, containing the result
 * of the parse.
 */

#define gc0(e)			gcShadow(0,e)
#define gc1(e)			gcShadow(1,e)
#define gc2(e)			gcShadow(2,e)
#define gc3(e)			gcShadow(3,e)
#define gc4(e)			gcShadow(4,e)
#define gc5(e)			gcShadow(5,e)
#define gc6(e)			gcShadow(6,e)
#define gc7(e)			gcShadow(7,e)

#define EXPR 257
#define CONTEXT 258
#define SCRIPT 259
#define CASEXP 260
#define OF 261
#define DATA 262
#define TYPE 263
#define IF 264
#define THEN 265
#define ELSE 266
#define WHERE 267
#define LET 268
#define IN 269
#define INFIXN 270
#define INFIXL 271
#define INFIXR 272
#define PRIMITIVE 273
#define TNEWTYPE 274
#define DEFAULT 275
#define DERIVING 276
#define DO 277
#define TCLASS 278
#define TINSTANCE 279
#define WITH 280
#define DLET 281
#define REPEAT 282
#define ALL 283
#define NUMLIT 284
#define CHARLIT 285
#define STRINGLIT 286
#define VAROP 287
#define VARID 288
#define CONOP 289
#define CONID 290
#define QVAROP 291
#define QVARID 292
#define QCONOP 293
#define QCONID 294
#define RECSELID 295
#define IPVARID 296
#define COCO 297
#define UPTO 298
#define FROM 299
#define ARROW 300
#define IMPLIES 301
#define TMODULE 302
#define IMPORT 303
#define HIDING 304
#define QUALIFIED 305
#define ASMOD 306
#define NEEDPRIMS 307
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

#line 960


static Cell local gcShadow(n,e)		/* keep parsed fragments on stack  */
Int  n;
Cell e; {
    /* If a look ahead token is held then the required stack transformation
     * is:
     *   pushed: n               1     0          1     0
     *           x1  |  ...  |  xn  |  la   ===>  e  |  la
     *                                top()            top()
     *
     * Othwerwise, the transformation is:
     *   pushed: n-1             0        0
     *           x1  |  ...  |  xn  ===>  e
     *                         top()     top()
     */
    if (yychar>=0) {
	pushed(n-1) = top();
	pushed(n)   = e;
    }
    else
	pushed(n-1) = e;
    sp -= (n-1);
    return e;
}

static Void local syntaxError(s)	/* report on syntax error	   */
String s; {
    ERRMSG(row) "Syntax error in %s (unexpected %s)", s, unexpected()
    EEND;
}

static String local unexpected() {     /* find name for unexpected token   */
    static char buffer[100];
    static char *fmt = "%s \"%s\"";
    static char *kwd = "keyword";

    switch (yychar) {
	case 0         : return "end of input";

#define keyword(kw) sprintf(buffer,fmt,kwd,kw); return buffer;
	case INFIXL    : keyword("infixl");
	case INFIXR    : keyword("infixr");
	case INFIXN    : keyword("infix");
	case TINSTANCE : keyword("instance");
	case TCLASS    : keyword("class");
	case PRIMITIVE : keyword("primitive");
	case CASEXP    : keyword("case");
	case OF        : keyword("of");
	case IF        : keyword("if");
	case THEN      : keyword("then");
	case ELSE      : keyword("else");
	case WHERE     : keyword("where");
	case TYPE      : keyword("type");
	case DATA      : keyword("data");
	case TNEWTYPE  : keyword("newtype");
	case LET       : keyword("let");
	case IN        : keyword("in");
	case DERIVING  : keyword("deriving");
	case DEFAULT   : keyword("default");
	case IMPORT    : keyword("import");
	case TMODULE   : keyword("module");
	case ALL       : keyword("forall");
#if IPARAM
	case DLET      : keyword("dlet");
	case WITH      : keyword("with");
#endif
#undef keyword

	case ARROW     : return "`->'";
	case '='       : return "`='";
	case COCO      : return "`::'";
	case '-'       : return "`-'";
	case '!'       : return "`!'";
	case ','       : return "comma";
	case '@'       : return "`@'";
	case '('       : return "`('";
	case ')'       : return "`)'";
	case '{'       : return "`{', possibly due to bad layout";
	case '}'       : return "`}', possibly due to bad layout";
	case '_'       : return "`_'";
	case '|'       : return "`|'";
	case '.'       : return "`.'";
	case ';'       : return "`;', possibly due to bad layout";
	case UPTO      : return "`..'";
	case '['       : return "`['";
	case ']'       : return "`]'";
	case FROM      : return "`<-'";
	case '\\'      : return "backslash (lambda)";
	case '~'       : return "tilde";
	case '`'       : return "backquote";
#if TREX
	case RECSELID  : sprintf(buffer,"selector \"#%s\"",
				 textToStr(extText(snd(yylval))));
			 return buffer;
#endif
#if IPARAM
	case IPVARID   : sprintf(buffer,"implicit parameter \"?%s\"",
				 textToStr(textOf(yylval)));
			 return buffer;
#endif
	case VAROP     :
	case VARID     :
	case CONOP     :
	case CONID     : sprintf(buffer,"symbol \"%s\"",
				 textToStr(textOf(yylval)));
			 return buffer;
	case QVAROP    :
	case QVARID    :
	case QCONOP    : 
	case QCONID    : sprintf(buffer,"symbol \"%s\"",
				 identToStr(yylval));
			 return buffer;
	case HIDING    : return "symbol \"hiding\"";
	case QUALIFIED : return "symbol \"qualified\"";
	case ASMOD     : return "symbol \"as\"";
	case NUMLIT    : return "numeric literal";
	case CHARLIT   : return "character literal";
	case STRINGLIT : return "string literal";
	case IMPLIES   : return "`=>'";
	default        : return "token";
    }
}

static Cell local checkPrec(p)		/* Check for valid precedence value*/
Cell p; {
    if (!isInt(p) || intOf(p)<MIN_PREC || intOf(p)>MAX_PREC) {
	ERRMSG(row) "Precedence value must be an integer in the range [%d..%d]",
		    MIN_PREC, MAX_PREC
	EEND;
    }
    return p;
}

static Cell local buildTuple(tup)	/* build tuple (x1,...,xn) from	   */
List tup; {				/* list [xn,...,x1]		   */
    Int  n = 0;
    Cell t = tup;
    Cell x;

    do {				/*    .                    .	   */
	x      = fst(t);		/*   / \                  / \	   */
	fst(t) = snd(t);		/*  xn  .                .   xn	   */
	snd(t) = x;			/*       .    ===>      .	   */
	x      = t;			/*        .            .	   */
	t      = fun(x);		/*         .          .		   */
	n++;				/*        / \        / \	   */
    } while (nonNull(t));		/*       x1  NIL   (n)  x1	   */
    fst(x) = mkTuple(n);
    return tup;
}

static List local checkCtxt(con)	/* validate context		   */
Type con; {
    mapOver(checkPred, con);
    return con;
}

static Cell local checkPred(c)		/* check that type expr is a valid */
Cell c; {				/* constraint			   */
    Cell cn = getHead(c);
#if TREX
    if (isExt(cn) && argCount==1)
	return c;
#endif
#if IPARAM
    if (isIP(cn))
	return c;
#endif
    if (!isQCon(cn) /*|| argCount==0*/)
	syntaxError("class expression");
    return c;
}

static Pair local checkDo(dqs)		/* convert reversed list of dquals */
List dqs; {				/* to an (expr,quals) pair         */
    if (isNull(dqs) || whatIs(hd(dqs))!=DOQUAL) {
	ERRMSG(row) "Last generator in do {...} must be an expression"
	EEND;
    }
    fst(dqs) = snd(fst(dqs));		/* put expression in fst of pair   */
    snd(dqs) = rev(snd(dqs));		/* & reversed list of quals in snd */
    return dqs;
}

static Cell local checkTyLhs(c)		/* check that lhs is of the form   */
Cell c; {				/* T a1 ... a			   */
    Cell tlhs = c;
    while (isAp(tlhs) && whatIs(arg(tlhs))==VARIDCELL) {
	tlhs = fun(tlhs);
    }
    if (whatIs(tlhs)!=CONIDCELL) {
	ERRMSG(row) "Illegal left hand side in datatype definition"
	EEND;
    }
    return c;
}

#if !TREX
static Void local noTREX(where)
String where; {
    ERRMSG(row) "Attempt to use TREX records while parsing %s.\n", where ETHEN
    ERRTEXT     "(TREX is disabled in this build of Hugs)"
    EEND;
}
#endif
#if !IPARAM
static Void local noIP(where)
String where; {
    ERRMSG(row) "Attempt to use Implicit Parameters while parsing %s.\n", where ETHEN
    ERRTEXT     "(Implicit Parameters are disabled in this build of Hugs)"
    EEND;
}
#endif

/*-------------------------------------------------------------------------*/
short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 155,
	301, 176,
	-2, 189,
-1, 181,
	61, 448,
	-2, 407,
-1, 300,
	297, 237,
	44, 237,
	-2, 275,
-1, 308,
	301, 175,
	-2, 203,
-1, 363,
	61, 448,
	-2, 323,
-1, 427,
	256, 73,
	59, 73,
	125, 73,
	-2, 86,
-1, 429,
	301, 176,
	-2, 76,
-1, 445,
	301, 176,
	-2, 144,
-1, 449,
	301, 176,
	-2, 146,
-1, 496,
	40, 438,
	-2, 451,
-1, 497,
	44, 449,
	41, 449,
	123, 449,
	-2, 439,
-1, 499,
	301, 177,
	-2, 206,
-1, 501,
	301, 178,
	-2, 208,
-1, 569,
	288, 157,
	300, 157,
	304, 157,
	305, 157,
	306, 157,
	-2, 155,
-1, 595,
	301, 176,
	-2, 195,
-1, 657,
	301, 176,
	-2, 101,
-1, 691,
	301, 179,
	-2, 187,
	};
#define YYNPROD 482
# define YYLAST 3721
short yyact[]={

  42, 588, 686, 655,  53, 296, 800, 778, 653, 772,
 705, 151, 591, 675, 667, 683,  25, 674, 654, 593,
 153, 324,  48, 644, 650, 582, 641, 787,  41, 720,
 623, 200, 213, 421, 490, 263, 126, 507, 452,   9,
 438,  60, 198, 426,  10, 361, 274, 458, 203, 280,
  53, 139, 156, 278, 279, 651, 392, 266, 273, 418,
 206, 180, 480, 157, 581, 201,   7, 175, 557, 281,
 100, 165,  44, 624,  76,  76, 554, 214,  44,  59,
  56, 152, 744, 757,  55, 133,  54, 557,  45,  46,
  47, 298, 724, 204,  45,  46,  47, 205,  76, 685,
 572,  44,  49, 182, 570, 564, 598, 562, 297, 307,
  44, 765, 167, 746, 166, 693, 168,  45,  46,  47,
  44, 249, 167,  51, 182, 188,  45,  46,  47, 808,
 212, 536, 150, 139, 538, 350,  45,  46,  47, 262,
 557, 267, 139, 375, 271, 139, 328,  66,  66, 143,
  63, 176, 235, 235, 816, 311, 139, 234, 236, 139,
 415, 783, 268, 348, 423, 272,  44,  62, 167, 469,
 187, 113, 168, 135,  76, 115, 441, 144, 299, 167,
 642, 782,  45,  46,  47,  56, 567,  52, 292,  55,
 310, 666, 566, 260, 425, 469, 167, 427, 424, 425,
 168, 250, 467, 424, 596, 622, 303, 260, 518, 325,
 721, 719, 148, 422, 461, 728, 722, 217, 775, 221,
  71,  61, 770, 533, 194, 428, 487, 362, 456, 465,
 463, 428, 115, 385, 192, 220, 333, 195, 138, 349,
 367, 370, 775, 302, 374, 378, 149,  66, 329, 621,
 172, 299, 462, 751,  53, 436,  53, 463,  53, 325,
 186, 292, 139, 194, 351, 146, 583, 124, 369, 529,
 380, 139, 456, 192, 330, 333, 195, 450, 135, 303,
 463, 624, 459, 435,  53,  53, 495, 699,  53,  53,
 569, 459, 351, 441, 379, 417,   5,   2,   3,   4,
 741, 320, 430, 433, 612, 204, 444, 448, 139,  44,
 139, 824, 101, 139, 139,  86, 302, 323, 447, 371,
 138, 210, 158, 491, 104,  45,  46,  47, 498, 742,
 319, 460, 556, 503, 504, 459, 107, 485, 353,  84,
 326, 355, 356, 138, 516, 318, 138, 317, 182, 139,
  44, 556,  56, 647, 415, 508,  55, 183,  54, 416,
 325, 143, 722, 475, 248, 303,  45,  46,  47, 517,
 186,  44, 513, 136, 514, 251, 105, 396, 799, 398,
 377, 401, 187, 103, 521, 325, 524,  45,  46,  47,
 326, 681, 823, 511, 176, 509, 484, 532, 139, 354,
 139, 139, 302,  44, 556, 139, 555, 139,  74, 515,
 139, 186, 139, 483, 139, 548, 139, 247, 178,  45,
  46,  47, 825, 455,  44, 540, 646, 560, 534, 531,
 139,  56, 545, 139, 546,  55, 549, 353, 355, 356,
  45,  46,  47, 351, 115, 565, 139, 161, 468, 138,
 139, 139, 412, 299, 139, 414, 558,  74, 138, 542,
 332,  69, 544, 292, 453, 539,  44, 455,  43, 157,
 553, 575, 547, 551, 576, 552, 768, 165, 191, 550,
 196, 303,  45,  46,  47,  74, 618, 592, 571,  69,
  44, 326,  43, 451, 493,  44, 577, 138, 420, 235,
 384, 157,  64, 157, 580, 579,  45,  46,  47, 464,
 466,  45,  46,  47, 600,  80, 326, 191, 302, 341,
 606, 605, 343, 419, 607, 608, 225, 617, 616, 586,
 365, 587, 314, 327,  44, 413, 497, 833,  38, 815,
 496,  44, 139, 613, 139, 814, 614, 362, 494, 475,
  45,  46,  47, 542, 764, 544,  44,  45,  46,  47,
 139, 745, 157, 631, 157, 716, 157, 670, 477, 481,
 482, 682,  45,  46,  47, 501, 630, 679, 502, 364,
 649, 537, 530, 299, 592, 138, 165, 138, 138, 639,
 663, 684, 663, 292, 635, 311, 139, 638, 139, 352,
  20, 331, 342,  39, 441,  44, 665, 671, 669,  38,
 672, 303, 832, 689, 233, 680, 229, 138,  85, 668,
 138,  45,  46,  47, 396,  90, 398, 106, 344, 559,
 310, 491, 706, 138, 813, 648,  74, 138, 230, 410,
  69, 232, 411, 408, 812, 299, 409, 260, 302, 700,
 508, 710, 131, 684, 766, 292, 708, 311, 139, 139,
 139, 709, 139, 139, 235, 763, 560, 714, 723, 712,
 560, 698, 762, 303, 755, 689, 747, 139, 139, 715,
 139, 718, 584, 678, 752, 584, 139, 584, 139, 684,
 181,  90, 310, 139, 139, 139, 199, 743, 407, 637,
 748, 238, 199,  90, 756, 753, 224, 625, 750, 260,
 302, 181, 758, 759, 760, 611, 713, 609, 691, 535,
 761, 231, 157, 244, 752, 139, 139, 139, 784, 138,
 311, 138, 139, 139, 139, 139, 139, 241, 270, 353,
 767, 139,  50, 157, 402, 157, 774, 801, 689, 300,
 663, 403, 157, 663, 404, 139, 388, 752, 139, 804,
 806, 794, 795, 805, 807, 730, 660, 803, 660, 339,
 592, 663, 340, 663, 387, 810, 256, 780, 809, 257,
 691, 706, 260, 138, 157, 138, 139, 311, 132, 139,
  90, 597, 820, 139, 139, 776, 246,  90, 245, 690,
 668, 155, 493, 254, 154, 689, 255, 747, 243, 157,
 242,  90, 663,  90, 363, 207, 240, 157, 831,  90,
 828, 822, 300, 830, 829, 239, 157, 152, 835, 338,
 801, 834, 789, 826, 827, 592, 337, 717, 139, 260,
 789, 789, 640, 774, 689, 138, 836, 138, 237, 138,
 138, 238,  44, 615, 646, 141,  44, 228, 839, 142,
 229, 690, 727, 306, 138, 138, 737, 738,  45,  46,
  47, 109,  45,  46,  47, 138,  68,  65, 725, 261,
 733, 734, 226,  73, 659, 227, 659, 391, 597, 376,
 440, 223, 222, 309, 441, 821, 179, 174, 441,  44,
 789,  56,  90, 584,  90,  55, 620,  54, 486, 130,
 781, 619, 112, 506, 138,  45,  46,  47, 127, 138,
 138, 110,  87, 138,  17,  49, 660, 199, 138, 660,
 790, 173,  35, 505, 690, 181,  18,  11, 790, 790,
  13, 360, 138, 190, 199,  49, 199, 660, 211, 660,
  90, 793, 189, 359,  90, 457, 199,  90, 199,  90,
  90, 160, 454, 602, 471,  78, 291, 219, 218, 199,
 819, 314, 290, 138, 265, 478, 264, 479,  79, 519,
 138, 731, 522,  37, 525, 527, 134,  28, 660, 673,
 727, 690, 397, 574, 399, 573, 400, 446, 790, 568,
 442, 194, 437, 818, 817, 798, 725, 662, 597, 346,
 661, 192, 137, 333, 195, 597, 597, 597,  26, 777,
 159, 838, 429, 432, 300, 277, 445, 449, 476, 771,
 690, 346, 769, 314, 643, 736, 739, 704, 702, 489,
 275, 305, 140, 147, 659, 145,  58, 659, 731,  57,
   1,   0,  44,   0,  56,   0, 731, 731,  55,   0,
  54,   0,   0,   0, 140, 659,   0, 659,  45,  46,
  47,   0,   0, 599, 597, 601, 604,   0,   0,   0,
   0, 601,   0,   0,   0, 601, 601,   0,  90,   0,
  90,   0,   0, 141, 137,   0,   0, 142,   0, 495,
 791,   0,   0, 703,   0, 314, 659,   0,   0, 796,
 439, 731,   0, 194, 797, 141, 731, 137,   0, 142,
 137,   0,   0, 192,  90, 333, 195,  90,   0,   0,
  90,   0,  90,   0, 363, 199,   0,   0,   0, 597,
   0, 443,  44,   0,   0, 541,  44,   0, 543, 626,
   0,   0, 627,   0, 300, 628,   0, 629,  45,  46,
  47, 645,  45,  46,  47,   0, 346,   0,   0, 346,
 440, 346, 346,  44,  34,  56,  31,  32,  33,  55,
  44,  54,  43,   0,  38,   0,  40,  36,  27,  45,
  46,  47,   0,  44,   0,  56,  45,  46,  47,  55,
   0,  54,   0,   0,   0,   0,   0, 595,   0,  45,
  46,  47,   0,  90,  90,  90, 300,   0,   0,  77,
   0,  74, 199, 137,   0,  69,   0, 393,   0,   0,
   6,   0, 137,   0,   0,   0,   0,   0,   0, 541,
   0, 543,   0,  83, 645,   0, 140, 308,   0,   0,
 125, 102,   0,   0,   0, 191,   0, 196, 159, 334,
   0, 197,   0, 108,   0, 129, 347,  94,   0,   0,
  30, 137,   0,   0,   0,   0,   0,   0,   0,   0,
 159,   0,  30,  30,   0,  30,   0, 495,  88,   0,
  44,  30,  56,   0,  30,   0,  55, 141,  54,   0,
 657, 142, 657,  30, 595,  30,  45,  46,  47, 676,
   0, 677,  44,   0,  56,   0,   0,   0,  55,   0,
 645, 773,   0, 779,   0,   0,   0,   0,  45,  46,
  47, 837,  30, 687,   0,   0, 346,   0, 594, 346,
   0,   0, 346,   0, 346, 802,   0,  44,  30,  43,
   0,  38,  30,  40, 185,   0,   0, 701,   0, 137,
   0, 137, 137,  45,  46,  47, 216, 191,  91,   0,
   0, 334,   0,  30,   0,   0,   0,   0,   0,   0,
  30,  30,   0,   0,   0,   0,  30,   0,  78, 141,
   0, 137,   0, 142, 137, 687,   0, 732,  75,   0,
  67,  79,   0,   0,   0,   0,   0, 137, 658,   0,
   0, 137, 335,   0,   0, 656,   0,   0, 773, 779,
   0,   0,   0,   0, 754,   0,   0,  19, 802,   0,
  30, 754, 754, 754,   0,   0,   0,  30,   0,   0,
   0,   0,  82,  29,   0, 366,   0,   0, 372, 373,
   0,  70,  30, 336,   0, 381,   0, 382,   0, 383,
 657, 208, 159, 785, 732,  93, 141, 208, 792,   0,
 142,   0, 732, 732, 357, 389, 358, 390,   0, 395,
   0, 657,   0, 657,   0,  30,   0,   0,  30,  30,
 595,   0, 164,   0,  44,  30,  56,  30,   0,  30,
  55,  30,  54, 137,   0, 137, 259,   0, 171,   0,
  45,  46,  47,   0, 208,  30,   0,  30,  30,  30,
   0,   0, 657,   0,   0, 792,   0, 732,   0,   0,
   0,  93, 732,   0,   0,  44, 209,  43,   0,  38,
   0,  40, 209,  93,   0,   0,  82, 155,   0,   0,
   0,  45,  46,  47, 159, 595, 510, 137,   0, 137,
 512,   0,   0,   0, 155, 470,  78, 473,   0,   0,
   0,  92, 241,   0, 492,   0, 478,   0, 479,  79,
   0, 688,   0,   0,   0,   0,  44, 208,  56, 209,
 316,   0,  55,   0,  54,  30,  30, 322,   0,   0,
  30,   0,  45,  46,  47,   0,   0,   0,   0,   0,
   0,   0,   0, 357,   0,  92,   0,   0,   0, 137,
 215, 137,  98, 137, 137,   0,  97,   0,   0, 585,
  93, 664,   0,   0,   0,   0,   0, 209, 137, 137,
   0,   0,  77,   0,  74,   0,  72,   0,  69, 137,
   0,  93,   0,  93,   0,   0,   0,  99, 652, 209,
   0, 171, 209,  44,   0, 497,  98,   0, 128,  55,
  97,  54,   0, 208,   0,   0,   0,   0,   0,  45,
  46,  47,   0, 726, 578,   0,   0,   0, 137,   0,
 729,   0, 208, 137, 137,   0,   0, 137,   0,   0,
   0,  99, 137,   0,   0,   0,   0,   0,   0, 208,
   0, 208,   0,   0,   0,   0, 137,   0,   0,   0,
   0, 208,   0, 208,  30,   0,   0,  30,   0,   0,
   0,   0,   0,   0, 208,   0,   0,   0,   0,   0,
   0, 141,  93,   0,  93, 142, 728, 137, 209,   0,
   0, 470,   0, 473, 137,   0,   0,   0,   0,   0,
   0, 632, 633,   0, 634, 119, 636, 209,   0,   0,
   0,   0,  35, 114,   0, 117, 125, 118, 120,   0,
   0,   0,   0,   0, 209,   0, 209, 345,   0, 208,
  93,   0,   0,   0, 209,   0, 209, 209, 209, 209,
 209,  30,  30,   0,  30,  30,  30,   0,   0, 209,
   0,   0,   0,   0,   0,  89,  95,  96,   0,  44,
  77,  43,  74,  37,  21,  40,   0,  28,  70,   0,
   0,   0,   0,   0,   0,  45,  46,  47,   0,   0,
 208, 208,   0, 304,   0,   0, 208,   0, 215, 711,
 208, 208,   0,   0,   0,   0,   0,   0,  26, 202,
  95,  96, 276,  44, 209,  43,   0,   0,   0,  40,
   0,   0,   0,   0,   0,   0, 695, 696, 697,  45,
  46,  47, 492, 707,   0,   0,   0,   0,   0,  30,
   0, 304,  30,   0,  98,   0, 215,   0,  97,   0,
 208,   0,   0,   0, 658,   0,   0,   0,   0, 749,
 276, 656,   0,   0,   0, 209, 209,   0,   0, 208,
   0, 209,   0,   0,   0, 209, 209,   0,  93,  99,
  93,   0,   0,   0,   0,   0,   0,   0,  44,  74,
  56,   0,  98,   0,  55,   0,  97,   0, 304,  30,
   0,   0,   0, 215,  45,  46,  47,   0,   0,   0,
   0,   0, 141,   0, 209,   0, 142, 209,   0,   0,
 209,   0, 209,   0,   0, 209,   0,  99,   0,   0,
   0, 208,   0,   0,   0,   0,   0, 208,   8,   0,
   0,   0,  15, 811, 209,   0,  23,   0,   0,  98,
  22,   0,   0,  97,   0,   0,  35,   0,   0,  16,
   0,  14,   0,  24,  34,   0,  31,  32,  33, 116,
  44, 122,  43, 121,  38, 123,  40,  36,  27,   0,
   0,   0, 707,  30,  99,   0,  45,  46,  47,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,  93,  93,  93, 209,  37,  21, 128,
   0,  28, 209,   0,  35, 283, 282,   0,   0,  14,
   0,   0,   0, 293, 294, 295, 286, 284, 289,   0,
   0, 287, 288,   0,   0,   0,   0, 301,  95,  96,
   0,  44,  26,  43, 495, 488,   0,  40,   0,   0,
   0,   0,   0,   0,   0,   0, 281,  45,  46,  47,
 285,   0,   0, 283, 282,  37,  21,   0,   0,  28,
   0, 293, 294, 295, 286, 284, 289, 664,   0, 287,
 288,   0,   0,  35,   0, 301,  95,  96,  14,  44,
   0,  43,   0,   0,   0,  40,   0,   0,   0,   0,
  26,   0,   0,   0,   0,  45,  46,  47, 285,  44,
   0, 497,   0,   0,   0,  55,   0,  54,   0,   0,
 283, 282,   0,   0,   0,  45,  46,  47, 293, 294,
 295, 286, 284, 289,  37,  21, 287, 288,  28,   0,
  35, 386, 301,  95,  96, 169,  44,   0,  43,   0,
   0,   0,  40,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  45,  46,  47, 285,   0,   0,   0,  26,
   0,   0,   8,   0,   0,   0,  15,   0,   0,   0,
  23,   0,   0,   0,  22,   0,   0,   0,   0,  35,
   0,  37,  21,  16,  14,  28,   0,  24,  34,   0,
  31,  32,  33,   0,  44,   0,  43,   0,  38,   0,
  40,  36,  27,   0,   0,   0,   0,   0,   0,   0,
  45,  46,  47,   0,   0,   0,  26,   0,   0,   0,
   8,   0,  35,   0,  15,   0,   0,  14,  23,   0,
  37,  21,  22,   0,  28,   0,   0,   0,   0,   0,
   0,  16,   0,   0,   0,  24,  34,   0,  31,  32,
  33,   0,  44,   0,  43,   0,  38,   0,  40,  36,
  27,  35, 241,   0,   0,  26,   0,   0,  45,  46,
  47,   0,   0,  37,  21,   0,   0,  28,   0,   0,
   0,   0,  44,   0, 497,   0,  38,   0, 496,   8,
   0,   0,   0,  15,   0,   0, 494,  23,  45,  46,
  47, 394,   0,   0,  35,   0,   0,   0,  26, 169,
  16,   0,  37,  21,  24,  34,  28,  31,  32,  33,
   0,  44,   0,  43,   0,  38,   0,  40,  36,  27,
   0,   0,   0,   0,   0,   0,   0,  45,  46,  47,
   0,   0,   0,   0,   0,   0,   0,  26,   0,   0,
  15,   0,   0,   0,  23,  37,  21,   0,  22,  28,
   0,   0,   0,  35,   0,   0,   0,  16, 162,   0,
   0,  24,  34,   0,  31,  32,  33,   0,  44,   0,
  43,   0,  38,   0,  40,  36,  27,   0,   0,   0,
  26,   0,   0,   0,  45,  46,  47,   0,   0,  15,
   0,   0,   0,  23,   0,   0,  35,  22,   0,   0,
   0,   0,   0,   0,  37,  21,  16,   0,  28,   0,
  24,  34,   0,  31,  32,  33,   0,  44,   0,  43,
   0,  38,   0,  40,  36,  27,   0,   0,   0,   0,
 140,   0,  15,  45,  46,  47,  23,   0,   0,  26,
 177,   0,   0,   0,   0,   0,   0,  37,  21,  16,
   0,  28,   0,  24,  34,   0,  31,  32,  33,   0,
  44,   0,  43,   0,  38,   0,  40,  36,  27,   0,
   0,  15,   0,   0,   0,  23,  45,  46,  47,  22,
   0, 141,  26,   0,   0, 142, 728,   0,  16,   0,
 594, 258,  24,  34, 125,  31,  32,  33,   0,  44,
   0,  43,   0,  38,   0,  40,  36,  27,   0,   0,
   0,  12,   0,   0,  15,  45,  46,  47,  23,   0,
  78,   0,  22,   0,   0,   0,  81,  92,   0,   0,
 472,  16, 474,  79,   0,  24,  34,   0,  31,  32,
  33, 141,  44,   0,  43, 142,  38, 111,  40,  36,
  27, 186,   0,   0,   0,   0,   0,   0,  45,  46,
  47,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,  15,   0,   0, 163,  23,  98,   0,
   0,  22,  97, 476, 594, 308,   0,   0, 125,   0,
  16,   0, 170,   0,  24,  34,   0,  31,  32,  33,
   0,  44,   0,  43,   0,  38,   0,  40,  36,  27,
   0,   0,   0,  99,   0, 194,  15,  45,  46,  47,
  23,   0, 304, 114,  22, 192, 125, 193, 195,   0,
  81,   0,   0,  16,   0, 141,   0,  24,  34, 142,
  31,  32,  33,   0,  44,   0,  43,   0,  38,   0,
  40,  36,  27,   0,   0,   0, 194,   0,   0,   0,
  45,  46,  47,  92, 114, 788, 192, 125, 193, 195,
   0,   0, 729,  98, 315,   0,   0,  97,  44,  74,
  56, 321,   0,   0,  55,   0,   0,   0,   0,   0,
   0,   0,   0,   0,  45,  46,  47,   0,   0,   0,
   0,   0, 304,   0,   0,   0, 159, 215,  99,   0,
   0,   0,   0,   0,  98, 594, 258,   0,  97, 125,
   0, 368,   0, 141,   0,   0,   0, 142,   0,   0,
   0,   0,   0, 688,   0,   0,   0,   0,  44, 196,
  56,   0,   0,   0,  55, 170,  54,   0,   0,  99,
 259,   0,   0,  98,  45,  46,  47,  97, 594, 308,
   0,   0, 125,   0,   0, 140, 141,   0,   0,   0,
 142,  89,  95,  96,  77,  44,  74,  43,   0,   0,
  69,  40,   0,   0,   0,   0, 563, 325,  99,   0,
   0,  45,  46,  47,   0,   0,  92,   0,   0,   0,
 159, 215,   0,  92, 610,   0,   0,   0,   0, 141,
   0,   0,   0, 142,   0,   0, 141,   0,   0,   0,
 142,   0,   0,   0,   0,   0, 140, 688,   0,   0,
   0,   0,  44, 196,  56,   0,   0,   0,  55,  49,
  54,   0,   0,   0, 259,   0,   0,  98,  45,  46,
  47,  97,   0,   0,  98,   0,   0,   0,  97,   0,
   0,   0,   0,   0,   0,   0, 301,  95,  96, 191,
  44, 196,  43,   0,   0, 197,  40, 141,   0,   0,
   0, 142,  99,   0,   0,   0,  45,  46,  47,  99,
  92,   0,   0,   0,   0, 215,   0,   0, 140, 258,
   0,   0, 125,   0,   0,   0,   0, 202,  95,  96,
 191,  44, 196,  43,   0,   0, 197,  40, 326,   0,
  44,   0,  56,   0,   0,   0,  55,  45,  46,  47,
   0, 159, 293, 294, 295,  92,  45,  46,  47,   0,
 528,  98,   0,   0,   0,  97, 301,  95,  96, 141,
  44,   0,  43, 142, 594,   0,  40,   0, 688,   0,
   0,   0,   0,  44,   0,  56,  45,  46,  47,  55,
   0,  54,   0,   0, 159, 259,  99,  92,   0,  45,
  46,  47, 526,   0,  92,   0,  98,   0,   0, 523,
  97,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 688,   0,   0,   0, 141,  44,   0,  56, 142,
   0,   0,  55,  44,  54,  56,   0,   0, 259,  55,
  92,  99,  45,  46,  47, 520,   0,   0,  98,  45,
  46,  47,  97,   0,   0,  98,   0,   0,   0,  97,
 202,  95,  96,  92,  44,   0,  43,  89,  95,  96,
  40,  44,   0,  43,   0, 434,  92,  40,   0,   0,
  45,  46,  47,  99,   0,   0,   0,  45,  46,  47,
  99,  98,   0,   0,  44,  97,  56,   0,   0,   0,
  55,   0,  92,   0,   0,   0, 692,  44,   0,  56,
  45,  46,  47,  55,  98,  54,   0,   0,  97,   0,
   0,   0, 594,  45,  46,  47,  99,  98,   0,   0,
   0,  97,   0,   0, 159, 140, 405,   0,   0, 406,
   0,   0, 140, 499,   0,   0, 500,   0,   0,  99,
   0,   0,   0,  98, 603,  95,  96,  97,  44,   0,
  43, 140,  99,   0,  40,   0,  44,   0,  56,   0,
   0,   0,  55, 141,  45,  46,  47, 142, 259,   0,
 594,   0,  45,  46,  47,   0, 141,   0,  99,   0,
 142,   0,   0, 141,   0, 658,   0, 142,   0,  89,
  95,  96, 786,  44,   0,  43,   0,   0,   0,  40,
   0,   0, 141,   0, 269,   0, 142, 590,   0,  45,
  46,  47,  44,   0,  56, 140, 252,   0,  55, 253,
  54, 141,   0,   0,   0, 142,   0, 740,  45,  46,
  47,  89,  95,  96, 729,  44,   0,  43,  89,  95,
  96,  40,  44, 141,  43,   0,   0, 142,  40,   0,
   0,  45,  46,  47,   0,   0,   0,   0,  45,  46,
  47,   0,   0,   0,   0, 735, 141,  49,   0, 345,
 142,   0, 729,   0,  89,  95,  96,   0,  44,   0,
  43,   0,   0,   0,  40, 141,   0,   0,   0, 142,
   0,   0, 140,   0,  45,  46,  47,  89,  95,  96,
   0,  44,   0,  43,   0,   0,   0,  40,   0,   0,
  89,  95,  96,   0,  44,   0,  43,  45,  46,  47,
  40,   0,   0, 141,   0,   0, 184, 142, 589,   0,
  45,  46,  47, 140,   0,   0,  89,  95,  96,   0,
  44,   0,  43, 141,   0,   0,  40, 142,   0,   0,
   0,   0, 140,   0,   0, 590,  45,  46,  47, 140,
  44,   0,  56,   0,   0,   0,  55, 159,  54,   0,
   0,   0, 140,  44,   0,  56,  45,  46,  47,  55,
  44,   0,  56,   0, 141, 312,  55,   0, 142,  45,
  46,  47, 312, 561, 729,   0,  45,  46,  47,  44,
   0,  56,   0, 141,   0,  55,   0, 142, 664,   0,
 141,   0,   0,   0, 142,  45,  46,  47,  44,   0,
  56,   0,   0, 141,  55,   0,  54, 142,   0,   0,
   0,   0,   0,   0,  45,  46,  47,   0,   0,   0,
  44,   0, 497,   0,   0, 141,  55,   0,   0, 142,
   0,   0,   0,   0,   0,   0,  45,  46,  47,   0,
   0,   0,   0,  44,   0,  56,   0,   0,   0,  55,
   0,   0,   0,   0,   0,   0,   0,   0,   0,  45,
  46,  47,  44, 431,  56,   0,   0,   0,  55,   0,
   0,   0,   0,   0,   0,   0,   0,   0,  45,  46,
  47,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,  44,   0,  56,   0,   0,
  44,  55,  56,  54,   0,   0,  55,   0,   0,   0,
   0,  45,  46,  47,   0,   0,  45,  46,  47,   0,
  44,   0,  56,   0,   0,   0,  55,   0,   0,   0,
   0,   0, 694,   0,   0,   0,  45,  46,  47,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,  44,   0,  56,   0,   0,   0,  55,   0,   0,
   0,   0,   0, 312,   0,   0,   0,  45,  46,  47,
  44,   0,  56,   0,   0,   0,  55,  44,   0,  56,
   0,   0, 313,  55,   0,   0,  45,  46,  47,   0,
  44,   0,  56,  45,  46,  47,  55,   0,   0,   0,
   0,   0,   0,   0,   0,   0,  45,  46,  47,   0,
   0,   0,  44,   0,  56,   0,   0,   0,  55,   0,
   0,   0,   0,   0,   0,   0,   0,   0,  45,  46,
  47 };
short yypact[]={

  40,-1000,2024, 905,-223,-1000, -46,-1000,-1000,-130,
-1000,1355,1355,-1000,2426,2024, 216, 892,-1000,-1000,
 192,3112, 189,2024, 201, 312, 892,-1000,-1000,-1000,
 213,-1000,-1000,-1000,-1000,1732,-1000,1966,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000, 611,
3379,-1000,-1000, 269,-120,-1000,-1000,-1000,   9, -44,
-1000, 189, 764, 201,2383,-1000,-1000,-1000,-1000,-1000,
-178,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
2324,-1000,-1000, -11,2242, 192, 317,3086,-1000,-1000,
 306,-1000,2693,-1000, 198,-1000,-1000,-1000,1575,3112,
 -52,-1000, -30, -50,-1000, 892, 192, 317, 841, 816,
 597,1355,2199,2199,-1000, 807, 784, 775,2281, 769,
 767, 682, 757, 755,-1000,-1000, 356, 271,-1000,  77,
 572,-1000,3235, 762, 735,-1000,-1000,-1000,-1000,-1000,
2928,3171,-1000,-216,1024,1803,-1000, 823,-1000,-1000,
-1000,-1000,-192,-1000,1206,3353,-1000, 269,3372,-1000,
-1000,-1000,2426,-1000,-1000, 251, 249, 234, 205,2426,
-1000,-1000, 194, 134, 474,-1000,-153, 189, 149, 557,
-1000,-1000, 399,1080,2024,-1000,3112, 795, 788, 728,
 478, 784, 775,1531, 769, 767, 757, 755,-134, 196,
 555,-1000, 168,-1000, 338, 168, 168,3112,-1000,3112,
 317, 486,-1000,-1000,-1000,3073,-1000,2024,2732, 260,
2024,2024,  84, 235, 192, 145,-1000,2024,-1000,2024,
-1000,2024,-216,2150, 733,-1000, 715,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,2024,-1000,2024,
2093,2024,-1000,-210,-1000,-210,-1000,-210,-1000, 703,
 710,3145, 657, 602, 598, 411,-1000,-137, 266,-1000,
3353,-1000,-1000, 134,-1000, 464,-1000, 439,-1000,-1000,
-1000, -92, -59,3287,2869,  -1, 854, 885,  62, 237,
-1000, 167, 211,  -4, -27, -54, 151,-1000,3112,-1000,
2557, 932, 932, 932,2652, -41,2054,1024,-1000,3152,
 534,  57,1024,1024,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,2826,-1000,-1000,-1000,2242,2024, -52,
-1000, 317,2024, 696, 682,-1000,-1000,-1000,-1000,-1000,
2826,-1000,2826,-216,-1000,-1000,3112,-1000,1024, -76,
3050, -94,2826,3014,2826,3007,2965,-1000,-1000, 144,
 538,-1000, 368,-1000,-1000,2826,-1000,-1000,-1000,-1000,
-1000,-1000, -43,-1000,-1000,-1000,-1000, 367,-1000,-1000,
-1000,-1000,-1000, 678,-1000, 356,-1000,-1000,-1000,-1000,
-167, 537,-1000,-165, 189,-1000,-1000,3379,-1000,3379,
3379,-1000,-1000,-1000,1024,-1000,1024,-1000,-1000,1024,
-1000,1024,-1000,1024,-216,1024,-1000,-1000,-1000,-234,
1908, 100, -87,-1000,-1000,-1000, 568,-1000,-1000,3392,
-194,-1000,2795,-196,-1000,-1000,-1000, 148,-1000,-1000,
-100, 230, 166,-1000,-197,3379, -46,-1000,-201,3379,
1024,-1000,-1000,1024, -46,-1000,2024, 158,-1000,2199,
-1000,1533,-1000,-1000,1533,-1000,1533,-1000,3132, 858,
-1000,2826,2920,-1000,-1000,-1000,-122,2826,-1000,-1000,
-1000,2826,2826, 676,2833, 674,2557, 181,-1000, 502,
-1000,-1000,-1000, 813, -87, 968,-1000,-1000,-1000,-1000,
1002,-1000,1002,-1000,-1000, 134, 427,-1000, -51,-1000,
-1000,-1000,-1000,-1000, 666,-1000, 338,-1000,-1000,-1000,
3112,-1000,-1000,3112,-1000,-1000,3112,-1000,3112,-1000,
 317,2826,-1000,2024,2024,-1000,2024,2093,2024, -52,
-1000,3353,-1000,3353,-1000,-1000, 658,-1000,-137,-1000,
1851,-1000,-1000,-1000,-1000, -87, 802, 136,  47,1024,
-1000,1375, -65,1375, -65,2984, 858,-1000, -46,-1000,
-105,-1000,-105, 642, 533,-1000, 211,-1000,-1000,-1000,
 330, 527,-1000,-1000,-1000,-168, 527, 527,-1000,-1000,
-216,-1000,-202,-1000,2788,2856,-185,3312,-1000,-1000,
-1000, 347,-1000, 168, 347,-1000,-1000,-1000,-1000,3112,
3112,3112,1803,-1000, 246,1059,-1000,-1000,2826, -46,
 157,2024,-1000,-1000,2199,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,  28,
 136, 638,-1000, 521,-1000,-1000, 797, -87,-1000, -58,
  86,-1000,-216,-1000,-209,-1000,2614,1650,3379,2460,
 119,3292,3254, 177,-1000, 268,-1000, -60,-1000,  21,
-1000,-1000,-1000, 517,-1000,-187,3379,3379,-1000,1024,
-1000,2024,1533, 207,-1000,3414, 633,3152,-216,-218,
-1000,-1000,3414,3414,3414,-1000,-1000,-1000, 134,-1000,
-1000, 631, 624,-1000, 510,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-189,-1000, 613,-1000, 564, 178,  28, 858,
-1000,1375, 141, 115,3212,2702,3379,-1000,-111,2745,
 119,3379,3379,2702,2702,3379,-1000,-1000,-1000,-1000,
3379, 253,1375,-1000,1375,-1000,-1000,-1000,-1000,-1000,
-1000,3190,-1000,-1000,2856,-1000,  83,1024,-1000,-1000,
-1000,-1000,-1000,-1000,1247,2024,-1000,-1000, 603, 593,
-1000, 501,-1000,-1000,-1000, 191,-1000, 495,-1000,-143,
-1000,-1000,-105,1871,-1000,1650,2520,-1000,3379,-1000,
-1000,-1000,3145,2702,-1000,-1000,-1000,-1000, 267,-1000,
-1000, 125,-1000,  86, -60,-1000,-216,-1000, 764,-1000,
-1000,-1000,-1000,-1000, 202, 858,2984, 571, 493,-1000,
-1000,-1000,-1000,-1000, 858,1298,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-105,-1000,-1000,-1000,1024,-1000,-1000 };
short yypgo[]={

   0,1050,1227,  41,  18,1049,1046,1045,  58,  21,
1043,1041,  33,  46,1040,  59,1039,  34,  16,1267,
 187,1038,1037,  10,  53,  76,  26,1034,  23, 603,
1032,1029,   9,  28,1025,  54,  49,  43,  20,1019,
 738,  24,  29,  14,   0,   7,   1,  55,  15,   8,
   3, 106, 220,  27, 322, 204,1010,1007,1005, 373,
   6,   5,   2,1004,1003,1002,  40,1000, 999, 997,
 995, 993, 989,  17,  13,  12,  19,  11,  35, 123,
 986,  52, 961, 139, 976, 974,  57, 972, 214,  64,
  25,  70, 968, 967, 966,  38,  42, 108,  91,  32,
  97, 266,  60, 964, 963,1266, 962, 955,  47,  44,
  31,  77,  48, 628, 135, 815,1368,1443, 953, 952,
 948, 943, 941,  45,  65,  66,  39, 383, 940, 937,
2581, 936,1427, 502, 933, 931, 924, 922, 600, 418,
 871, 921, 918, 876, 267, 913,  37, 911, 906,  30,
 897,  67, 896,  61, 892, 891, 889, 887,  56,  62,
 883, 877 };
short yyr1[]={

   0,   1,   1,   1,   1,   5,   5,   5,   6,  10,
  12,  12,   8,   8,   8,  11,  11,  11,  11,  16,
  16,  17,  17,  17,  17,  17,  21,  21,  21,  21,
  22,  22,  23,  23,  14,  14,  15,  24,  24,  24,
  24,  24,  25,  25,  25,  26,  26,  26,  26,  27,
  27,  28,  28,  28,  28,  30,  30,  30,  30,  31,
  31,  32,  32,  13,  13,  13,  13,  34,  34,  34,
  34,  35,  35,  35,  35,  35,  35,  35,  35,  35,
  35,  35,  35,  35,  37,  37,  37,  39,  39,  45,
  45,  41,  41,  47,  47,  49,  49,  50,  50,  50,
  50,  50,  50,  50,  50,  50,  50,  56,  56,  56,
  57,  57,  57,  57,  57,  53,  53,  53,  43,  58,
  58,  60,  60,  60,  42,  42,  42,  63,  63,  64,
  64,  35,  65,  65,  65,  66,  66,  35,  35,  35,
  35,  35,  35,  67,  67,  69,  69,  70,  70,  71,
  71,  68,  68,  72,  72,  72,  73,  74,  74,  46,
  46,  75,  75,  76,  76,  76,  76,  62,  62,  62,
  55,  48,  48,  77,  77,   4,   4,   4,   4,   4,
   4,  79,  79,  80,  80,  80,  80,  80,  38,  38,
  81,  81,  81,  81,  51,  51,  54,  54,  40,  40,
  59,  59,  82,  82,  82,  82,  82,  82,  82,  82,
  82,  82,  82,  82,  82,  78,  78,  84,  84,  84,
  84,  85,  85,  86,  87,  87,  87,  87,  87,  87,
  87,  87,  88,  88,  89,  89,  61,  61,  91,  91,
  92,  92,  92,  93,  36,  36,  36,  36,  94,  94,
  94,  97,  97,  97,  97,  97,  98,  98,  98,  98,
  98,  95,  95, 106, 106, 107, 107, 108,   3,   3,
 110, 110, 111, 111,  99,  96,  96,  96, 104, 104,
 112, 112, 102, 102, 102, 102, 102, 102, 102, 102,
 102, 102, 113, 113, 100, 100, 115, 115, 105, 105,
 105, 116, 116, 116, 116, 116, 116, 116, 116, 116,
 116, 116, 116, 116, 119, 119, 120, 120, 118, 118,
 122, 122, 123, 123, 121, 121, 124,   2,   2, 125,
 125, 125, 109, 109, 126, 126, 128, 128, 129, 129,
 129, 129, 129, 131, 131, 131, 131, 131, 130, 130,
 130, 132, 132, 132, 132, 137, 137, 136, 136, 138,
 138, 138, 138, 138, 138, 138, 138, 138, 138, 138,
 138, 138, 138, 138, 138, 138, 138, 138, 138, 138,
 140, 140, 141, 141, 144, 134, 134, 145, 145, 146,
 147, 147, 147, 148, 148, 149, 135, 135, 150, 150,
 151, 151, 151, 139, 139, 152, 152, 153, 153, 127,
 127, 154, 154, 154, 155, 156, 142, 142, 142, 142,
 142, 142, 142, 157, 157, 158, 158, 158, 117, 117,
 117, 117,  83,  83,  44,  44,  44,  44,  20,  20,
  29,  29,  29,  29,  29,  29,  18,  18,  18,  33,
  33,  19,  19,  19, 101, 101, 101, 160, 160, 103,
 103, 159, 159, 159, 159, 161, 161, 143, 143, 143,
  52,  52, 114, 114, 114,  90,  90, 133, 133,   7,
   9,   9 };
short yyr2[]={

   0,   3,   2,   2,   1,   4,   7,   2,   0,   1,
   1,   1,   1,   2,   4,   0,   2,   3,   4,   3,
   1,   1,   1,   4,   4,   2,   0,   1,   1,   2,
   3,   1,   1,   1,   3,   1,   0,   3,   5,   6,
   4,   2,   0,   4,   3,   0,   1,   1,   2,   3,
   1,   1,   1,   4,   4,   0,   1,   1,   2,   3,
   1,   1,   1,   0,   1,   1,   2,   3,   3,   1,
   1,   4,   6,   2,   5,   7,   2,   4,   2,   5,
   7,   2,   2,   2,   2,   1,   1,   3,   1,   3,
   1,   3,   1,   4,   1,   3,   1,   4,   3,   3,
   3,   1,   1,   1,   4,   3,   1,   3,   3,   2,
   2,   2,   2,   2,   3,   2,   1,   1,   1,   3,
   1,   3,   3,   4,   0,   2,   4,   0,   1,   3,
   1,   4,   3,   1,   1,   2,   1,   4,   3,   4,
   2,   2,   2,   3,   1,   3,   1,   0,   1,   3,
   1,   0,   2,   3,   1,   0,   3,   0,   2,   4,
   1,   3,   1,   3,   3,   3,   1,   4,   3,   1,
   3,   2,   1,   3,   1,   2,   1,   3,   3,   1,
   3,   3,   3,   3,   3,   3,   3,   1,   1,   1,
   1,   3,   3,   1,   1,   1,   2,   1,   2,   1,
   1,   1,   1,   2,   3,   3,   3,   3,   3,   3,
   3,   5,   3,   2,   1,   3,   3,   3,   3,   3,
   3,   3,   1,   3,   3,   2,   3,   2,   3,   2,
   3,   3,   1,   0,   3,   1,   3,   1,   3,   3,
   0,   2,   2,   2,   1,   2,   4,   2,   1,   1,
   1,   3,   3,   3,   3,   3,   4,   4,   4,   2,
   2,   2,   1,   2,   1,   2,   1,   4,   0,   2,
   1,   1,   3,   1,   3,   1,   1,   1,   1,   1,
   1,   1,   2,   2,   3,   4,   3,   4,   3,   4,
   3,   4,   1,   1,   1,   1,   2,   2,   1,   1,
   1,   3,   1,   4,   1,   1,   1,   3,   3,   3,
   3,   2,   3,   5,   3,   3,   3,   1,   0,   1,
   3,   1,   3,   1,   3,   1,   3,   1,   1,   3,
   3,   1,   1,   1,   1,   1,   1,   1,   4,   3,
   2,   4,   3,   4,   3,   2,   4,   3,   6,   4,
   1,   4,   4,   6,   4,   2,   1,   2,   1,   1,
   3,   2,   1,   1,   1,   4,   4,   1,   1,   1,
   1,   3,   3,   3,   5,   1,   3,   4,   4,   4,
   3,   3,   3,   1,   3,   1,   2,   3,   1,   3,
   1,   2,   1,   2,   1,   4,   2,   1,   3,   1,
   3,   2,   1,   0,   1,   3,   1,   1,   3,   3,
   3,   0,   2,   2,   2,   3,   1,   1,   3,   3,
   4,   2,   5,   3,   1,   3,   1,   2,   1,   2,
   2,   3,   2,   1,   1,   1,   1,   1,   1,   1,
   1,   3,   3,   3,   3,   3,   1,   3,   1,   1,
   3,   1,   3,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   3,   1,   1,   1,   1,   1,   3,   1,
   1,   3,   1,   3,   1,   1,   1,   1,   1,   1,
   1,   1 };
short yychk[]={

-1000,  -1, 257, 258, 259, 256,  -2,-125, 256,-126,
-109,-129,-130,-128,  45, 260, 277,-136,-131,-132,
-138,  92, 268, 264, 281, -18, 126, 296,  95,-117,
 -19, 284, 285, 286, 282,  40, 295,  91, 292, -29,
 294, -33, -44, 290, 288, 304, 305, 306,  -4,  40,
 -40, -79, -20, -44, 296, 294, 290,  -5,  -6, 302,
  -3, 267, 297, 280,-133,-161,-114,  45,-143, 293,
  96, -52, 291,-160, 289,  43,-159, 287,  33,  46,
-133,-130,-132,  -2, 123,-138, 123,-137,-105, 284,
 -29,-116,  40,-117, -19, 285, 286,  95,  91, 126,
 -91, 123,  -2,-127, 123,  64,-138, 123,  -2,-140,
-141,-130,-143,-114,  41, -83, 287,  43,  45,  33,
  46, 291, 289, 293,-144,  44, -44,-142,  93,  -2,
-140,  41, -40, -78, -80, -79, -59, -82, -20, -44,
  40,  91,  95,  92, 297,  -7, 256, -10, 256, 290,
 -91, -77,  -4, -38,  40, -40, -81, -44, -54, 256,
 -82,-127,  45,-130,-132, -44, 292, 290, 294,  45,
-130,-132, 261,-135,-150,-151,-125, 268,-139,-152,
-153, -29, -18,  40, 300,-105,  64,-111, -99,-119,
-121, 287,  43,  45,  33,  46, 289, 293, -96, -29,
-110,-124, 284,-112, -44,-100,-102,-115,-116,-117,
 123,-120,-110, -99,-111,  45,-105, 269, -92, -93,
 265, 269,-154,-155,-138,-139,  41,  44,  41,  44,
  41, 124,  44,-133,-109,-126,-109,  41,  44,  41,
  41,  41,  41,  41,  41,  41,  41,  61,  93,  44,
 124, 298,  41,  44,  41,  44,  41,  44,  41, 300,
 -81, -40, -83, -78, -84, -85, -86, -44, -38,  93,
 -40, -44, -38,  -8, -13, -14,  59, -34, -24, -35,
 -36, 303, 263, 262, 274, 307, 273, 278, 279, 275,
 -87, -94, -96, 270, 271, 272, -61, -97, -98, -99,
 -29, 284,-100,-102,  40, -11,  40, 301,  41, -40,
 -78, -44, 300, 300, -59,-130,-132,  96,  96,  96,
  96,-130,-132, 123,  -9, 125, 256,  59, 299, -91,
 125,  44,  61,  45, 291,  -2,-105,  41,  41,  41,
  44,  41, 124,  44,-113, 256,-115,-105, 297,  43,
-114,  96,  44,-114,  61,-114,-114,-105,-105,-118,
-122,-123, -18, -29,  93,  44,  -2,  -9,  59, -36,
  -9,  59,  -2,  -2,  -9,  59,-156, 296,  -9,  59,
 125,  -2,  -2,  -2,-144, -44,  41,  41,  41,  -2,
  -2,-157,-158,  -2, 268,  -2, -79, -40, -79, -40,
 -40, -79,  41,  41,  44,  41,  44,  41,  41,  44,
  41,  44,  41, 124,  44, 297,  93,  -9, -15,  59,
  59, -12, 305, 256, 290, 286, -37, 256, 290, -40,
  -4, 256, -40,  -4, 256, 284, 256, -65, -66, 256,
 -29,  40, -67, 256,  -4, -40, -69, 256,  -4, -40,
  40, 256, -95, 297,-106, 256,  61,-107,-108, 124,
 -95, -88, 256, 284, -88, 256, -88, 256, 297,  44,
-105,-103,  43,-105,  45,-159,  96,-101,  43,  45,
-159,-101,-101, -97, -98, -99, -29, 267,  41, -16,
 -17, -18, -19, -20, 302,  40, 294, 290, -38,  41,
  44,  41,  44, -38, -38,-134,-145,-146,-110,-151,
  -2,-153,  -2,-110,-110,-124, -44, -38, 284,-113,
  45,-110,-113,  45,-110,-113,  45,-113,  45, 125,
  44,  61,-110, 266,  61,  41, 298,  44, 299, -91,
 -38, -40, -81, -40, -81, -38, -38, -86, -44, -38,
 -15, -24, -35, -36, -25, 306, 304,  40, -12,  61,
 -44,  61, 301,  61, 301, 297,  44, 286, -68, 124,
 301,  -3, 301, -70, -71, -38, -38,  -3,  -2,-108,
-109, -89, -90,-101, -52,  96, -89, -89, -46, 256,
 283, -75,  -4, -76,  40, -40, -55, -54, -51, -29,
 -96, -29,-104, 284, -29,-112, -96, -96, -96,  41,
  41,  41, 123,  41,  44,  40, -12,  -9,  59,-147,
-148, 300, 256,-149, 124,  41,-113,-113,-113,-113,
-123,-110,  -2,  -2,  -2,-158,  -2,  41, -13, -12,
  40, -26,  44, -27, -28, -29, 290, 306, -25, -38,
 -41, -47, 283, -49,  -4, -50,  40, -40,  33, -54,
 -55, -56, -57, -33, 256, -37, 256, -43, -47, -37,
 -46, -66,  -3, -72, -73, -74, -40, -40,  41,  44,
 -95,  61,  44, -48, -44, 301, -62, -40, 283,  -4,
 -55, -79, 300, 300, 300,-105,-105,-105,  -8,  41,
 -17, 298, -21,  44, -22, -23, -18, -19,-146,  -3,
-149,  -2,-109, -25, -26,  41,  44,  40, -12, 269,
 -42, 124, 276, -48, 301, -52,  33, -55,  96,  40,
 -51, -54, -40, -52, -52,  33, -59, -55, -55, -59,
  33, 123,  61, -42,  61,  44, 300, -44, -38,  -2,
 -90,  46, -44, -76, -40,  41, -48, 301, -76, -76,
 -76,  -9,  41,  41,  44, 300,  41, -28, 298, -30,
  44, -31, -32, -29, -33,  40, -25, -39, -45, -29,
 -47, -20,  40,  46, -50, -40,  40, -53,  33, -51,
 -55, -59, -40, -52, -53, -53, -59, -59, -58, 125,
 -60, -61, -29, -41, -43, -73, -74, -75,  46, -38,
 -23,  -2,  41,  41,  44,  44, 297, -63, -64, -20,
 -49, -51, -53, 125,  44, 297, -42, -42, -77, -32,
 -45, -46,  41,  44, -60, -62, -38,  33, -20, -38 };
short yydef[]={

   0,  -2,   0,   0,   8,   4, 268, 327, 328, 332,
 331, 334, 335, 333,   0,   0,   0, 350, 336, 337,
 358,   0,   0,   0,   0, 359,   0, 362, 363, 364,
 428, 367, 368, 369, 370,   0, 375,   0, 446, 448,
 451, 453, 440, 449, 434, 435, 436, 437,   2,   0,
 176, 179, 199,   0,   0, 438, 439,   3,   0,   0,
   1,   0,   0,   0,   0, 477, 478, 465, 466, 472,
   0, 474, 467, 469, 470, 457, 458, 461, 463, 464,
   0, 340, 345,   0,   0, 357, 403,   0, 356, 298,
 299, 300,   0, 302, 428, 304, 305, 306,   0,   0,
   0, 240,   0,   0, 411,   0, 361, 403,   0,   0,
   0, 335,   0,   0, 429,   0, 461, 457,   0, 463,
 464, 467, 470, 472, 383, 433, 440,   0, 430, 416,
 417, 175,   0,   0,   0, 187, 198, 200, 201, 202,
   0,   0, 214,   0,   0,  63, 479,  15,   7,   9,
 269, 329,   0, 174,   0,  -2, 188, 202, 190, 193,
 197, 330,   0, 339, 344,   0,   0,   0,   0,   0,
 342, 347,   0,   0, 397, 399, 402,   0,   0, 404,
 406,  -2,   0,   0,   0, 355,   0, 271, 270,   0,
   0,   0,   0,   0,   0,   0,   0,   0, 273, 275,
   0, 325, 276, 277, 440, 280, 281, 294, 295, 302,
 318,   0, 317, 270, 271,   0, 311,   0,   0,   0,
   0,   0,   0,   0, 360,   0, 371,   0, 372,   0,
 373,   0,   0,   0,   0, 332,   0, 431, 432, 441,
 442, 443, 444, 445, 447, 450, 452,   0, 376,   0,
   0, 421, 177,   0, 178,   0, 180,   0, 203,   0,
   0,   0,   0,   0,   0,   0, 222, 202,   0, 213,
 189, 181, 182,   0,  12,  36,  64,  65,  35,  69,
  70,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 244,   0,   0, 233, 233, 233,   0, 248, 249, 250,
  -2, 276, 280, 281,   0,   0,   0,   0,  -2,   0,
   0, 202,   0,   0, 196, 338, 343, 462, 468, 471,
 473, 341, 346,   0, 349, 480, 481, 396,   0, 401,
 366,   0,   0,   0,   0, 351, 301, 307, 308, 309,
   0, 312,   0,   0, 282, 283, 292, 293,   0,   0,
   0,   0,   0,   0,   0,   0,   0, 296, 297,   0,
 319, 321,   0,  -2, 310,   0, 352, 238, 241, 243,
 239, 242,   0, 354, 409, 412, 414,   0, 410, 413,
 365, 381, 380,   0, 382,   0, 377, 378, 379, 384,
 381, 418, 424, 426,   0, 419, 186, 216, 183, 215,
 184, 185, 204, 205,   0, 206,   0, 207, 208,   0,
 209,   0, 210,   0,   0,   0, 212,   5,  13,  36,
  66,  42,   0,  41,  10,  11,   0,  -2,  85,  -2,
   0,  78, 176,   0,  81,  82,  83,   0, 133, 134,
 136,   0, 151, 140,   0,  -2, 268, 141,   0,  -2,
 147, 142, 245,   0, 268, 262,   0, 264, 266,   0,
 247,   0, 225, 232,   0, 227,   0, 229,   0,   0,
 260,   0,   0, 259, 459, 460,   0,   0, 454, 455,
 456,   0,   0,   0,   0, 270, 275,   0,  16,   0,
  20,  21,  22,   0,   0,   0,  -2,  -2, 173,  -2,
   0,  -2,   0, 192, 191,   0, 385, 388,   0, 398,
 400, 405, 408, 314,   0, 324,   0, 272, 274, 284,
   0, 315, 286,   0, 326, 288,   0, 290,   0, 303,
   0,   0, 316,   0,   0, 374, 420,   0,   0, 427,
 217, 216, 218, 215, 219, 220,   0, 221,   0, 223,
  63,  34,  67,  68,  37,   0,   0,  45,  42,   0,
  84,   0,   0,   0,   0,   0,   0, 135, 268,  -2,
   0, 138,   0,   0, 148, 150,   0, 261, 263, 265,
   0, 224, 235, 475, 476,   0, 226, 228, 230, 231,
   0, 160,   0, 162,   0,  -2,   0, 194, 166, 236,
 254, 275, 255, 274, 278, 279, 253, 251, 252,   0,
   0, 308,  63,  17,   0,  26,  25, 348, 386, 268,
 390,   0, 392, 394,   0, 313, 285, 287, 289, 291,
 320, 322, 353, 415, 422, 423, 425, 211,  14,  42,
  45,   0,  46,  47,  50,  51,  52,   0,  40,  71,
 124,  92,   0,  94,   0,  96,   0,  -2,   0,   0,
   0, 102, 103,   0, 106,  77,  86, 124, 118,   0,
 131, 132, 137, 152, 154,   0, 143, 145, 139,   0,
 246,   0,   0,   0, 172,   0,   0, 176,   0,   0,
 169,  -2,   0,   0,   0, 256, 257, 258,   0,  18,
  19,   0,   0,  27,  28,  31,  32,  33, 387, 389,
 393, 391,   0,  38,   0,  44,  48,  55,  42,   0,
  74,   0,   0,   0,   0,   0,   0, 110,   0,   0,
   0, 194, 195,   0,   0,   0, 109, 111, 112, 113,
   0,   0,   0,  79,   0, 157, 157, 158, 149, 267,
 234,   0, 171, 161, 195, 170,   0,   0, 165, 163,
 164,   6,  23,  24,  29,   0,  43,  49,   0,   0,
  56,  57,  60,  61,  62,   0,  39,  72,  88,  90,
  91, 125, 127,   0,  95, 101,   0,  99,   0, 116,
 117, 107, 176,   0,  98, 100, 108, 114,   0, 105,
 120,   0, 237, 124, 124, 153, 156, 159,   0, 168,
  30, 395,  53,  54,  58,   0,   0,   0, 128, 130,
  93, 115,  97, 104,   0,   0,  75,  80, 167,  59,
  87,  89, 126,   0, 119, 121, 122,   0, 129, 123 };
#define YYFLAG   -1000
#define YYERROR  goto yyerrlab
#define YYACCEPT return(0)
#define YYABORT  return(1)

/*      parser for yacc output  */

#ifdef YYDEBUG
int yydebug     = 0;     /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar      = -1;    /* current input token number */
int yynerrs     = 0;     /* number of errors */
short yyerrflag = 0;     /* error recovery flag */

int yyparse() {
    short yys[YYMAXDEPTH];
    short yyj, yym;
    register YYSTYPE *yypvt;
    register short yystate, *yyps, yyn;
    register YYSTYPE *yypv;
    register short *yyxi;

    yystate   = 0;
    yychar    = -1;
    yynerrs   = 0;
    yyerrflag = 0;
    yyps      = &yys[-1];
    yypv      = &yyv[-1];

yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
    if (yydebug)
        printf("state %d, char 0%o\n", yystate, yychar);
#endif
    if(++yyps>&yys[YYMAXDEPTH]) {
        yyerror("yacc stack overflow");
        return(1);
    }
    *yyps = yystate;
    ++yypv;
#ifdef UNION
    yyunion(yypv, &yyval);
#else
    *yypv = yyval;
#endif

yynewstate:

    yyn = yypact[yystate];

    if (yyn<=YYFLAG)
        goto yydefault; /* simple state */

    if (yychar<0)
        if ((yychar=yylex())<0)
            yychar=0;
    if ((yyn+=yychar)<0 || yyn>=YYLAST)
        goto yydefault;

    if (yychk[yyn=yyact[yyn]]==yychar) {
        /* valid shift */
        yychar = -1;
#ifdef UNION
        yyunion(&yyval, &yylval);
#else
        yyval = yylval;
#endif
        yystate = yyn;
        if (yyerrflag>0)
            --yyerrflag;
        goto yystack;

    }

yydefault:

    /* default state action */

    if ((yyn=yydef[yystate])== -2) {
        if (yychar<0)
            if ((yychar=yylex())<0)
                yychar = 0;
        /* look through exception table */

        for (yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2)
            ; /* VOID */

        for (yyxi+=2; *yyxi >= 0; yyxi+=2) {
            if (*yyxi==yychar)
                break;
        }
        if ((yyn=yyxi[1])<0)
            return(0);   /* accept */
    }

    if (yyn==0) {
        /* error */
        /* error ... attempt to resume parsing */

        switch (yyerrflag) {
            case 0: /* brand new error */
                    yyerror( "syntax error" );

yyerrlab:           ++yynerrs;

            case 1:
            case 2: /* incompletely recovered error ... try again */

                    yyerrflag = 3;

                    /* find a state where "error" is a legal shift action */

                    while (yyps>=yys) {
                        yyn = yypact[*yyps] + YYERRCODE;
                        if (yyn>=0 && yyn<YYLAST
                                   && yychk[yyact[yyn]]==YYERRCODE) {
                            yystate = yyact[yyn];
                            /* simulate a shift of "error" */
                            goto yystack;
                        }
                        yyn = yypact[*yyps];

                        /* the current yyps has no shift on "error",
                           pop stack */

#ifdef YYDEBUG
                        if (yydebug)
                            printf("error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1]);
#endif

                        --yyps;
                        --yypv;
                    }

                    /* there is no state on the stack with an error shift
                       ... abort */

yyabort:            return(1);


            case 3: /* no shift yet; clobber input char */
#ifdef YYDEBUG
                    if (yydebug)
                        printf("error recovery discards char %d\n", yychar);
#endif

                    if (yychar==0)
                        goto yyabort; /* don't discard EOF, quit */
                    yychar = -1;
                    goto yynewstate;   /* try again in the same state */
        }
    }

    /* reduction by production yyn */

#ifdef YYDEBUG
    if (yydebug)
        printf("reduce %d\n",yyn);
#endif
    yyps -= yyr2[yyn];
    yypvt = yypv;
    yypv -= yyr2[yyn];
#ifdef UNION
    yyunion(&yyval, &yypv[1]);
#else
    yyval = yypv[1];
#endif
    yym=yyn;
    /* consult goto table to find next state */
    yyn = yyr1[yyn];
    yyj = yypgo[yyn] + *yyps + 1;
    if (yyj>=YYLAST || yychk[yystate=yyact[yyj]]!= -yyn)
        yystate = yyact[yypgo[yyn]];
    switch(yym) {
        
case 1:
# line 105
{inputExpr = letrec(yypvt[-0],yypvt[-1]); sp-=2;} break;
case 2:
# line 106
{inputContext = yypvt[-0];	    sp-=1;} break;
case 3:
# line 107
{valDefns  = yypvt[-0];	    sp-=1;} break;
case 4:
# line 108
{syntaxError("input");} break;
case 5:
# line 121
{
					 setExportList(singleton(ap(MODULEENT,mkCon(module(currentModule).text))));
					 yyval = gc3(yypvt[-1]);
					} break;
case 6:
# line 126
{setExportList(yypvt[-4]);   yyval = gc7(yypvt[-1]);} break;
case 7:
# line 127
{syntaxError("module definition");} break;
case 8:
# line 133
{startModule(conMain); 
					 yyval = gc0(NIL);} break;
case 9:
# line 136
{startModule(yypvt[-0]); yyval = gc1(NIL);} break;
case 10:
# line 138
{yyval = yypvt[-0];} break;
case 11:
# line 139
{ extern String scriptFile;
					  String modName = findPathname(scriptFile,textToStr(textOf(yypvt[-0])));
					  if (modName) { /* fillin pathname if known */
					      yyval = mkStr(findText(modName));
					  } else {
					      yyval = yypvt[-0];
					  }
					} break;
case 12:
# line 148
{yyval = yypvt[-0];} break;
case 13:
# line 149
{yyval = gc2(NIL);} break;
case 14:
# line 150
{yyval = gc4(yypvt[-0]);} break;
case 15:
# line 155
{yyval = gc0(exportSelf());} break;
case 16:
# line 156
{yyval = gc2(NIL);} break;
case 17:
# line 157
{yyval = gc3(yypvt[-1]);} break;
case 18:
# line 158
{yyval = gc4(yypvt[-2]);} break;
case 19:
# line 160
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 20:
# line 161
{yyval = gc1(singleton(yypvt[-0]));} break;
case 21:
# line 166
{yyval = yypvt[-0];} break;
case 22:
# line 167
{yyval = yypvt[-0];} break;
case 23:
# line 168
{yyval = gc4(pair(yypvt[-3],DOTDOT));} break;
case 24:
# line 169
{yyval = gc4(pair(yypvt[-3],yypvt[-1]));} break;
case 25:
# line 170
{yyval = gc2(ap(MODULEENT,yypvt[-0]));} break;
case 26:
# line 172
{yyval = gc0(NIL);} break;
case 27:
# line 173
{yyval = gc1(NIL);} break;
case 28:
# line 174
{yyval = yypvt[-0];} break;
case 29:
# line 175
{yyval = gc2(yypvt[-1]);} break;
case 30:
# line 177
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 31:
# line 178
{yyval = gc1(singleton(yypvt[-0]));} break;
case 32:
# line 180
{yyval = yypvt[-0];} break;
case 33:
# line 181
{yyval = yypvt[-0];} break;
case 34:
# line 186
{imps = cons(yypvt[-0],imps); yyval=gc3(NIL);} break;
case 35:
# line 187
{imps = singleton(yypvt[-0]); yyval=gc1(NIL);} break;
case 36:
# line 189
{if (chase(imps)) {
					     clearStack();
					     onto(imps);
					     done();
					     closeAnyInput();
					     return 0;
					 }
					 yyval = gc0(NIL);
					} break;
case 37:
# line 200
{addQualImport(yypvt[-1],yypvt[-1]);
					 addUnqualImport(yypvt[-1],yypvt[-0]);
					 yyval = gc3(yypvt[-1]);} break;
case 38:
# line 204
{addQualImport(yypvt[-3],yypvt[-1]);
					 addUnqualImport(yypvt[-3],yypvt[-0]);
					 yyval = gc5(yypvt[-3]);} break;
case 39:
# line 208
{addQualImport(yypvt[-3],yypvt[-1]);
					 yyval = gc6(yypvt[-3]);} break;
case 40:
# line 211
{addQualImport(yypvt[-1],yypvt[-1]);
					 yyval = gc4(yypvt[-1]);} break;
case 41:
# line 213
{syntaxError("import declaration");} break;
case 42:
# line 215
{yyval = gc0(DOTDOT);} break;
case 43:
# line 216
{yyval = gc4(ap(HIDDEN,yypvt[-1]));} break;
case 44:
# line 217
{yyval = gc3(yypvt[-1]);} break;
case 45:
# line 219
{yyval = gc0(NIL);} break;
case 46:
# line 220
{yyval = gc1(NIL);} break;
case 47:
# line 221
{yyval = yypvt[-0];} break;
case 48:
# line 222
{yyval = gc2(yypvt[-1]);} break;
case 49:
# line 224
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 50:
# line 225
{yyval = gc1(singleton(yypvt[-0]));} break;
case 51:
# line 227
{yyval = yypvt[-0];} break;
case 52:
# line 228
{yyval = yypvt[-0];} break;
case 53:
# line 229
{yyval = gc4(pair(yypvt[-3],DOTDOT));} break;
case 54:
# line 230
{yyval = gc4(pair(yypvt[-3],yypvt[-1]));} break;
case 55:
# line 232
{yyval = gc0(NIL);} break;
case 56:
# line 233
{yyval = gc1(NIL);} break;
case 57:
# line 234
{yyval = yypvt[-0];} break;
case 58:
# line 235
{yyval = gc2(yypvt[-1]);} break;
case 59:
# line 237
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 60:
# line 238
{yyval = gc1(singleton(yypvt[-0]));} break;
case 61:
# line 240
{yyval = yypvt[-0];} break;
case 62:
# line 241
{yyval = yypvt[-0];} break;
case 63:
# line 246
{yyval = gc0(NIL);} break;
case 64:
# line 247
{yyval = gc1(NIL);} break;
case 65:
# line 248
{yyval = yypvt[-0];} break;
case 66:
# line 249
{yyval = gc2(yypvt[-1]);} break;
case 67:
# line 251
{yyval = gc2(yypvt[-2]);} break;
case 68:
# line 252
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 69:
# line 253
{yyval = gc0(NIL);} break;
case 70:
# line 254
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 71:
# line 259
{defTycon(4,yypvt[-1],yypvt[-2],yypvt[-0],SYNONYM);} break;
case 72:
# line 261
{defTycon(6,yypvt[-3],yypvt[-4],
						    ap(yypvt[-2],yypvt[-0]),RESTRICTSYN);} break;
case 73:
# line 263
{syntaxError("type definition");} break;
case 74:
# line 265
{defTycon(5,yypvt[-2],checkTyLhs(yypvt[-3]),
						    ap(rev(yypvt[-1]),yypvt[-0]),DATATYPE);} break;
case 75:
# line 268
{defTycon(7,yypvt[-2],yypvt[-3],
						  ap(qualify(yypvt[-5],rev(yypvt[-1])),
						     yypvt[-0]),DATATYPE);} break;
case 76:
# line 271
{defTycon(2,yypvt[-1],checkTyLhs(yypvt[-0]),
						    ap(NIL,NIL),DATATYPE);} break;
case 77:
# line 273
{defTycon(4,yypvt[-3],yypvt[-0],
						  ap(qualify(yypvt[-2],NIL),
						     NIL),DATATYPE);} break;
case 78:
# line 276
{syntaxError("data definition");} break;
case 79:
# line 278
{defTycon(5,yypvt[-2],checkTyLhs(yypvt[-3]),
						    ap(yypvt[-1],yypvt[-0]),NEWTYPE);} break;
case 80:
# line 281
{defTycon(7,yypvt[-2],yypvt[-3],
						  ap(qualify(yypvt[-5],yypvt[-1]),
						     yypvt[-0]),NEWTYPE);} break;
case 81:
# line 284
{syntaxError("newtype definition");} break;
case 82:
# line 285
{if (isInt(yypvt[-0])) {
					     needPrims(intOf(yypvt[-0]));
					 } else {
					     syntaxError("needprims decl");
					 }
					 sp-=2;} break;
case 83:
# line 291
{syntaxError("needprims decl");} break;
case 84:
# line 293
{yyval = gc2(ap(yypvt[-1],yypvt[-0]));} break;
case 85:
# line 294
{yyval = yypvt[-0];} break;
case 86:
# line 295
{syntaxError("type defn lhs");} break;
case 87:
# line 297
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 88:
# line 298
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 89:
# line 300
{yyval = gc3(sigdecl(yypvt[-1],singleton(yypvt[-2]),
									yypvt[-0]));} break;
case 90:
# line 302
{yyval = yypvt[-0];} break;
case 91:
# line 304
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 92:
# line 305
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 93:
# line 307
{yyval = gc4(ap(POLYTYPE,
						     pair(rev(yypvt[-2]),yypvt[-0])));} break;
case 94:
# line 309
{yyval = yypvt[-0];} break;
case 95:
# line 311
{yyval = gc3(qualify(yypvt[-2],yypvt[-0]));} break;
case 96:
# line 312
{yyval = yypvt[-0];} break;
case 97:
# line 314
{yyval = gc4(ap(ap(yypvt[-1],bang(yypvt[-2])),yypvt[-0]));} break;
case 98:
# line 315
{yyval = gc3(ap(ap(yypvt[-1],yypvt[-2]),yypvt[-0]));} break;
case 99:
# line 316
{yyval = gc3(ap(ap(yypvt[-1],yypvt[-2]),yypvt[-0]));} break;
case 100:
# line 317
{yyval = gc3(ap(ap(yypvt[-1],yypvt[-2]),yypvt[-0]));} break;
case 101:
# line 318
{yyval = yypvt[-0];} break;
case 102:
# line 319
{yyval = yypvt[-0];} break;
case 103:
# line 320
{yyval = yypvt[-0];} break;
case 104:
# line 321
{yyval = gc4(ap(LABC,pair(yypvt[-3],rev(yypvt[-1]))));} break;
case 105:
# line 322
{yyval = gc3(ap(LABC,pair(yypvt[-2],NIL)));} break;
case 106:
# line 323
{syntaxError("data type definition");} break;
case 107:
# line 325
{yyval = gc3(ap(yypvt[-2],bang(yypvt[-0])));} break;
case 108:
# line 326
{yyval = gc3(ap(yypvt[-2],bang(yypvt[-0])));} break;
case 109:
# line 327
{yyval = gc2(ap(yypvt[-1],yypvt[-0]));} break;
case 110:
# line 329
{yyval = gc2(ap(yypvt[-1],yypvt[-0]));} break;
case 111:
# line 330
{yyval = gc2(ap(yypvt[-1],yypvt[-0]));} break;
case 112:
# line 331
{yyval = gc2(ap(yypvt[-1],yypvt[-0]));} break;
case 113:
# line 332
{yyval = gc2(ap(yypvt[-1],yypvt[-0]));} break;
case 114:
# line 333
{yyval = gc3(ap(yypvt[-2],bang(yypvt[-0])));} break;
case 115:
# line 335
{yyval = gc2(bang(yypvt[-0]));} break;
case 116:
# line 336
{yyval = yypvt[-0];} break;
case 117:
# line 337
{yyval = yypvt[-0];} break;
case 118:
# line 339
{yyval = gc1(singleton(yypvt[-0]));} break;
case 119:
# line 341
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 120:
# line 342
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 121:
# line 344
{yyval = gc3(pair(rev(yypvt[-2]),yypvt[-0]));} break;
case 122:
# line 345
{yyval = gc3(pair(rev(yypvt[-2]),yypvt[-0]));} break;
case 123:
# line 346
{yyval = gc4(pair(rev(yypvt[-3]),bang(yypvt[-0])));} break;
case 124:
# line 348
{yyval = gc0(NIL);} break;
case 125:
# line 349
{yyval = gc2(singleton(yypvt[-0]));} break;
case 126:
# line 350
{yyval = gc4(yypvt[-1]);} break;
case 127:
# line 352
{yyval = gc0(NIL);} break;
case 128:
# line 353
{yyval = gc1(rev(yypvt[-0]));} break;
case 129:
# line 355
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 130:
# line 356
{yyval = gc1(singleton(yypvt[-0]));} break;
case 131:
# line 361
{primDefn(yypvt[-3],yypvt[-2],yypvt[-0]); sp-=4;} break;
case 132:
# line 363
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 133:
# line 364
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 134:
# line 365
{syntaxError("primitive defn");} break;
case 135:
# line 367
{yyval = gc2(pair(yypvt[-1],yypvt[-0]));} break;
case 136:
# line 368
{yyval = yypvt[-0];} break;
case 137:
# line 373
{classDefn(intOf(yypvt[-3]),yypvt[-2],yypvt[-0],yypvt[-1]); sp-=4;} break;
case 138:
# line 374
{instDefn(intOf(yypvt[-2]),yypvt[-1],yypvt[-0]);  sp-=3;} break;
case 139:
# line 375
{defaultDefn(intOf(yypvt[-3]),yypvt[-1]);  sp-=4;} break;
case 140:
# line 376
{syntaxError("class declaration");} break;
case 141:
# line 377
{syntaxError("instance declaration");} break;
case 142:
# line 378
{syntaxError("default declaration");} break;
case 143:
# line 380
{yyval = gc3(pair(yypvt[-2],checkPred(yypvt[-0])));} break;
case 144:
# line 381
{yyval = gc1(pair(NIL,checkPred(yypvt[-0])));} break;
case 145:
# line 383
{yyval = gc3(pair(yypvt[-2],checkPred(yypvt[-0])));} break;
case 146:
# line 384
{yyval = gc1(pair(NIL,checkPred(yypvt[-0])));} break;
case 147:
# line 386
{yyval = gc0(NIL);} break;
case 148:
# line 387
{yyval = gc1(rev(yypvt[-0]));} break;
case 149:
# line 389
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 150:
# line 390
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 151:
# line 392
{yyval = gc0(NIL);} break;
case 152:
# line 393
{h98DoesntSupport(row,"dependent parameters");
					 yyval = gc2(rev(yypvt[-0]));} break;
case 153:
# line 396
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 154:
# line 397
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 156:
# line 400
{yyval = gc3(pair(rev(yypvt[-2]),rev(yypvt[-0])));} break;
case 157:
# line 402
{yyval = gc0(NIL);} break;
case 158:
# line 403
{yyval = gc2(cons(yypvt[-0],yypvt[-1]));} break;
case 159:
# line 408
{yyval = gc4(ap(POLYTYPE,
						     pair(rev(yypvt[-2]),yypvt[-0])));} break;
case 160:
# line 410
{yyval = yypvt[-0];} break;
case 161:
# line 412
{yyval = gc3(qualify(yypvt[-2],yypvt[-0]));} break;
case 162:
# line 413
{yyval = yypvt[-0];} break;
case 163:
# line 415
{yyval = gc3(fn(yypvt[-2],yypvt[-0]));} break;
case 164:
# line 416
{yyval = gc3(fn(yypvt[-2],yypvt[-0]));} break;
case 165:
# line 417
{yyval = gc3(fn(yypvt[-2],yypvt[-0]));} break;
case 166:
# line 418
{yyval = yypvt[-0];} break;
case 167:
# line 420
{yyval = gc4(ap(POLYTYPE,
						     pair(rev(yypvt[-2]),yypvt[-0])));} break;
case 168:
# line 422
{yyval = gc3(qualify(yypvt[-2],yypvt[-0]));} break;
case 169:
# line 423
{yyval = yypvt[-0];} break;
case 170:
# line 425
{yyval = gc3(yypvt[-1]);} break;
case 171:
# line 427
{yyval = gc2(cons(yypvt[-0],yypvt[-1]));} break;
case 172:
# line 428
{yyval = gc1(singleton(yypvt[-0]));} break;
case 173:
# line 430
{yyval = gc3(qualify(yypvt[-2],yypvt[-0]));} break;
case 174:
# line 431
{yyval = yypvt[-0];} break;
case 175:
# line 433
{yyval = gc2(NIL);} break;
case 176:
# line 434
{yyval = gc1(singleton(checkPred(yypvt[-0])));} break;
case 177:
# line 435
{yyval = gc3(singleton(checkPred(yypvt[-1])));} break;
case 178:
# line 436
{yyval = gc3(checkCtxt(rev(yypvt[-1])));} break;
case 179:
# line 438
{yyval = gc1(singleton(yypvt[-0]));} break;
case 180:
# line 439
{yyval = gc3(checkCtxt(rev(yypvt[-1])));} break;
case 181:
# line 441
{
#if TREX
					 yyval = gc3(ap(mkExt(textOf(yypvt[-0])),yypvt[-2]));
#else
					 noTREX("a type context");
#endif
					} break;
case 182:
# line 448
{
#if IPARAM
					 yyval = gc3(pair(mkIParam(yypvt[-2]),yypvt[-0]));
#else
					 noIP("a type context");
#endif
					} break;
case 183:
# line 456
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 184:
# line 457
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 185:
# line 458
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 186:
# line 459
{yyval = gc3(cons(yypvt[-0],cons(yypvt[-2],NIL)));} break;
case 187:
# line 460
{yyval = gc1(singleton(yypvt[-0]));} break;
case 188:
# line 464
{yyval = yypvt[-0];} break;
case 189:
# line 465
{yyval = yypvt[-0];} break;
case 190:
# line 467
{yyval = yypvt[-0];} break;
case 191:
# line 468
{yyval = gc3(fn(yypvt[-2],yypvt[-0]));} break;
case 192:
# line 469
{yyval = gc3(fn(yypvt[-2],yypvt[-0]));} break;
case 193:
# line 470
{syntaxError("type expression");} break;
case 194:
# line 472
{yyval = yypvt[-0];} break;
case 195:
# line 473
{yyval = yypvt[-0];} break;
case 196:
# line 475
{yyval = gc2(ap(yypvt[-1],yypvt[-0]));} break;
case 197:
# line 476
{yyval = yypvt[-0];} break;
case 198:
# line 478
{yyval = gc2(ap(yypvt[-1],yypvt[-0]));} break;
case 199:
# line 479
{yyval = yypvt[-0];} break;
case 200:
# line 481
{yyval = yypvt[-0];} break;
case 201:
# line 482
{yyval = yypvt[-0];} break;
case 202:
# line 484
{yyval = yypvt[-0];} break;
case 203:
# line 485
{yyval = gc2(typeUnit);} break;
case 204:
# line 486
{yyval = gc3(typeArrow);} break;
case 205:
# line 487
{yyval = gc3(yypvt[-1]);} break;
case 206:
# line 488
{yyval = gc3(yypvt[-1]);} break;
case 207:
# line 489
{yyval = gc3(yypvt[-1]);} break;
case 208:
# line 490
{yyval = gc3(buildTuple(yypvt[-1]));} break;
case 209:
# line 491
{yyval = gc3(buildTuple(yypvt[-1]));} break;
case 210:
# line 492
{
#if TREX
					 yyval = gc3(revOnto(yypvt[-1],typeNoRow));
#else
					 noTREX("a type");
#endif
					} break;
case 211:
# line 499
{
#if TREX
					 yyval = gc5(revOnto(yypvt[-3],yypvt[-1]));
#else
					 noTREX("a type");
#endif
					} break;
case 212:
# line 506
{yyval = gc3(ap(typeList,yypvt[-1]));} break;
case 213:
# line 507
{yyval = gc2(typeList);} break;
case 214:
# line 508
{h98DoesntSupport(row,"anonymous type variables");
					 yyval = gc1(inventVar());} break;
case 215:
# line 511
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 216:
# line 512
{yyval = gc3(cons(yypvt[-0],cons(yypvt[-2],NIL)));} break;
case 217:
# line 514
{yyval = gc3(cons(yypvt[-0],cons(yypvt[-2],NIL)));} break;
case 218:
# line 515
{yyval = gc3(cons(yypvt[-0],cons(yypvt[-2],NIL)));} break;
case 219:
# line 516
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 220:
# line 517
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 221:
# line 520
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 222:
# line 521
{yyval = gc1(singleton(yypvt[-0]));} break;
case 223:
# line 523
{h98DoesntSupport(row,"extensible records");
					 yyval = gc3(ap(mkExt(textOf(yypvt[-2])),yypvt[-0]));} break;
case 224:
# line 530
{yyval = gc3(fixdecl(yypvt[-2],yypvt[-0],NON_ASS,yypvt[-1]));} break;
case 225:
# line 531
{syntaxError("fixity decl");} break;
case 226:
# line 532
{yyval = gc3(fixdecl(yypvt[-2],yypvt[-0],LEFT_ASS,yypvt[-1]));} break;
case 227:
# line 533
{syntaxError("fixity decl");} break;
case 228:
# line 534
{yyval = gc3(fixdecl(yypvt[-2],yypvt[-0],RIGHT_ASS,yypvt[-1]));} break;
case 229:
# line 535
{syntaxError("fixity decl");} break;
case 230:
# line 536
{yyval = gc3(sigdecl(yypvt[-1],yypvt[-2],yypvt[-0]));} break;
case 231:
# line 537
{syntaxError("type signature");} break;
case 232:
# line 539
{yyval = gc1(checkPrec(yypvt[-0]));} break;
case 233:
# line 540
{yyval = gc0(mkInt(DEF_PREC));} break;
case 234:
# line 542
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 235:
# line 543
{yyval = gc1(singleton(yypvt[-0]));} break;
case 236:
# line 545
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 237:
# line 546
{yyval = gc1(singleton(yypvt[-0]));} break;
case 238:
# line 548
{yyval = gc3(yypvt[-1]);} break;
case 239:
# line 549
{yyval = gc3(yypvt[-1]);} break;
case 240:
# line 551
{yyval = gc0(NIL);} break;
case 241:
# line 552
{yyval = gc2(yypvt[-1]);} break;
case 242:
# line 553
{yyval = gc2(yypvt[-1]);} break;
case 243:
# line 555
{yyval = gc2(cons(yypvt[-0],yypvt[-1]));} break;
case 244:
# line 557
{yyval = yypvt[-0];} break;
case 245:
# line 558
{yyval = gc2(ap(FUNBIND,pair(yypvt[-1],yypvt[-0])));} break;
case 246:
# line 559
{yyval = gc4(ap(FUNBIND,
						     pair(yypvt[-3],ap(RSIGN,
								ap(yypvt[-0],yypvt[-1])))));} break;
case 247:
# line 562
{yyval = gc2(ap(PATBIND,pair(yypvt[-1],yypvt[-0])));} break;
case 248:
# line 564
{yyval = yypvt[-0];} break;
case 249:
# line 565
{yyval = yypvt[-0];} break;
case 250:
# line 566
{yyval = yypvt[-0];} break;
case 251:
# line 568
{yyval = gc3(ap2(yypvt[-1],yypvt[-2],yypvt[-0]));} break;
case 252:
# line 569
{yyval = gc3(ap2(yypvt[-1],yypvt[-2],yypvt[-0]));} break;
case 253:
# line 570
{yyval = gc3(ap2(yypvt[-1],yypvt[-2],yypvt[-0]));} break;
case 254:
# line 571
{yyval = gc3(ap2(yypvt[-1],yypvt[-2],yypvt[-0]));} break;
case 255:
# line 572
{yyval = gc3(ap2(varPlus,yypvt[-2],yypvt[-0]));} break;
case 256:
# line 574
{yyval = gc4(ap(yypvt[-2],yypvt[-0]));} break;
case 257:
# line 575
{yyval = gc4(ap(yypvt[-2],yypvt[-0]));} break;
case 258:
# line 576
{yyval = gc4(ap(yypvt[-2],yypvt[-0]));} break;
case 259:
# line 577
{yyval = gc2(ap(yypvt[-1],yypvt[-0]));} break;
case 260:
# line 578
{yyval = gc2(ap(yypvt[-1],yypvt[-0]));} break;
case 261:
# line 580
{yyval = gc2(letrec(yypvt[-0],yypvt[-1]));} break;
case 262:
# line 581
{syntaxError("declaration");} break;
case 263:
# line 583
{yyval = gc2(pair(yypvt[-1],yypvt[-0]));} break;
case 264:
# line 584
{yyval = gc1(grded(rev(yypvt[-0])));} break;
case 265:
# line 586
{yyval = gc2(cons(yypvt[-0],yypvt[-1]));} break;
case 266:
# line 587
{yyval = gc1(singleton(yypvt[-0]));} break;
case 267:
# line 589
{yyval = gc4(pair(yypvt[-1],pair(yypvt[-2],yypvt[-0])));} break;
case 268:
# line 591
{yyval = gc0(NIL);} break;
case 269:
# line 592
{yyval = gc2(yypvt[-0]);} break;
case 270:
# line 597
{yyval = yypvt[-0];} break;
case 271:
# line 598
{yyval = yypvt[-0];} break;
case 272:
# line 600
{yyval = gc3(ap(ESIGN,pair(yypvt[-2],yypvt[-0])));} break;
case 273:
# line 601
{yyval = yypvt[-0];} break;
case 274:
# line 603
{yyval = gc3(ap2(varPlus,yypvt[-2],yypvt[-0]));} break;
case 275:
# line 605
{yyval = yypvt[-0];} break;
case 276:
# line 606
{yyval = yypvt[-0];} break;
case 277:
# line 607
{yyval = yypvt[-0];} break;
case 278:
# line 609
{yyval = yypvt[-0];} break;
case 279:
# line 610
{yyval = yypvt[-0];} break;
case 280:
# line 612
{yyval = yypvt[-0];} break;
case 281:
# line 613
{yyval = gc1(ap(INFIX,yypvt[-0]));} break;
case 282:
# line 615
{yyval = gc2(ap(NEG,only(yypvt[-0])));} break;
case 283:
# line 616
{syntaxError("pattern");} break;
case 284:
# line 617
{yyval = gc3(ap(ap(yypvt[-1],only(yypvt[-2])),yypvt[-0]));} break;
case 285:
# line 618
{yyval = gc4(ap(NEG,ap2(yypvt[-2],only(yypvt[-3]),yypvt[-0])));} break;
case 286:
# line 619
{yyval = gc3(ap(ap(yypvt[-1],only(yypvt[-2])),yypvt[-0]));} break;
case 287:
# line 620
{yyval = gc4(ap(NEG,ap2(yypvt[-2],only(yypvt[-3]),yypvt[-0])));} break;
case 288:
# line 621
{yyval = gc3(ap(ap(yypvt[-1],only(yypvt[-2])),yypvt[-0]));} break;
case 289:
# line 622
{yyval = gc4(ap(NEG,ap2(yypvt[-2],only(yypvt[-3]),yypvt[-0])));} break;
case 290:
# line 623
{yyval = gc3(ap(ap(yypvt[-1],yypvt[-2]),yypvt[-0]));} break;
case 291:
# line 624
{yyval = gc4(ap(NEG,ap(ap(yypvt[-2],yypvt[-3]),yypvt[-0])));} break;
case 292:
# line 626
{yyval = yypvt[-0];} break;
case 293:
# line 627
{yyval = yypvt[-0];} break;
case 294:
# line 629
{yyval = yypvt[-0];} break;
case 295:
# line 630
{yyval = yypvt[-0];} break;
case 296:
# line 632
{yyval = gc2(ap(yypvt[-1],yypvt[-0]));} break;
case 297:
# line 633
{yyval = gc2(ap(yypvt[-1],yypvt[-0]));} break;
case 298:
# line 635
{yyval = yypvt[-0];} break;
case 299:
# line 636
{yyval = yypvt[-0];} break;
case 300:
# line 637
{yyval = yypvt[-0];} break;
case 301:
# line 639
{yyval = gc3(ap(ASPAT,pair(yypvt[-2],yypvt[-0])));} break;
case 302:
# line 640
{yyval = yypvt[-0];} break;
case 303:
# line 641
{yyval = gc4(ap(CONFLDS,pair(yypvt[-3],yypvt[-1])));} break;
case 304:
# line 642
{yyval = yypvt[-0];} break;
case 305:
# line 643
{yyval = yypvt[-0];} break;
case 306:
# line 644
{yyval = gc1(WILDCARD);} break;
case 307:
# line 645
{yyval = gc3(yypvt[-1]);} break;
case 308:
# line 646
{yyval = gc3(yypvt[-1]);} break;
case 309:
# line 647
{yyval = gc3(buildTuple(yypvt[-1]));} break;
case 310:
# line 648
{yyval = gc3(ap(FINLIST,rev(yypvt[-1])));} break;
case 311:
# line 649
{yyval = gc2(ap(LAZYPAT,yypvt[-0]));} break;
case 312:
# line 651
{
#if TREX
					 yyval = gc3(revOnto(yypvt[-1],nameNoRec));
#else
					 yyval = gc3(NIL);
#endif
					} break;
case 313:
# line 658
{yyval = gc5(revOnto(yypvt[-3],yypvt[-1]));} break;
case 314:
# line 661
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 315:
# line 662
{yyval = gc3(cons(yypvt[-0],singleton(yypvt[-2])));} break;
case 316:
# line 664
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 317:
# line 665
{yyval = gc1(singleton(yypvt[-0]));} break;
case 318:
# line 667
{yyval = gc0(NIL);} break;
case 319:
# line 668
{yyval = gc1(rev(yypvt[-0]));} break;
case 320:
# line 670
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 321:
# line 671
{yyval = gc1(singleton(yypvt[-0]));} break;
case 322:
# line 673
{yyval = gc3(pair(yypvt[-2],yypvt[-0]));} break;
case 323:
# line 674
{yyval = yypvt[-0];} break;
case 324:
# line 677
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 325:
# line 678
{yyval = gc1(singleton(yypvt[-0]));} break;
case 326:
# line 680
{
#if TREX
					 yyval = gc3(ap(mkExt(textOf(yypvt[-2])),yypvt[-0]));
#else
					 noTREX("a pattern");
#endif
					} break;
case 327:
# line 692
{yyval = yypvt[-0];} break;
case 328:
# line 693
{syntaxError("expression");} break;
case 329:
# line 695
{yyval = gc3(ap(ESIGN,pair(yypvt[-2],yypvt[-0])));} break;
case 330:
# line 696
{
#if IPARAM
					 yyval = gc3(ap(WITHEXP,pair(yypvt[-2],yypvt[-0])));
#else
					 noIP("an expression");
#endif
					} break;
case 331:
# line 703
{yyval = yypvt[-0];} break;
case 332:
# line 705
{yyval = yypvt[-0];} break;
case 333:
# line 706
{yyval = yypvt[-0];} break;
case 334:
# line 708
{yyval = gc1(ap(INFIX,yypvt[-0]));} break;
case 335:
# line 709
{yyval = yypvt[-0];} break;
case 336:
# line 711
{yyval = gc1(ap(INFIX,yypvt[-0]));} break;
case 337:
# line 712
{yyval = yypvt[-0];} break;
case 338:
# line 714
{yyval = gc4(ap(NEG,ap(ap(yypvt[-2],yypvt[-3]),yypvt[-0])));} break;
case 339:
# line 715
{yyval = gc3(ap(ap(yypvt[-1],yypvt[-2]),yypvt[-0]));} break;
case 340:
# line 716
{yyval = gc2(ap(NEG,only(yypvt[-0])));} break;
case 341:
# line 717
{yyval = gc4(ap(NEG,
						     ap(ap(yypvt[-2],only(yypvt[-3])),yypvt[-0])));} break;
case 342:
# line 719
{yyval = gc3(ap(ap(yypvt[-1],only(yypvt[-2])),yypvt[-0]));} break;
case 343:
# line 721
{yyval = gc4(ap(NEG,ap(ap(yypvt[-2],yypvt[-3]),yypvt[-0])));} break;
case 344:
# line 722
{yyval = gc3(ap(ap(yypvt[-1],yypvt[-2]),yypvt[-0]));} break;
case 345:
# line 723
{yyval = gc2(ap(NEG,only(yypvt[-0])));} break;
case 346:
# line 724
{yyval = gc4(ap(NEG,
						     ap(ap(yypvt[-2],only(yypvt[-3])),yypvt[-0])));} break;
case 347:
# line 726
{yyval = gc3(ap(ap(yypvt[-1],only(yypvt[-2])),yypvt[-0]));} break;
case 348:
# line 728
{yyval = gc6(ap(CASE,pair(yypvt[-4],rev(yypvt[-1]))));} break;
case 349:
# line 729
{yyval = gc4(ap(DOCOMP,checkDo(yypvt[-1])));} break;
case 350:
# line 730
{yyval = yypvt[-0];} break;
case 351:
# line 732
{yyval = gc4(ap(LAMBDA,      
						     pair(rev(yypvt[-2]),
							  pair(yypvt[-1],yypvt[-0]))));} break;
case 352:
# line 735
{yyval = gc4(letrec(yypvt[-2],yypvt[-0]));} break;
case 353:
# line 736
{yyval = gc6(ap(COND,triple(yypvt[-4],yypvt[-2],yypvt[-0])));} break;
case 354:
# line 737
{
#if IPARAM
					 yyval = gc4(ap(WITHEXP,pair(yypvt[-0],yypvt[-2])));
#else
					 noIP("an expression");
#endif
					} break;
case 355:
# line 745
{yyval = gc2(cons(yypvt[-0],yypvt[-1]));} break;
case 356:
# line 746
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 357:
# line 748
{yyval = gc2(ap(yypvt[-1],yypvt[-0]));} break;
case 358:
# line 749
{yyval = yypvt[-0];} break;
case 359:
# line 751
{yyval = yypvt[-0];} break;
case 360:
# line 752
{yyval = gc3(ap(ASPAT,pair(yypvt[-2],yypvt[-0])));} break;
case 361:
# line 753
{yyval = gc2(ap(LAZYPAT,yypvt[-0]));} break;
case 362:
# line 754
{yyval = yypvt[-0];} break;
case 363:
# line 755
{yyval = gc1(WILDCARD);} break;
case 364:
# line 756
{yyval = yypvt[-0];} break;
case 365:
# line 757
{yyval = gc4(ap(CONFLDS,pair(yypvt[-3],yypvt[-1])));} break;
case 366:
# line 758
{yyval = gc4(ap(UPDFLDS,
						     triple(yypvt[-3],NIL,yypvt[-1])));} break;
case 367:
# line 760
{yyval = yypvt[-0];} break;
case 368:
# line 761
{yyval = yypvt[-0];} break;
case 369:
# line 762
{yyval = yypvt[-0];} break;
case 370:
# line 763
{yyval = yypvt[-0];} break;
case 371:
# line 764
{yyval = gc3(yypvt[-1]);} break;
case 372:
# line 765
{yyval = gc3(buildTuple(yypvt[-1]));} break;
case 373:
# line 767
{
#if TREX
					 yyval = gc3(revOnto(yypvt[-1],nameNoRec));
#else
					 yyval = gc3(NIL);
#endif
					} break;
case 374:
# line 774
{yyval = gc5(revOnto(yypvt[-3],yypvt[-1]));} break;
case 375:
# line 775
{yyval = yypvt[-0];} break;
case 376:
# line 777
{yyval = gc3(yypvt[-1]);} break;
case 377:
# line 778
{yyval = gc4(ap(yypvt[-1],yypvt[-2]));} break;
case 378:
# line 779
{yyval = gc4(ap(ap(nameFlip,yypvt[-2]),yypvt[-1]));} break;
case 379:
# line 780
{yyval = gc4(ap(ap(nameFlip,yypvt[-2]),yypvt[-1]));} break;
case 380:
# line 782
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 381:
# line 783
{yyval = gc3(cons(yypvt[-0],cons(yypvt[-2],NIL)));} break;
case 382:
# line 786
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 383:
# line 787
{yyval = gc1(singleton(yypvt[-0]));} break;
case 384:
# line 789
{
#if TREX
					 yyval = gc3(ap(mkExt(textOf(yypvt[-2])),yypvt[-0]));
#else
					 noTREX("an expression");
#endif
					} break;
case 385:
# line 798
{yyval = yypvt[-0];} break;
case 386:
# line 799
{yyval = gc2(yypvt[-1]);} break;
case 387:
# line 801
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 388:
# line 802
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 389:
# line 804
{yyval = gc3(pair(yypvt[-2],letrec(yypvt[-0],yypvt[-1])));} break;
case 390:
# line 806
{yyval = gc1(grded(rev(yypvt[-0])));} break;
case 391:
# line 807
{yyval = gc2(pair(yypvt[-1],yypvt[-0]));} break;
case 392:
# line 808
{syntaxError("case expression");} break;
case 393:
# line 810
{yyval = gc2(cons(yypvt[-0],yypvt[-1]));} break;
case 394:
# line 811
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 395:
# line 813
{yyval = gc4(pair(yypvt[-1],pair(yypvt[-2],yypvt[-0])));} break;
case 396:
# line 815
{yyval = gc2(yypvt[-1]);} break;
case 397:
# line 816
{yyval = yypvt[-0];} break;
case 398:
# line 818
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 399:
# line 819
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 400:
# line 821
{yyval = gc3(ap(FROMQUAL,pair(yypvt[-2],yypvt[-0])));} break;
case 401:
# line 822
{yyval = gc2(ap(QWHERE,yypvt[-0]));} break;
case 402:
# line 824
{yyval = gc1(ap(DOQUAL,yypvt[-0]));} break;
case 403:
# line 826
{yyval = gc0(NIL);} break;
case 404:
# line 827
{yyval = gc1(rev(yypvt[-0]));} break;
case 405:
# line 829
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 406:
# line 830
{yyval = gc1(singleton(yypvt[-0]));} break;
case 407:
# line 832
{yyval = yypvt[-0];} break;
case 408:
# line 833
{yyval = gc3(pair(yypvt[-2],yypvt[-0]));} break;
case 409:
# line 835
{yyval = gc3(yypvt[-1]);} break;
case 410:
# line 836
{yyval = gc3(yypvt[-1]);} break;
case 411:
# line 838
{yyval = gc0(NIL);} break;
case 412:
# line 839
{yyval = gc2(yypvt[-1]);} break;
case 413:
# line 840
{yyval = gc2(yypvt[-1]);} break;
case 414:
# line 842
{yyval = gc2(cons(yypvt[-0],yypvt[-1]));} break;
case 415:
# line 844
{yyval = gc3(pair(yypvt[-2],yypvt[-0]));} break;
case 416:
# line 849
{yyval = gc1(ap(FINLIST,cons(yypvt[-0],NIL)));} break;
case 417:
# line 850
{yyval = gc1(ap(FINLIST,rev(yypvt[-0])));} break;
case 418:
# line 851
{yyval = gc3(ap(COMP,pair(yypvt[-2],rev(yypvt[-0]))));} break;
case 419:
# line 852
{yyval = gc3(ap(ap(nameFromTo,yypvt[-2]),yypvt[-0]));} break;
case 420:
# line 853
{yyval = gc4(ap(ap(nameFromThen,yypvt[-3]),yypvt[-1]));} break;
case 421:
# line 854
{yyval = gc2(ap(nameFrom,yypvt[-1]));} break;
case 422:
# line 855
{yyval = gc5(ap(ap(ap(nameFromThenTo,
								yypvt[-4]),yypvt[-2]),yypvt[-0]));} break;
case 423:
# line 858
{yyval = gc3(cons(yypvt[-0],yypvt[-2]));} break;
case 424:
# line 859
{yyval = gc1(cons(yypvt[-0],NIL));} break;
case 425:
# line 861
{yyval = gc3(ap(FROMQUAL,pair(yypvt[-2],yypvt[-0])));} break;
case 426:
# line 862
{yyval = gc1(ap(BOOLQUAL,yypvt[-0]));} break;
case 427:
# line 863
{yyval = gc2(ap(QWHERE,yypvt[-0]));} break;
case 428:
# line 868
{yyval = yypvt[-0];} break;
case 429:
# line 869
{yyval = gc2(nameUnit);} break;
case 430:
# line 870
{yyval = gc2(nameNil);} break;
case 431:
# line 871
{yyval = gc3(yypvt[-1]);} break;
case 432:
# line 873
{yyval = gc2(mkTuple(tupleOf(yypvt[-1])+1));} break;
case 433:
# line 874
{yyval = gc1(mkTuple(2));} break;
case 434:
# line 876
{yyval = yypvt[-0];} break;
case 435:
# line 877
{yyval = gc1(varHiding);} break;
case 436:
# line 878
{yyval = gc1(varQualified);} break;
case 437:
# line 879
{yyval = gc1(varAsMod);} break;
case 438:
# line 881
{yyval = yypvt[-0];} break;
case 439:
# line 882
{yyval = yypvt[-0];} break;
case 440:
# line 884
{yyval = yypvt[-0];} break;
case 441:
# line 885
{yyval = gc3(yypvt[-1]);} break;
case 442:
# line 886
{yyval = gc3(varPlus);} break;
case 443:
# line 887
{yyval = gc3(varMinus);} break;
case 444:
# line 888
{yyval = gc3(varBang);} break;
case 445:
# line 889
{yyval = gc3(varDot);} break;
case 446:
# line 891
{yyval = yypvt[-0];} break;
case 447:
# line 892
{yyval = gc3(yypvt[-1]);} break;
case 448:
# line 893
{yyval = yypvt[-0];} break;
case 449:
# line 895
{yyval = yypvt[-0];} break;
case 450:
# line 896
{yyval = gc3(yypvt[-1]);} break;
case 451:
# line 898
{yyval = yypvt[-0];} break;
case 452:
# line 899
{yyval = gc3(yypvt[-1]);} break;
case 453:
# line 900
{yyval = yypvt[-0];} break;
case 454:
# line 902
{yyval = gc1(varPlus);} break;
case 455:
# line 903
{yyval = gc1(varMinus);} break;
case 456:
# line 904
{yyval = yypvt[-0];} break;
case 457:
# line 906
{yyval = gc1(varPlus);} break;
case 458:
# line 907
{yyval = yypvt[-0];} break;
case 459:
# line 909
{yyval = gc1(varMinus);} break;
case 460:
# line 910
{yyval = yypvt[-0];} break;
case 461:
# line 912
{yyval = yypvt[-0];} break;
case 462:
# line 913
{yyval = gc3(yypvt[-1]);} break;
case 463:
# line 914
{yyval = gc1(varBang);} break;
case 464:
# line 915
{yyval = gc1(varDot);} break;
case 465:
# line 917
{yyval = gc1(varMinus);} break;
case 466:
# line 918
{yyval = yypvt[-0];} break;
case 467:
# line 920
{yyval = yypvt[-0];} break;
case 468:
# line 921
{yyval = gc3(yypvt[-1]);} break;
case 469:
# line 922
{yyval = yypvt[-0];} break;
case 470:
# line 925
{yyval = yypvt[-0];} break;
case 471:
# line 926
{yyval = gc3(yypvt[-1]);} break;
case 472:
# line 928
{yyval = yypvt[-0];} break;
case 473:
# line 929
{yyval = gc3(yypvt[-1]);} break;
case 474:
# line 930
{yyval = yypvt[-0];} break;
case 475:
# line 932
{yyval = yypvt[-0];} break;
case 476:
# line 933
{yyval = yypvt[-0];} break;
case 477:
# line 935
{yyval = yypvt[-0];} break;
case 478:
# line 936
{yyval = yypvt[-0];} break;
case 479:
# line 941
{yyerrok; goOffside(startColumn);} break;
case 480:
# line 944
{yyval = yypvt[-0];} break;
case 481:
# line 945
{yyerrok; 
					 if (canUnOffside()) {
					     unOffside();
					     /* insert extra token on stack*/
					     push(NIL);
					     pushed(0) = pushed(1);
					     pushed(1) = mkInt(column);
					 }
					 else
					     syntaxError("definition");
					} break;/* End of actions */
    }
    goto yystack;  /* stack new state and value */

}
