// ---------------------------------------------------------------------------
// - cmem.cxx                                                                -
// - standard system library - c low level memmory function implementation   -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#define _GNU_SOURCE 

#include <unistd.h>
#include <sys/types.h>
#include <sys/mman.h>
#include "cio.hxx"
#include "cmem.hxx"
#include "csys.hxx"
 
namespace aleph {

  // return the system memory page
  long c_pagesize (void) {
    return getpagesize ();
  }

  // allocate a block of memory
  void* c_mmap (const long size) {
    void* ptr = mmap (0,size,PROT_READ|PROT_WRITE,MAP_PRIVATE|MAP_ANON,-1,0);
    if ((long) ptr == -1) c_exit (1);
    return ptr;
  }

  // reallocate a block of memory
  void* c_mremap (void* optr, const long osize, const long nsize) {
    void* ptr = mremap ((caddr_t) optr,osize,nsize,MREMAP_MAYMOVE);
    if ((long) ptr == -1) c_exit (1);
    return ptr;
  }

  // unmap a memory block
  void c_munmap (void* ptr, const long size) {
    munmap ((caddr_t) ptr,size);
  }
}
