#include <termios.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/time.h>
#include <time.h>
#include <unistd.h>
#include <errno.h>

#include "afos.h"


fd_set masterfds, master_write_fds, rfds, wfds ;
int fdmax ;
struct timeval tv ;
time_t last_update_time ;

typedef struct _TIMEOUT_HANDLE_ {
	struct _TIMEOUT_HANDLE_ *next ;
	void (*func)() ;
	} TIMEOUT_HANDLE ;

TIMEOUT_HANDLE *timeout_list ;

typedef struct _HANDLE_ {
	struct _HANDLE_ *next ;
	void *reapee ;
	} HANDLE ;

static HANDLE *reapers_list ;
static HANDLE *free_handles ;
static HANDLE handles[32] ;

AF_SELECT_ENTRY *af_select_list ;
AF_SELECT_ENTRY *af_write_select_list ;

afloop_init()
{
	int i ;

	af_select_list = NULL ;
	af_write_select_list = NULL ;
	timeout_list = NULL ;
	fdmax = 0 ;

	/* Prepare reaper's structures */
	reapers_list = NULL ;
	free_handles = &handles[0] ;
	for ( i = 0 ; i < 32 ; i++ )
		handles[i].next = &handles[i+1] ;
	handles[i-1].next = NULL ;
}

void
afloop_timeout_handler()
{
	TIMEOUT_HANDLE *p ;

	for ( p = timeout_list ; p ; p = p->next )
		p->func();
}

void
af_timeout_set_handler ( void *p )
{
	TIMEOUT_HANDLE *h ;

	h = (TIMEOUT_HANDLE *)malloc(sizeof(*h)) ;
	if (!h)
	{
		fprintf(stderr,"Unable to allocate memory for time-out structure\n");
		return;
	}
	h->next = timeout_list ;
	timeout_list = h ;
	h->func = p ;
}

update_write_master_rfds()
{
	AF_SELECT_ENTRY *p ;

	fdmax = 0 ;
	FD_ZERO(&master_write_fds);
	for (p = af_select_list ; p ; p = p->next )
	{
		if (p->fd > fdmax)
			fdmax = p->fd ;
	}
	for (p = af_write_select_list ; p ; p = p->next )
	{
		FD_SET(p->fd,&master_write_fds);
		if (p->fd > fdmax)
			fdmax = p->fd ;
	}
}

update_master_rfds()
{
	AF_SELECT_ENTRY *p ;

	FD_ZERO(&masterfds);
	for (p = af_select_list ; p ; p = p->next )
	{
		FD_SET(p->fd,&masterfds);
		if (p->fd > fdmax)
			fdmax = p->fd ;
	}
	for (p = af_write_select_list ; p ; p = p->next )
	{
		if (p->fd > fdmax)
			fdmax = p->fd ;
	}
}

static void
afloop_reap(HANDLE *p)
{
	if (p->next)
		afloop_reap (p->next);
	free ( p->reapee ) ;
	p->next = free_handles ;
	free_handles = p ;
}

static void
afloop_add_to_reapers_list ( AF_SELECT_ENTRY *p )
{
	HANDLE *q ;

	if (!free_handles)
	{
		fprintf(stderr,"afloop out of reaping resources. Memory leaked.\n");
		return ;
	}
	q = free_handles ;
	free_handles = q->next ;
	q->reapee ;
	q->next = reapers_list ;
	reapers_list = q ;
}

afloop_write_select_list_remove ( int fd )
{
	AF_SELECT_ENTRY *p, *pp ;

	p = NULL ;
	for (pp = af_write_select_list ; pp ; pp = pp->next )
	{
		if (pp->fd == fd)
		{
			if ( p == NULL )
			{
				af_write_select_list = pp->next ;
				afloop_add_to_reapers_list (pp);
				update_write_master_rfds() ;
				return ;
			}
			else
			{
				p->next = pp->next ;
				afloop_add_to_reapers_list (pp);
				update_write_master_rfds() ;
				return ;	
			}
		}
		p = pp ;
	}
}

int
afloop_write_select_list_add ( int fd, void (*handler)(void *p, int e), 
                         void *private )
{
	AF_SELECT_ENTRY *p, *pp ;

	p = (AF_SELECT_ENTRY *)malloc (sizeof(*p)) ;
	if (p == NULL)
	{
		write(2,"radiod unable to allocate memory\n",33) ;
		return -1 ;
	}	

	p->fd = fd ;
	p->handler = handler ;
	p->private = private ;
	if (af_write_select_list == NULL)
	{
		af_write_select_list = p ;
		p->next = NULL ;
	}
	else
	{
		/* check for duplicate list entry */
		for (pp = af_write_select_list ; pp ; pp = pp->next )
			if (pp->fd == p->fd)
			{
				free (p);
				write (2, "af_select_list_add: duplicate fd entry.\n",40) ;
				return -1 ;	
			}
		p->next = af_write_select_list ;
		af_write_select_list = p ;
	}
	update_write_master_rfds() ;
	return 0 ;
}


afloop_select_list_remove ( int fd )
{
	AF_SELECT_ENTRY *p, *pp ;

	p = NULL ;
	for (pp = af_select_list ; pp ; pp = pp->next )
	{
		if (pp->fd == fd)
		{
			if ( p == NULL )
			{
				af_select_list = pp->next ;
				afloop_add_to_reapers_list (pp);
				update_master_rfds() ;
				return ;
			}
			else
			{
				p->next = pp->next ;
				afloop_add_to_reapers_list (pp);
				update_master_rfds() ;
				return ;	
			}
		}
		p = pp ;
	}
}

int
afloop_select_list_add ( int fd, void (*handler)(void *p, int e), 
                         void *private )
{
	AF_SELECT_ENTRY *p, *pp ;

	p = (AF_SELECT_ENTRY *)malloc (sizeof(*p)) ;
	if (p == NULL)
	{
		write(2,"radiod unable to allocate memory\n",33) ;
		return -1 ;
	}	

	p->fd = fd ;
	p->handler = handler ;
	p->private = private ;
	if (af_select_list == NULL)
	{
		af_select_list = p ;
		p->next = NULL ;
	}
	else
	{
		/* check for duplicate list entry */
		for (pp = af_select_list ; pp ; pp = pp->next )
			if (pp->fd == p->fd)
			{
				free (p);
				write (2, "af_select_list_add: duplicate fd entry.\n",40) ;
				return -1 ;	
			}
		p->next = af_select_list ;
		af_select_list = p ;
	}
	update_master_rfds() ;
	return 0 ;
}

afloop()
{
	AF_SELECT_ENTRY *p ;
	int ret ;
	fd_set xfds ;

	time(&last_update_time) ;
	for ( ; ; )
	{
		memcpy (&rfds, &masterfds, sizeof(masterfds) );
		memcpy (&wfds, &master_write_fds, sizeof(masterfds) );

		tv.tv_sec = DISPLAY_UPDATE_INTERVAL ;
		tv.tv_usec = 0 ;

		ret = select ( (fdmax + 1), &rfds, &wfds, NULL , &tv );

		if ( ret == 0 )
		{
			/* Time interval elapsed */
			afloop_timeout_handler();
			time(&last_update_time) ;
		}
		if (ret == -1)
		{
			if (errno != EINTR )
			{
				perror ("select returned error");
				afloop_list_select_entries() ;
				exit (-1 );
			}
			continue ;
		}

		/*
			Check time since last timeout, call timeout routine if appropriate
		*/
		if  ( time(NULL) > (last_update_time + DISPLAY_UPDATE_INTERVAL) )
		{
			/* Time interval elapsed */
			afloop_timeout_handler() ;
			time(&last_update_time) ;
		}

		for (p = af_write_select_list ; p ; p = p->next )
		{
			if ( FD_ISSET (p->fd, &wfds ) )
			{
#if 0
				fprintf(stderr,"Write event fd=%d\n", p->fd);
#endif
				p->handler ( p->private, AFEVENT_WRITE ) ;
				continue ;
			}
		}
		for (p = af_select_list ; p ; p = p->next )
		{
			if ( FD_ISSET (p->fd, &rfds ) )
			{
#if 0
				fprintf(stderr,"Read event fd=%d\n", p->fd);
#endif
				p->handler ( p->private, AFEVENT_READ ) ;
				continue ;
			}
		}
		/* Free any entries removed earlier */
		if ( reapers_list )
		{
			afloop_reap ( reapers_list ) ;
			reapers_list = NULL ;
		}
	}
	exit(0);
}

afloop_list_select_entries()
{
	AF_SELECT_ENTRY *p ;

	fprintf(stderr,"Select list entries (read fd's): ");
	for (p = af_select_list ; p ; p = p->next )
		fprintf(stderr," %d", p->fd);
	fprintf (stderr,".\n");
	fprintf(stderr,"Select list entries (write fd's): ");
	for (p = af_write_select_list ; p ; p = p->next )
		fprintf(stderr," %d", p->fd);
	fprintf (stderr,".\n");
}
