/*
 * UnixCW - Unix CW (Morse code) training program
 * Copyright (C) 1998  Simon Baldwin (simonb@sco.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * cw.h - header and definitions for morse code sender program; include
 *        in any program that will need to interface with the sender
 *
 */

#ifndef _CW_H
#define	_CW_H

/* general command and query introducers */
#define	CW_CMD_ESCAPE	'@'		/* command escape character */
#define	CW_CMD_QUERY	'?'		/* query subcommand */
#define	CW_CMD_CWQUERY	'>'		/* cw report query subcommand */
#define	CW_CMD_END	';'		/* completes an embedded command */

/* specific command value specifiers */
#define	CW_CMDV_TONE	'T'		/* CW tone */
#define	CW_CMDV_WPM	'W'		/* CW words-per-minute */
#define	CW_CMDV_GAP	'G'		/* CW extra gaps in sending */
#define	CW_CMDV_ADJ	'A'		/* CW adjustment % on speed */
#define	CW_CMDV_ECHO	'E'		/* CW echo chars to stdout */
#define	CW_CMDV_MSGS	'M'		/* CW error msgs to stderr */
#define	CW_CMDV_CMDS	'C'		/* CW responds to @... embedded cmds */
#define	CW_CMDV_COMBO	'O'		/* CW allows [..] combinations */
#define	CW_CMDV_COMMENT	'P'		/* CW allows {..} combinations */
#define	CW_CMDV_QUIT	'Q'		/* CW program exit command */

/* combination and comment start and end characters */
#define	CW_COMBO_START		'['	/* begin [..] */
#define	CW_COMBO_END		']'	/* end [..] */
#define	CW_COMMENT_START	'{'	/* begin {..} */
#define	CW_COMMENT_END		'}'	/* begin {..} */

/* status values - first character of stderr messages */
#define	CW_STATUS_OK		'='	/* =... command accepted OK */
#define	CW_STATUS_ERR		'?'	/* ?... error in command */

/* limits on values of CW parameters */
#define	CW_MIN_TONE		0	/* lowest tone allowed (0=silent) */
#define	CW_MAX_TONE		10000	/* highest tone allowed */
#define	CW_MIN_WPM		1	/* lowest WPM allowed */
#define	CW_MAX_WPM		60	/* highest WPM allowed */
#define	CW_MIN_GAP		0	/* lowest extra gap allowed */
#define	CW_MAX_GAP		100	/* highest extra gap allowed */
#define	CW_MIN_ADJ		-50	/* allow timing shortened by 50% */
#define	CW_MAX_ADJ		50	/* allow timing lengthened by 50% */

/* list of sendable (soundable) characters */
#define	CW_OK_CHARS	" ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789\"'$()+,-./:;=?_"

#endif /* _CW_H */

