/* psk31.h
 * User level API interface functions
 * Hansi Reiser, DL9RDZ, 20 Apr 1998
 */

#ifndef PSK31_H_INCLUDED
#define PSK31_H_INCLUDED

/* codeword-flags */
#define CODE_USE_QPSK 0x010000       /* use qpsk for this codeword flag */
#define CODE_TONE_ON  0x020000       /* tone on flag */
#define CODE_CW_ECHO  0x040000       /* cw char for echo only */
#define CODE_PLAIN    0x080000       /* not yet encoded byte */
#define TX_START      0x100001
#define TX_END        0x100002       /* signalisiere Sendedurchgang zu Ende */
#define NO_CHAR       0x800000
#define TX_BUSY       0x800001
#define TX_ERROR      0x800002


#define EMPTY_SAMPLE  0x100000

typedef struct {
	float x,y;
} complex;


void fftsr_init();
void fftsr_main(float *x, double *y);

#include "window.h"
extern window *statwin;

#endif
