#!/usr/local/bin/bltwish -f


set datafile [lindex $argv 0]


# the Cartesian Coordinate Window
toplevel .rectangular
raise .rectangular
wm title .rectangular "Cartesian Coordianates"
wm geometry .rectangular +50+50
wm iconname .rectangular "Cartesian"
raise .rectangular

# controls
frame .rectangular.geometry2
frame .rectangular.controls

pack .rectangular.geometry2 .rectangular.controls 


#the Cartesian coordinate system
graph .rectangular.cartesian -title "X-Y Power Plane Cartesian Coordinates"
pack .rectangular.cartesian  -in .rectangular.geometry2
button .rectangular.controls.postscript -text "Save to Postscript File" -command {
    .rectangular.cartesian postscript output "rectangular.ps"
}

button .rectangular.controls.quit -text "quit" -command {exit}
pack .rectangular.controls.postscript  .rectangular.controls.quit








###################### now on to the real action
set maxgain 0

set f [open $datafile]

####################### try for impendance and SWR


# We will store them in lists
set taglist {}
set ZRlist {}
set ZIlist {}
set Zlist {}
set SWRlist {}



# first, run through the output looking for the right section

while { [gets $f line ] >= 0 } {
    if { [regexp  {ANTENNA INPUT}  $line ] } {
	break
    }
}

# we are after the impedance and SWR - skip three lines 
gets $f line
gets $f line
gets $f line

# from here, the impedance is buried in the next non-blank lines.
# NEC actually will force us to "count columns" I'm afraid

# the format of the line is

#     2    11-1.00000E+00 0.00000E+00-1.72281E-03 4.25444E-04 5.47085E+02 1.35101E+02 1.72281E-03-4.25444E-04 8.61404E-04
#012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789

# tagnumber 0-5
# segment number 6-11
# voltage (real) 12-23
# voltage (imag) 24-35
# current (real) 36-47
# current (imag) 48-59
# impedance (real) 60-71
# impedance (imag) 72-83
# admittance (real) 84-95
# admittance (imag) 96-107
# power 108-119


# all I really need is the tagnumber, the segment number, and the real and imaginary
# impedance


# read the next line
gets $f line
while {[string length $line] > 0 } {
#    puts "impedance line $line"
    set tagnumber [string range $line 0 5]
    lappend taglist $tagnumber
    set segmentnumber [string range $line 6 11]
    set Zr [string range $line 60 71]
    lappend Zrlist $Zr
    set Zi [string range $line 73 83]
#    puts "Z is $Zr + j * $Zi"
    lappend Zilist $Zi
    gets $f line
#    puts "$tagnumber - $segmentnumber Zr $Zr Zi $Zi"
    set normZ [ expr sqrt ( $Zr * $Zr + $Zi * $Zi) ]
    lappend Zlist $normZ
#    puts "|Z| is $normZ"
    set gamma [expr sqrt( (($Zr - 52) *($Zr - 52) + $Zi * $Zi )/( ($Zr + 52) * ($Zr + 52) + $Zi * $Zi ) ) ]
    set SWR [expr (1 + $gamma) /(1 - $gamma)]
#    puts "SWR is $SWR to 1"
    lappend SWRlist $SWR
}




#### end of impedance and SWR section



while { [gets $f line ] >= 0 } {

    if { [regexp  {RADIATION}  $line ] } {
	break
    }
    
	
   
}

# we skip seven lines and then start loading the vectors
gets $f line
gets $f line
gets $f line
gets $f line
gets $f line
gets $f line
gets $f line

# now start the loop again, loading the vectors
# We assume we are doing an azimuth plot and that
# we are using one of our "standard RP cards" so that
# there will be at most 360 entries for gain.
## RP  0  1    361 1001  60.0  0.0  0.0  1.0  10000.0 0.00E+00
#
# a line consists of several fields ---
# the first is elevation
# the second is azimuth
# the third and fourth are components
# the fifth is gain
# the rest are junk



vector gain(362)
vector angle(362)

# cell counter
set count 0

while { [gets $f line ] >= 0 } {
    scan $line "%f %f %f %f %f %f %f %s %f %f %f %f" e0 a0 junk1 junk2 g0 junk3 junk4 junk5 junk6 junk7 junk8 junk9

    # if the gain is too small, just set it to about -60
    if {$g0 < -60.0} {
	set g0 -60.0
    }
    set gain($count) $g0
    set angle($count) $count

    # if I find a blank line, I just quit
    if {[string length $line] == 0} {
	break
    }
    set count [expr $count + 1]

}


close $f






# a Cartesian graph is easy
.rectangular.cartesian axis configure "x" -step 60.0
set mingain $gain(min)
set maxgain $gain(max)
##########################################################
# we need to find the angles for which maxgain occurs
# maxgain is at these angles  -- caution - may be a list

set maxangles [gain search $maxgain]



##########################################################


.rectangular.cartesian element create "e1" -label "Cartesian" \
	-xdata angle -ydata gain \
	-label "Max Gain is $maxgain" \
	-symbol "none"



# we need to scale the gain vector by adding the minimum gain
# to each entry

vector newgain(360)
newgain set  [gain  - $mingain]

#scaled data can be displayed
#.rectangular.cartesian element create "e2" -label "Cartesian" \
#	-xdata angle -ydata newgain \
#	-label "Scaled Gain" \
#	-color red \
#	-symbol "none"


#################################### Polar Coordinates part
# the linear Polar Coordinate Window
toplevel .polar
raise .polar
wm title .polar "Cartesian Coordianates" 
wm geometry .polar +100+100
wm iconname .polar "Polar"
raise .polar
graph .polar.graph -title "X-Y Linear Power Polar Graph" -width 600 -height 450
frame .polar.controls
pack .polar.graph .polar.controls
button .polar.controls.quit -text "Quit" -command {exit}
button .polar.controls.postscript -text "Save to Postscript File" -command {
    .polar.graph  postscript output "polar.ps"
}
pack .polar.controls.postscript .polar.controls.quit



# create two vectors to contain the points
vector x(361) y(361)

# create a  unit circle  line
vector yDB(361)
vector xDB(361)


for {set i 0} {$i <= 360} {incr i 1} {
    set radians [expr  $angle($i) * 3.14159/180.0 ]
    set x($i) [expr cos($radians) * $newgain($i)]
    set y($i) [expr sin($radians) * $newgain($i)]
    set xDB($i) cos($radians)
    set yDB($i) sin($radians)
}




.polar.graph element create "e1" -label "Gain" \
	-xdata x -ydata y \
	-color red \
	-symbol "none"


################################################
######## put the scales on the graph
    # create a 0 DB line
    set scale $newgain(max)
    set originalscale $scale
    vector x0db(361)
    vector y0db(361)
    
    y0db set [yDB * $scale]
    x0db set [xDB * $scale]

# we need to put radials on the graph

for {set i 0} {$i < 361} {incr i 5} {
    vector pgridx{$i}(2)
    vector pgridy{$i}(2)
    set pgridx{$i}(0)  0
    set pgridy{$i}(0) 0
    
    set widthofline 1
    if { ($i % 30 ) == 0 } {
	set widthofline 2
    } 
	
    set pgridx{$i}(1) [expr $originalscale * $xDB($i)]

    set pgridy{$i}(1) [expr $originalscale  * $yDB($i)]
        
    .polar.graph element create "line$i" \
	    -xdata pgridx{$i} -ydata pgridy{$i} \
	    -color cyan \
	    -label "" \
	    -symbol "none" -linewidth $widthofline
}
#####################################

# put the data on the graph, with maxgain at 0DB
.polar.graph element create "e2" -label "0 DB reference is $maxgain" \
	-xdata x0db -ydata y0db \
	-color blue \
	-symbol "none"

######################### linear log scale here

## build a loop to put each of the grid lines on the graph
set counter 0
while {$scale > 10} {
    set counter [expr $counter + 10]
    vector x{$counter} (361)
    vector y{$counter}(361)
    set scale [expr $scale - 10]
    x{$counter} set [xDB * $scale]
    y{$counter}  set [yDB *  $scale]
    .polar.graph element create "e$scale" -label "-$counter DB" \
	    -xdata x{$counter} -ydata y{$counter} \
	    -color blue \
	    -symbol "none"
    
}

#  end of linear polar coordinate window
##########################################################
#################################### ARRL Polar
# the ARRL  Coordinate Window
toplevel .arrl
raise .arrl
wm title .arrl "ARRL Scale Power Polar Coordianates"
wm geometry .arrl +150+150
wm iconname .arrl "arrl"
raise .arrl
graph .arrl.graph -title "X-Y ARRL Power Graph" -width 600 -height 450
frame .arrl.controls
pack .arrl.graph .arrl.controls
button .arrl.controls.quit -text "Quit" -command {exit}
button .arrl.controls.postscript -text "Save to Postscript File" -command {
    .arrl.graph  postscript output "arrl.ps"
}
pack .arrl.controls.postscript .arrl.controls.quit
lower .


# create two vectors to contain the points

# original data is in newgain vector

vector xarrl(361) yarrl(361)

for {set i 0} {$i <= 360} {incr i 1} {
    set radians [expr  $angle($i) * 3.14159/180.0 ]
    set xarrl($i) [expr cos($radians) * exp(0.43439/0.98*$newgain($i)/10)]
    set yarrl($i) [expr sin($radians) * exp(0.43439/0.98*$newgain($i)/10)]
}




.arrl.graph element create "e1" -label "Gain" \
	-xdata xarrl -ydata yarrl \
	-color red \
	-symbol "none"


################################################
######## put the scales on the graph
    # create a 0 DB line 
    set originalscale $newgain(max)
    vector x0dbarrl(361)
    vector y0dbarrl(361)

#set up the data on the graph
for {set i 0} {$i <= 360} {incr i 1} {
    set y0dbarrl($i) [expr exp(0.43439/0.98*$originalscale/10.0) * $yDB($i)]
    set x0dbarrl($i) [expr exp(0.43439/0.98*$originalscale/10.0) * $xDB($i)]
}

#####################################

# put the data on the graph, with maxgain at 0DB
.arrl.graph element create "e2" -label "0 DB reference is $maxgain" \
	-xdata x0dbarrl -ydata y0dbarrl \
	-color blue \
	-symbol "none"

######################### ARRL log scale here

## build a loop to put each of the grid lines on the graph
set counter 0
set arrlsteps {3 6 10 20 30 40 50 60 70 80}
set scale $originalscale

# we need to put radials on the graph

for {set i 0} {$i < 361} {incr i 5} {
    vector gridx{$i}(2)
    vector gridy{$i}(2)
    set gridx{$i}(0)  0
    set gridy{$i}(0) 0

    set gridx{$i}(1) [expr exp(0.43439/0.98*$originalscale/10.0) * $xDB($i)]

    set gridy{$i}(1) [expr exp(0.43439/0.98*$originalscale/10.0) * $yDB($i)]

    set widthofline 1
    if { ($i % 30 ) == 0 } {
	set widthofline 2
    } 
        
    .arrl.graph element create "l$i" \
	    -xdata gridx{$i} -ydata gridy{$i} \
	    -color cyan \
	    -label "" \
	    -symbol "none" -linewidth $widthofline
}


while {$scale > 10} {
    set thisstep [lindex $arrlsteps $counter]
    set counter [expr $counter + 1]
    vector xarrl{$counter} (361)
    vector yarrl{$counter}(361)
    set scale [expr $originalscale - $thisstep ]
    xarrl{$counter} set [yDB * $scale]
    yarrl{$counter}  set [xDB *  $scale]
    #set up the data on the graph
    for {set i 0} {$i <= 360} {incr i 1} {
	set yarrl{$counter}($i) [expr exp(0.43439/0.98*$scale/10.0) * $yDB($i)]
	set xarrl{$counter}($i) [expr exp(0.43439/0.98*$scale/10.0) * $xDB($i)]
    }
    .arrl.graph element create "e$scale" -label "-$thisstep DB" \
	    -xdata xarrl{$counter} -ydata yarrl{$counter} \
	    -color blue \
	    -symbol "none"
    
}


    

#  end of linear ARRL coordinate window
##########################################################




##################  The Factlist window

toplevel .facts
raise .facts
wm title .facts "Fact List"
wm geometry .facts +200+200
wm iconname .facts "Facts"
raise .facts
lower .


frame .facts.controls
frame .facts.text

pack .facts.text .facts.controls

button .facts.controls.quit -text "Quit" -command {exit }

pack .facts.controls.quit  -in .facts.controls


listbox .facts.text.box -width 70 -yscrollcommand ".facts.text.scroller set" \
	-background white
scrollbar .facts.text.scroller -command ".facts.text.box  yview" \
	-background blue

pack .facts.text.box .facts.text.scroller -fill y -in .facts.text -side left



.facts.text.box insert end "Maximum gain is $maxgain"
.facts.text.box insert end ""
.facts.text.box insert end "Maximum gain occurs at these angles: $maxangles"
.facts.text.box insert end ""
.facts.text.box insert end "gain at 180 degrees is $gain(180)"
.facts.text.box insert end ""

.facts.text.box insert end "Here is a list of the feed points wire tags, with impedances and SWR"

   .facts.text.box insert end "tag number              complex impedance           |Z|           SWR"

foreach ofthetag $taglist {

    set indexnumber   [lsearch $taglist $ofthetag] 
    set ZR [lindex $Zrlist  $indexnumber]
    set ZI [lindex $Zilist  $indexnumber]
    set Zed [lindex $Zlist  $indexnumber]
    set SWR [lindex $SWRlist  $indexnumber]
   .facts.text.box insert end "$indexnumber               $ZR + $ZI * j     $Zed    $SWR - 1"
    
        
}




