/* Zgv v3.1 - GIF, JPEG and PBM/PGM/PPM viewer, for VGA PCs running Linux.
 * Copyright (C) 1993-1998 Russell Marks. See README for license details.
 *
 * rbmenu.c - routines for right-button menus.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <vga.h>
#include <vgagl.h>
#include "font.h"
#include "zgv.h"	/* needed for vga_setcolor() macro, for text */
#include "rbmenu.h"


/* nicked from vgadisp.c :-) */
#define GET15BITCOLOUR(r,g,b) ((((r)&0xf8)<<7)|(((g)&0xf8)<<2)|((b)>>3))
#define GET16BITCOLOUR(r,g,b) ((((r)&0xf8)<<8)|(((g)&0xfc)<<3)|((b)>>3))


/* (x,y) positions of buttons (i.e. two ints for each button),
 * and number of pairs in `array'.
 */
static int *button_positions=NULL;
static int button_ents=0;
static int button_panel_x=0,button_panel_y=0,button_panel_w=0,button_panel_h=0;
static int button_div_x=1;	/* 2 if in 360x480 mode */



/* in 15/16/24-bit, can't use vga_setcolor(), so we have a routine
 * to take care of that.
 * (in theory this would be better off as a macro, but we assume
 * it's inlined by gcc.)
 */
static inline void setcolour(int col)
{
if(vga_getcolors()<=256)
  vga_setcolor(col);
else
  vga_setrgbcolor((col>>16)&255,(col>>8)&255,col&255);
}


/* hacked version of draw3dbox from 3deffects.c;
 * we need our own version due to vga_setcolor probs (see above)
 */
static void rbm_draw3dbox(int x1,int y1,int x2,int y2,int depth,
                          int isout,int lite,int dark)
{
int f;

for(f=0;f<depth;f++)
  {
  setcolour(isout?lite:dark);
  vga_drawline(x1+f,y2-f,x1+f,y1+f);
  vga_drawline(x1+f,y1+f,x2-f,y1+f);
  setcolour(isout?dark:lite);
  vga_drawline(x2-f,y1+f,x2-f,y2-f);
  vga_drawline(x2-f,y2-f,x1+f,y2-f);
  }
}



/* work out number of entries */
static int rbm_num_ents(struct rbm_data_tag menu_data[])
{
int num_ents;

for(num_ents=0;*(menu_data[num_ents].label)!=0;num_ents++) ;
return(num_ents);
}


/* return size of overall menu panel
 * (position of panel is implicitly `top-right-of-screen')
 */
void rbm_xysize(struct rbm_data_tag menu_data[],int *wp,int *hp)
{
int num_ents=rbm_num_ents(menu_data);

/* work out how wide the menu panel needs to be. We start from the top of
 * the screen filling downwards, shifting that part of the menu across to
 * the left to make room for any more entries.
 * (the panel height is fixed (makes things easier) at 480 pixels.)
 */
*hp=RBM_HEIGHT;
*wp=((num_ents+RBM_MAXENTRIES_Y-1)/RBM_MAXENTRIES_Y)*
	(RBM_ENTRY_WIDTH+RBM_LEFT_XSKIP)+RBM_RIGHT_XSKIP;
if(vga_getcurrentmode()==G360x480x256)
  (*wp)/=2;
}


void rbm_draw(struct rbm_data_tag menu_data[],
	int light,int medium,int dark,int black)
{
static unsigned char linebuf[640];
int *button_pos_ptr;
int num_ents=rbm_num_ents(menu_data);
int f,y;
int panel_x,panel_y,panel_w,panel_h,entry_x,entry_y;
int scrn_w=vga_getxdim();
int mode=vga_getcurrentmode();

/* get rid of any old malloced space
 * (not clear if this is more sensible than resizing it, but it's easier :-))
 */
if(button_positions!=NULL) free(button_positions);

if((button_positions=malloc(sizeof(int)*2*num_ents))==NULL)
  return;

button_ents=num_ents;

rbm_xysize(menu_data,&panel_w,&panel_h);
panel_x=scrn_w-panel_w; panel_y=0;

/* we also need to store panel_[xywh] for later use */
button_panel_x=panel_x;
button_panel_y=panel_y;
button_panel_w=panel_w;
button_panel_h=panel_h;
button_div_x=((mode==G360x480x256)?2:1);

/* draw basic empty panel */
switch(mode)
  {
  /* for 16-colour and 8-bit generic-VGA, don't use vgagl */
  case G640x480x16:
  case G320x200x256: case G320x240x256:
  case G320x400x256: case G360x480x256:
    memset(linebuf,medium,scrn_w);
    for(y=0;y<panel_h;y++)
      vga_drawscansegment(linebuf,panel_x,panel_y+y,panel_w);
    break;
  
  /* otherwise use vgagl */
  default:
    /* should be current context already, but it doesn't hurt to make sure */
    gl_setcontextvga(vga_getcurrentmode());
    
    switch(vga_getcolors())
      {
      case 32768:
        /* this looks dodgy, but check the macro def. and you'll see
         * why I've done it like this.
         */
        medium=GET15BITCOLOUR(medium>>16,medium>>8,medium&255);
        gl_fillbox(panel_x,panel_y,panel_w,panel_h,medium);
        break;
      case 65536:
        medium=GET16BITCOLOUR(medium>>16,medium>>8,medium&255);
        /* FALLS THROUGH */
      default:		/* 8-bit or 24-bit */
        /* input is ok for these two depths already */
        gl_fillbox(panel_x,panel_y,panel_w,panel_h,medium);
      }
  }

/* draw edge */
rbm_draw3dbox(panel_x,panel_y,panel_x+panel_w-1,panel_y+panel_h-1,
		3,1,light,dark);

/* now draw the buttons on it. */
entry_x=panel_x+RBM_LEFT_XSKIP/button_div_x;
entry_y=panel_y+RBM_TOP_YSKIP;
button_pos_ptr=button_positions;

for(f=0;f<num_ents;f++)
  {
  /* skip any with label "-", which just provide a gap. */
  if(strcmp(menu_data[f].label,"-")!=0)
    {
    rbm_draw3dbox(entry_x,entry_y,
    	entry_x+RBM_ENTRY_WIDTH/button_div_x-1,entry_y+RBM_ENTRY_HEIGHT-1,
        1,1,light,dark);
    setcolour(menu_data[f].active?black:dark);
    vgadrawtext(entry_x+RBM_TEXT_XSKIP/button_div_x,entry_y+RBM_TEXT_YSKIP,3,
    	menu_data[f].label);
    }
  
  *button_pos_ptr++=entry_x;
  *button_pos_ptr++=entry_y;
  
  entry_y+=RBM_ENTRY_HEIGHT;
  if(f%RBM_MAXENTRIES_Y==RBM_MAXENTRIES_Y-1)
    {
    entry_x+=(RBM_ENTRY_WIDTH+RBM_LEFT_XSKIP)/button_div_x;
    entry_y=panel_y+RBM_TOP_YSKIP;
    }
  }
}


int rbm_mousepos_to_key(struct rbm_data_tag menu_data[],int mx,int my)
{
int *button_pos_ptr;
int f,x,y;

if(button_positions==NULL || button_ents==0)
  return(0);

button_pos_ptr=button_positions;

/* if they clicked off the panel, should quit with no effect */
if(mx<button_panel_x || mx>=button_panel_x+button_panel_w ||
   my<button_panel_y || my>=button_panel_y+button_panel_h)
  return(-1);

for(f=0;f<button_ents;f++)
  {
  x=*button_pos_ptr++;
  y=*button_pos_ptr++;
  if(mx>=x && mx<x+RBM_ENTRY_WIDTH/button_div_x &&
     my>=y && my<y+RBM_ENTRY_HEIGHT &&
     menu_data[f].active)
    return(menu_data[f].key);
  }

/* no match */
return(0);
}


/* set/reset active flag on first entry with label containing substr */
void rbm_set_active_flag(struct rbm_data_tag menu_data[],
	char *substr,int active)
{
int f;

for(f=0;*(menu_data[f].label)!=0;f++)
  {
  if(strstr(menu_data[f].label,substr))
    {
    menu_data[f].active=active;
    return;
    }
  }
}
