/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _TIMER_H
#define _TIMER_H

#include <sys/time.h>

//#ifdef HAVE_SYS_TIMES_H
//#include <sys/times.h>
//#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif


/*
 *  MathFunctions: general purpose math functions 
 */
class Timer
	{
	public: 
		static void		msleep (long n); 	// microseconds
		struct timeval		*getElapsedTime ();
		float			getElapsedSeconds ();
		void			start (); 
		void			stop ();

	private:
		struct timeval		d_startTime,
					d_stopTime, 
					d_elapsedTime;
	};

#endif // _TIMER_H
