/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _TF_WINDOW_HANDLER_H
#define _TF_WINDOW_HANDLER_H 1


#include "GuiDialogOAC.h" 		// include GuiDialogOAC, gtk, gtk--
#include "GuiDialogReallyQuit.h"
#include "GuiDialogAbout.h"
#include "HeightField.h"
#include "HeightFieldDraw.h"
#include "TFBaseDialog.h"
#include "TFDialogOptions.h"
#include "TFPreviewDialog.h"
#include "TFWindow.h"
#include "TFWindowBase.h"
#include "TFWindowHandler.h"
#include "glib--glist.h"

#ifdef HAVE_OPENGL
#include "TFWindowOpenGL.h"
#endif



/*
 *  TFWindowHandler: extend TFWindow with proper callbacks & services. 
 *	Also extend TFWindowBase to inherit the shared dialogs 
 */
class TFWindowHandler : public TFWindow, public TFWindowBase
	{
	public: 
				TFWindowHandler (FlexArray *wList);
				~TFWindowHandler ();
		void		setHeightField (HeightField *HF);
		void		drawHeightField ();
		gint		idleRedrawCallback ();
		gint		autoRotateCallback ();
		gint		calibrateAutoRotate (int nSamples);
		static gint	waitForChildrenCallback ();

		virtual void	fileMenuCallback (string m);
		virtual void	hfMenuCallback (string m);
		virtual void	viewMenuCallback (string m);
		virtual void	colormapMenuCallback (string m);

		void		destroyCallback ();
		void		closeCallback ();
		void		reloadCallback ();

		void		fileSelectionOK ();
		void		fileSelectionCancel ();
		void		fileSelection ();

		void		checkMenus ();
		void		activateMenus (bool activate);
		gint 		button_press_event_impl (GdkEventButton *e);
		gint 		button_release_event_impl (GdkEventButton *e);
		gint 		motion_notify_event_impl (GdkEventMotion *e);
		gint 		delete_event_impl (GdkEventAny *e);

		HeightField	*getHeightField ()	{ return p_HF; }
		HeightFieldDraw	*getHeightFieldDraw ()	{ return p_HFD; }

	private: 	
		HeightField		*p_HF;
		HeightFieldDraw		*p_HFD;
		Gtk_FileSelection 	*p_fileSelection;
		GuiDialogOAC		*p_genSSynthDialog,
					*p_genSubdivDialog,
					*p_placePovDialog,
					*p_renderDialog;
		TFBaseDialog		*p_contLinesDialog,
					*p_erodeDialog,
					*p_flowmapDialog,
					*p_rescaleDialog;
		TFPreviewDialog		*p_cratersDialog,
					*p_fillDialog,
					*p_foldDialog,
					*p_gaussHillDialog,
					*p_linearScaleDialog,
					*p_mirrorDialog,
					*p_roughSmoothDialog, 
					*p_terraceDialog,
					*p_transformDialog,
					*p_rotateDialog; 	
#ifdef HAVE_OPENGL
		TFWindowOpenGL		*p_openGLWindow;
#endif
		int			d_rotStartPosx,
					d_rotStartPosy;
		bool			d_fastWire,
					d_rotate,
					d_autoRotate;
	};


#endif // _TF_WINDOW_HANDLER_H
