/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _TF_DIALOG_RENDER_H
#define _TF_DIALOG_RENDER_H 1


#include "GuiDialogOAC.h"			// includes gtk, gtk--
#include "GuiBufferedDrawingArea.h"
#include "HeightFieldDraw.h"


#define MENU_LIGHTING_PLASTIC		"Plastic Model"
#define MENU_LIGHTING_REALSKY		"Real Sky"
#define MENU_LIGHTING_SUNBEAMS_F	"Real Sky with Sunbeams (Fast)"
#define MENU_LIGHTING_SUNBEAMS_S	"Real Sky with Sunbeams (Slow)"



/*
 *  TFDialogRender: display the render options dialog (for Ray)
 */
class TFDialogRender : public GuiDialogOAC
	{
	public:	
				TFDialogRender (HeightField *HF, HeightFieldDraw *HF);
				~TFDialogRender ();
		void		setHFobjs (HeightField *HF, HeightFieldDraw *HFD);
		void		previewUpToDate ();
		void		buildDialogWindow ();
		void 		buttonCallbackApply ();
		//void		handleDAExposeEvent (GtkNotebookPage *p1, guint p2);
		gint		handleDAExposeEvent (GdkEventExpose *e);
		gint		daButtonPressedCallback (GdkEventButton *e);
		gint 		delete_event_impl (GdkEventAny *e);

	protected:
		void		buildPositionFrame ();
		void		buildEnvironmentFrame ();
		void		buildPOVOptionsFrame ();

	private:
		void		fillVBox ();
		void		getValues ();
		void		setValues ();

		// had to make alloc of HBox and VBox dynamic to avoid running
		// into the huge-objects warning with egcs
		HeightField		*p_HF,
					*p_HFPreview;
		HeightFieldDraw		*p_HFD,
					*p_HFDPreview;
		GuiBufferedDrawingArea	*p_da;
		time_t			d_hfTimestamp;
		Gtk_Notebook		d_notebook;	
		Gtk_Frame 		d_frame1, d_frame2, d_frame3;
		Gtk_CheckButton		d_cbObserveSealevel,
					d_cbKeepFiles,
					d_cbAutoRender,	// no equivalent in RenderOptions 
					d_cbHaveClouds,
					d_cbHaveFog,
					d_cbSmooth,
					d_cbhalfYscale,
					d_cbkeepFiles;
		Gtk_Entry		d_enPosX, d_enPosY, d_enPosZ,
					d_enLookAtX, d_enLookAtY, d_enLookAtZ;
		Gtk_VBox		*p_vb2, *p_vb3, *p_vb1_1, *p_vb1_2;
		Gtk_HBox		*p_hb1, *p_hb1_0, *p_hb1_1, 
					*p_hb1_2, *p_hb1_3, *p_hb1_4, *p_hb1_5,
					*p_hb2_1, *p_hb2_2, *p_hb2_3, *p_hb2_4, 
					*p_hb3_1, *p_hb3_2, *p_hb3_3, *p_hb3_4;
		Gtk_Label 		*p_lblTitle1, *p_lblTitle2, 
					*p_lblTitle3, *p_lblCamera, 
					*p_lblElvSealevel, *p_lblElvOffset,
					*p_lblLookAt, *p_lblSkySettings, 
					*p_lblWaterClarity, *p_lblEnvironment,
					*p_lblFastYscale, *p_lblRoughness,
					*p_lblfileName, *p_lblwidth, 
					*p_lbllightning, *p_lblkeepFiles;
		Gtk_Adjustment		*p_adjWaterClarity, *p_adjwidth,
					*p_adjTimeOfDay, *p_adjNorthDir,
					*p_adjVerticalOffset;
		Gtk_HScale		*p_hsWaterClarity, *p_hswidth; 
		Gtk_SpinButton		*p_spbTimeOfDay, *p_spbNorthDir, 
					*p_spbVerticalOffset;
		Gtk_Combo		*p_cmbLighting,
					*p_cmbTemplateFile;
		GList			*p_glstLighting,
					*p_glstTemplateFile;
	};

#endif // _TF_DIALOG_RENDER_H
