/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _TF_DIALOG_PLACE_POV_H
#define _TF_DIALOG_PLACE_POV_H 1


#include "GuiDialogOAC.h"				// includes gtk, gtk--
#include "HeightFieldOps.h"


/*
 *  TFDialogPPov: display the roughen dialog for terraformer
 */
class TFDialogPPov : public GuiDialogOAC
	{
	public: 
				TFDialogPPov (HeightField *HF);
				~TFDialogPPov (); 
		void		setHF (HeightField *HF);
		void		buildDialogWindow ();
		void 		buttonCallbackApply ();

	private:
		void		fillVBox ();
		gint 		delete_event_impl (GdkEventAny *);

		HeightField		*d_HF;
		HeightFieldOps		*d_HFO;
		Gtk_VBox		d_vbList,
					d_vb;
		Gtk_HBox		d_hb1, d_hb2, d_hb3, 
					d_hb4, d_hb5, d_hb6, d_hb7;
		Gtk_Entry		d_enOutputFilename, d_enObjectName;

		Gtk_Label		*p_lblLine1, *p_lblLine2, *p_lblLine3, 
					*p_lblLine4, *p_lblLine5, *p_lblLine6, *p_lblLine7,
					*p_lblOutputFilename, 
					*p_lblObjectName, 
					*p_lblHFScaleX, *p_lblHFScaleY, *p_lblHFScaleZ,
					*p_lblObjMinElv, *p_lblObjMaxElv, 
					*p_lblPlaceDensity, *p_lblPlaceVariance, 
					*p_lblObjScaleX, *p_lblObjScaleY, *p_lblObjScaleZ,
					*p_lblObjScaleXvar, *p_lblObjScaleYvar, *p_lblObjScaleZvar;

		Gtk_Adjustment 		*p_adjHFScaleX, *p_adjHFScaleY, *p_adjHFScaleZ,
					*p_adjObjMinElv, *p_adjObjMaxElv, 
					*p_adjPlaceDensity, *p_adjPlaceVariance, 
					*p_adjObjScaleX, *p_adjObjScaleY, *p_adjObjScaleZ,
					*p_adjObjScaleXvar, *p_adjObjScaleYvar, *p_adjObjScaleZvar;

		Gtk_HScale		*p_hsHFScaleX, *p_hsHFScaleY, *p_hsHFScaleZ,
					*p_hsObjMinElv, *p_hsObjMaxElv, 
					*p_hsPlaceDensity, *p_hsPlaceVariance, 
					*p_hsObjScaleX, *p_hsObjScaleY, *p_hsObjScaleZ,
					*p_hsObjScaleXvar, *p_hsObjScaleYvar, *p_hsObjScaleZvar;
	};


#endif // _TF_DIALOG_PLACE_POV_H
