/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "TFDialogPPov.h"
#include "TFOptions.h"
#include "GlobalSanityCheck.h"
#include "GlobalTrace.h"


/*
 *  constructor: initialize all data members 
 */
TFDialogPPov::TFDialogPPov (HeightField *HF)
	        : GuiDialogOAC ("Terraform Place POV Object Dialog", 
				"POV object placement parameters"), 
		  d_vbList (TRUE, 5),
		  d_vb (FALSE, 5),
		  d_hb1 (FALSE, 5), 
		  d_hb2 (FALSE, 5), 
		  d_hb3 (FALSE, 5),
		  d_hb4 (FALSE, 5), 
		  d_hb5 (FALSE, 5), 
		  d_hb6 (FALSE, 5),
		  d_hb7 (FALSE, 5) 
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ TFDialogPPov\n");

	SanityCheck::bailout ((!HF), "HF==NULL", "TFDialogPPov::TFDialogPPov");

	p_lblLine1 = new Gtk_Label ("Output Options");
	p_lblLine2 = new Gtk_Label ("Elevation");
	p_lblLine3 = new Gtk_Label ("Placement");
	p_lblLine4 = new Gtk_Label ("HF Scale");
	p_lblLine5 = new Gtk_Label ("Obj Scale");
	p_lblLine6 = new Gtk_Label ("Scale Variance");
	p_lblLine7 = new Gtk_Label ("");
	p_lblOutputFilename = new Gtk_Label ("Filename");
	p_lblObjectName = new Gtk_Label ("POV Object Name");
	p_lblHFScaleX = new Gtk_Label ("X");
	p_lblHFScaleY = new Gtk_Label ("Y");
	p_lblHFScaleZ = new Gtk_Label ("Z");
	p_lblObjMinElv = new Gtk_Label ("Min");
	p_lblObjMaxElv = new Gtk_Label ("Max");
	p_lblPlaceDensity = new Gtk_Label ("Density");
	p_lblPlaceVariance = new Gtk_Label ("Variance");
	p_lblObjScaleX = new Gtk_Label ("X");
	p_lblObjScaleY = new Gtk_Label ("Y");
	p_lblObjScaleZ = new Gtk_Label ("Z");
	p_lblObjScaleXvar = new Gtk_Label ("X");
	p_lblObjScaleYvar = new Gtk_Label ("Y");
	p_lblObjScaleZvar = new Gtk_Label ("Z");

	p_adjHFScaleX = new Gtk_Adjustment (100, 10, (TFOptions::s_large ? 20000 : 1000), 1);
	p_adjHFScaleY = new Gtk_Adjustment (250, 50, 5000, 1);
	p_adjHFScaleZ = new Gtk_Adjustment (1000, 100, 10000, 1);
	p_adjObjMinElv = new Gtk_Adjustment (0.66, 0.0, 1.0, 0.01);
	p_adjObjMaxElv = new Gtk_Adjustment (0.95, 0.0, 1.0, 0.01);
	p_adjPlaceDensity = new Gtk_Adjustment (0.5, 0.0, 1.0, 0.01);
	p_adjPlaceVariance = new Gtk_Adjustment (0.5, 0.0, 1.0, 0.01);
	p_adjObjScaleX = new Gtk_Adjustment (5, 1, 25, 1);
	p_adjObjScaleY = new Gtk_Adjustment (20, 1, 250, 1);
	p_adjObjScaleZ = new Gtk_Adjustment (5, 1, 25, 1);
	p_adjObjScaleXvar = new Gtk_Adjustment (0.33, 0.0, 1.0, 0.01);
	p_adjObjScaleYvar = new Gtk_Adjustment (0.33, 0.0, 1.0, 0.01);
	p_adjObjScaleZvar = new Gtk_Adjustment (0.33, 0.0, 1.0, 0.01);

	p_hsHFScaleX = new Gtk_HScale (*p_adjHFScaleX);
	p_hsHFScaleY = new Gtk_HScale (*p_adjHFScaleY);
	p_hsHFScaleZ = new Gtk_HScale (*p_adjHFScaleZ);
	p_hsObjMinElv = new Gtk_HScale (*p_adjObjMinElv);
	p_hsObjMaxElv = new Gtk_HScale (*p_adjObjMaxElv);
	p_hsPlaceDensity = new Gtk_HScale (*p_adjPlaceDensity);
	p_hsPlaceVariance = new Gtk_HScale (*p_adjPlaceVariance);
	p_hsObjScaleX = new Gtk_HScale (*p_adjObjScaleX);
	p_hsObjScaleY = new Gtk_HScale (*p_adjObjScaleY);
	p_hsObjScaleZ = new Gtk_HScale (*p_adjObjScaleZ);
	p_hsObjScaleXvar = new Gtk_HScale (*p_adjObjScaleXvar);
	p_hsObjScaleYvar = new Gtk_HScale (*p_adjObjScaleYvar);
	p_hsObjScaleZvar = new Gtk_HScale (*p_adjObjScaleZvar);

	d_HFO = NULL;
	this->setHF (HF);
	sprintf (this->p_windowTitle, _("Place POV Object: %s"), d_HF->getName());
	buildDialogWindow ();
}


/*
 *  destructor: clean up 
 */
TFDialogPPov::~TFDialogPPov ()
{
	delete p_lblLine1;
	delete p_lblLine2;
	delete p_lblLine3;
	delete p_lblLine4;
	delete p_lblLine5;
	delete p_lblLine6;
	delete p_lblLine7;
	delete p_lblOutputFilename;
	delete p_lblObjectName;
	delete p_lblHFScaleX;
	delete p_lblHFScaleY;
	delete p_lblHFScaleZ;
	delete p_lblObjMinElv;
	delete p_lblObjMaxElv;
	delete p_lblPlaceDensity;
	delete p_lblPlaceVariance;
	delete p_lblObjScaleX;
	delete p_lblObjScaleY;
	delete p_lblObjScaleZ;
	delete p_lblObjScaleXvar;
	delete p_lblObjScaleYvar;
	delete p_lblObjScaleZvar;

	delete p_adjHFScaleX;
	delete p_adjHFScaleY;
	delete p_adjHFScaleZ;
	delete p_adjObjMinElv;
	delete p_adjObjMaxElv;
	delete p_adjPlaceDensity;
	delete p_adjPlaceVariance;
	delete p_adjObjScaleX;
	delete p_adjObjScaleY;
	delete p_adjObjScaleZ;
	delete p_adjObjScaleXvar;
	delete p_adjObjScaleYvar;
	delete p_adjObjScaleZvar;

	delete p_hsHFScaleX;
	delete p_hsHFScaleY;
	delete p_hsHFScaleZ;
	delete p_hsObjMinElv;
	delete p_hsObjMaxElv;
	delete p_hsPlaceDensity;
	delete p_hsPlaceVariance;
	delete p_hsObjScaleX;
	delete p_hsObjScaleY;
	delete p_hsObjScaleZ;
	delete p_hsObjScaleXvar;
	delete p_hsObjScaleYvar;
	delete p_hsObjScaleZvar;

	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- TFDialogPPov\n");
}


/*
 *  setHFobjs: set the HF objects we operate on
 */
void TFDialogPPov::setHF (HeightField *HF)
{
	SanityCheck::bailout ((!HF), "HF==NULL", "TFDialogPPov::setHFobjs");

	if (d_HFO)
                delete d_HFO;

	d_HF = HF;
	d_HFO = new HeightFieldOps (d_HF);
}


/*
 *  fillVBox: fill the dialog's VBox
 */
void TFDialogPPov::fillVBox ()
{
	int 	s_HBOff = 1,	// hbox offset
		expand=TRUE, 
		fill=FALSE;

	SanityCheck::bailout ((!this->p_frmBase), "TFDialogPPov called without Frame label",
		"TFDialogPPov::setHF");

	//d_hb1.pack_start (p_lblLine1, expand, TRUE, s_HBOff);
	//p_lblLine1->show ();
	d_hb1.pack_start (*p_lblOutputFilename, expand, fill, s_HBOff);
	p_lblOutputFilename->show ();
	d_hb1.pack_start (d_enOutputFilename, expand, fill+1, s_HBOff);
	d_enOutputFilename.set_text ("hfpovobj.inc");
	d_enOutputFilename.show ();
	d_hb1.pack_start (*p_lblObjectName, expand, fill, s_HBOff);
	p_lblObjectName->show ();
	d_hb1.pack_start (d_enObjectName, expand, fill+1, s_HBOff);
	d_enObjectName.set_text ("pov_object");
	d_enObjectName.show ();
	d_vbList.pack_start (d_hb1, TRUE, TRUE, s_VBOff);
	d_hb1.show ();

	d_hb2.pack_start (*p_lblLine2, expand, TRUE, s_HBOff);
	p_lblLine2->show ();
	d_hb2.pack_start (*p_lblObjMinElv, expand, fill, s_HBOff);
	p_lblObjMinElv->show ();
	d_hb2.pack_start (*p_hsObjMinElv, expand, fill+1, s_HBOff);
	p_hsObjMinElv->set_digits (2);
	p_hsObjMinElv->show ();
	d_hb2.pack_start (*p_lblObjMaxElv, expand, fill, s_HBOff);
	p_lblObjMaxElv->show ();
	d_hb2.pack_start (*p_hsObjMaxElv, expand, fill+1, s_HBOff);
	p_hsObjMaxElv->set_digits (2);
	p_hsObjMaxElv->show ();
	d_vbList.pack_start (d_hb2, TRUE, TRUE, s_VBOff);
	d_hb2.show ();

	d_hb3.pack_start (*p_lblLine3, expand, TRUE, s_HBOff);
	p_lblLine3->show ();
	d_hb3.pack_start (*p_lblPlaceDensity, expand, fill, s_HBOff);
	p_lblPlaceDensity->show ();
	d_hb3.pack_start (*p_hsPlaceDensity, expand, fill+1, s_HBOff);
	p_hsPlaceDensity->set_digits (2);
	p_hsPlaceDensity->show ();
	d_hb3.pack_start (*p_lblPlaceVariance, expand, fill, s_HBOff);
	p_hsPlaceVariance->set_digits (2);
	p_lblPlaceVariance->show ();
	d_hb3.pack_start (*p_hsPlaceVariance, expand, fill+1, s_HBOff);
	p_hsPlaceVariance->show ();
	d_vbList.pack_start (d_hb3, TRUE, TRUE, s_VBOff);
	d_hb3.show ();

	d_hb4.pack_start (*p_lblLine4, expand, TRUE, s_HBOff);
	p_lblLine4->show ();
	d_hb4.pack_start (*p_lblHFScaleX, expand, fill, s_HBOff);
	p_lblHFScaleX->show ();
	d_hb4.pack_start (*p_hsHFScaleX, expand, fill+1, s_HBOff);
	p_hsHFScaleX->set_digits (0);
	p_hsHFScaleX->show ();
	d_hb4.pack_start (*p_lblHFScaleY, expand, fill, s_HBOff);
	p_hsHFScaleY->set_digits (0);
	p_lblHFScaleY->show ();
	d_hb4.pack_start (*p_hsHFScaleY, expand, fill+1, s_HBOff);
	p_hsHFScaleY->show ();
	d_hb4.pack_start (*p_lblHFScaleZ, expand, fill, s_HBOff);
	p_lblHFScaleZ->show ();
	d_hb4.pack_start (*p_hsHFScaleZ, expand, fill+1, s_HBOff);
	p_hsHFScaleZ->set_digits (0);
	p_hsHFScaleZ->show ();
	d_vbList.pack_start (d_hb4, TRUE, TRUE, s_VBOff);
	d_hb4.show ();

	d_hb5.pack_start (*p_lblLine5, expand, TRUE, s_HBOff);
	p_lblLine5->show ();
	d_hb5.pack_start (*p_lblObjScaleX, expand, fill, s_HBOff);
	p_lblObjScaleX->show ();
	d_hb5.pack_start (*p_hsObjScaleX, expand, fill+1, s_HBOff);
	p_hsObjScaleX->set_digits (0);
	p_hsObjScaleX->show ();
	d_hb5.pack_start (*p_lblObjScaleY, expand, fill, s_HBOff);
	p_lblObjScaleY->show ();
	p_hsObjScaleY->set_digits (0);
	d_hb5.pack_start (*p_hsObjScaleY, expand, fill+1, s_HBOff);
	p_hsObjScaleY->show ();
	d_hb5.pack_start (*p_lblObjScaleZ, expand, fill, s_HBOff);
	p_hsObjScaleZ->set_digits (0);
	p_lblObjScaleZ->show ();
	d_hb5.pack_start (*p_hsObjScaleZ, expand, fill+1, s_HBOff);
	p_hsObjScaleZ->show ();
	d_vbList.pack_start (d_hb5, TRUE, TRUE, s_VBOff);
	d_hb5.show ();

	d_hb6.pack_start (*p_lblLine6, expand, TRUE, s_HBOff);
	p_lblLine6->show ();
	d_hb6.pack_start (*p_lblObjScaleXvar, expand, fill, s_HBOff);
	p_lblObjScaleXvar->show ();
	d_hb6.pack_start (*p_hsObjScaleXvar, expand, fill+1, s_HBOff);
	p_hsObjScaleXvar->show ();
	d_hb6.pack_start (*p_lblObjScaleYvar, expand, fill, s_HBOff);
	p_lblObjScaleYvar->show ();
	d_hb6.pack_start (*p_hsObjScaleYvar, expand, fill+1, s_HBOff);
	p_hsObjScaleYvar->show ();
	d_hb6.pack_start (*p_lblObjScaleZvar, expand, fill, s_HBOff);
	p_lblObjScaleZvar->show ();
	d_hb6.pack_start (*p_hsObjScaleZvar, expand, fill+1, s_HBOff);
	p_hsObjScaleZvar->show ();
	d_vbList.pack_start (d_hb6, TRUE, TRUE, s_VBOff);
	d_hb6.show ();

	this->p_frmBase->add (d_vbList);
	d_vbList.show ();
	this->p_frmBase->show ();
	this->get_vbox()->show ();
}



void TFDialogPPov::buildDialogWindow ()
{
	this->set_usize (500, 300);
	this->set_title (this->p_windowTitle);

	this->get_vbox()->set_border_width (2);

	this->setupVBox ();
	fillVBox ();
	this->fillActionArea ();
	
	this->show ();
}


/*
 *  buttonCallbackApply: transform the height field
 */
void TFDialogPPov::buttonCallbackApply ()
{
	char 		*outfile, 
			*object;
	int		hfsx, hfsy, hfsz, 
			osx, osy, osz;
	float		floor, ceil,
			density, pvar, 
			osxvar, osyvar, oszvar;

	outfile = const_cast<char*>(d_enOutputFilename.get_text().c_str());
	object = const_cast<char*> (d_enObjectName.get_text().c_str());	
	hfsx = (int)(p_adjHFScaleX->get_value());
	hfsy = (int)(p_adjHFScaleY->get_value());
	hfsz = (int)(p_adjHFScaleZ->get_value());
	floor = p_adjObjMinElv->get_value();
	ceil = p_adjObjMaxElv->get_value();
	density = p_adjPlaceDensity->get_value();
	pvar = p_adjPlaceVariance->get_value();
	osx = (int)(p_adjObjScaleX->get_value());
	osy = (int)(p_adjObjScaleY->get_value());
	osz = (int)(p_adjObjScaleZ->get_value());
	osxvar = p_adjObjScaleXvar->get_value();
	osyvar = p_adjObjScaleYvar->get_value();
	oszvar = p_adjObjScaleZvar->get_value();

	cout << "Names: " << outfile << ", " << object << "\n"; 
	//exit (0);

	SanityCheck::bailout ((!d_HFO), "d_HFO==NULL", "TFDialogRotate::buttonCallbackApply");
	d_HFO->placePOVObject (outfile, object, 
			hfsx, hfsy, hfsz, 
			floor, ceil, density, pvar,
			osx, osy, osz, osxvar, osyvar, oszvar, 0);
	this->b_applyHit = TRUE;
}


gint TFDialogPPov::delete_event_impl (GdkEventAny *e)
{
	this->hide ();
	return (0);
}

