/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "TFDialogMirror.h"
#include "GuiDialogOAC.h"
#include "GlobalDefs.h"
#include "GlobalSanityCheck.h"
#include "GlobalTrace.h"


/*
 *  constructor: initialize all data members 
 */
TFDialogMirror::TFDialogMirror (HeightField *HF, HeightFieldDraw *HFD)
	        : TFPreviewDialog (HF, HFD, "Terraform Mirror Dialog", 
				"Mirror along which Axis", 6, 4),
		  d_vBoxOptions (TRUE, 5),
		  d_frmOptions ("Mirror Type")
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ TFDialogMirror\n");
	p_RB1 = p_RB2 = p_RB3 = p_RB4 = NULL;
	p_group = NULL;
	buildDialogWindow ();
	this->setHFobjs (HF, HFD);
	sprintf (this->p_windowTitle, _("Mirror: %s"), p_HF->getName());
	this->set_title (this->p_windowTitle);
	this->iterateEvents ();
	updatePreviewCallback ();

	connect_to_method (p_RB1->clicked, this, &TFDialogMirror::updatePreviewCallback);
	connect_to_method (p_RB2->clicked, this, &TFDialogMirror::updatePreviewCallback);
	connect_to_method (p_RB3->clicked, this, &TFDialogMirror::updatePreviewCallback);
	connect_to_method (p_RB4->clicked, this, &TFDialogMirror::updatePreviewCallback);

}


/*
 *  destructor: clean up 
 */
TFDialogMirror::~TFDialogMirror ()
{
	if (p_RB1) delete p_RB1;
	if (p_RB2) delete p_RB2;
	if (p_RB3) delete p_RB3;
	if (p_RB4) delete p_RB4;

	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- TFDialogMirror\n");
}


/*
 *  fillVBox: fill the dialog's VBox
 */
void TFDialogMirror::insertOptions()
{
	d_frmOptions.set_shadow_type (GTK_SHADOW_ETCHED_IN);
	d_frmOptions.set_border_width (5);

	p_RB1 = new Gtk_RadioButton ((GSList *)NULL, _("Horizonal Axis (-)"));
	p_RB1->set_active(TRUE);
	d_vBoxOptions.pack_start (*p_RB1, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	p_RB1->show ();

	p_group = p_RB1->group ();
	p_RB2 = new Gtk_RadioButton (p_group, _("Vertical Axis (|)"));
	d_vBoxOptions.pack_start (*p_RB2, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	p_RB2->show ();

	p_group = p_RB2->group ();
	p_RB3 = new Gtk_RadioButton (p_group, _("Top Left - Bottom Right (\\)"));
	d_vBoxOptions.pack_start (*p_RB3, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	p_RB3->show ();

	p_group = p_RB3->group ();
	p_RB4 = new Gtk_RadioButton (p_group, _("Bottom Left - Top Right (/)"));
	d_vBoxOptions.pack_start (*p_RB4, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	p_RB4->show ();

	d_frmOptions.add (d_vBoxOptions);
	this->p_tblMain->attach (d_frmOptions, 3, 6, 1, 3);
	d_vBoxOptions.show ();
	d_frmOptions.show ();
	this->p_frmBase->show ();
	this->get_vbox()->show ();
}


/*
 *  buildDialogWindow:
 */
void TFDialogMirror::buildDialogWindow ()
{
	this->set_usize (375, 225);
	this->set_title (this->p_windowTitle);

	this->get_vbox()->set_border_width (2);

	this->setupVBox ();
	this->insertPreview();
	insertOptions ();
	this->fillActionArea ();

	this->show ();
}


/*
 *  buttonCallbackApply: rotate the Height Field
 */
void TFDialogMirror::buttonCallbackApply ()
{
	SanityCheck::bailout ((!p_HFO), "p_HFO==NULL", "TFDialogMirror::buttonCallbackApply");
	SanityCheck::bailout ((!p_HFD), "p_HFD==NULL", "TFDialogMirror::buttonCallbackApply");

	if (p_RB1->get_active())
		p_HFO->mirror (1);
	else
	if (p_RB2->get_active())
		p_HFO->mirror (2);
	else
	if (p_RB3->get_active())
		p_HFO->mirror (3);
	else
	if (p_RB4->get_active())
		p_HFO->mirror (4);
	p_HFD->draw ();

	// only do this if window stays open 
	if (b_applyHit)
		{
		this->setHFobjs (p_HF, p_HFD);
		updatePreviewCallback ();
		}

	this->b_applyHit = TRUE;
}


/*
 *  updatePreviewCallback: update the preview after a widget has been updated.
 */
void TFDialogMirror::updatePreviewCallback ()
{
	if (!d_cbUsePreview.get_active())
		return;

	SanityCheck::bailout ((!p_HFPreview), "p_HFPreview==NULL", "TFDialogFill");
	SanityCheck::bailout ((!p_HFOPreview), "p_HFOPreview==NULL", "TFDialogFill");
	SanityCheck::bailout ((!p_HFDPreview), "p_HFDPreview==NULL", "TFDialogFill");
	this->previewUpToDate ();
	p_HFPreview->restoreBackup ();
	if (p_RB1->get_active())
		p_HFOPreview->mirror (1);
	else
	if (p_RB2->get_active())
		p_HFOPreview->mirror (2);
	else
	if (p_RB3->get_active())
		p_HFOPreview->mirror (3);
	else
	if (p_RB4->get_active())
		p_HFOPreview->mirror (4);
	p_HFDPreview->setColormap (p_HFD->getColormap());
	p_HFDPreview->draw ();
}

