/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _TF_DIALOG_LINEAR_SCALE_H
#define _TF_DIALOG_LINEAR_SCALE_H 1


#include "TFPreviewDialog.h"				// include gtk, gtk--



/*
 *  TFDialogLinearScale: display the roughen dialog for terraformer
 */
class TFDialogLinearScale : public TFPreviewDialog  
	{
	public: 
				TFDialogLinearScale (HeightField *HF, HeightFieldDraw *HFD);
				~TFDialogLinearScale (); 
		void		buildDialogWindow ();
		void 		buttonCallbackApply ();

	private:
		void		insertOptions ();
		void		updatePreviewCallback ();
		int		daButtonPressedCallback (GdkEventButton *event);

		Gtk_VBox		d_vbList;
		Gtk_HBox		d_hbCX, d_hbCY, d_hbScaleFactor,
					d_hbMinDist, d_hbMaxDist,
					d_hbSmoothDist,
					d_hbInvert, d_hbFullDist;
		Gtk_CheckButton		d_btnInvert,
					d_btnFullDist;
		Gtk_Frame		d_frmOptions;
		Gtk_HSeparator		d_hSep;
		Gtk_Label		*p_lblCX, *p_lblCY,
					*p_lblScaleFactor,
					*p_lblMinDist, *p_lblMaxDist,
					*p_lblSmoothDist,
					*p_lblInvert, *p_lblFullDist;
		Gtk_Adjustment		*p_adjCX, *p_adjCY,
					*p_adjScaleFactor,
					*p_adjMinDist, *p_adjMaxDist,
					*p_adjSmoothDist;
		Gtk_HScale		*p_hsCX, *p_hsCY, *p_hsScaleFactor,
					*p_hsMinDist, *p_hsMaxDist,
					*p_hsSmoothDist;
	};


#endif // _TF_DIALOG_LINEAR_SCALE_H
