/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "TFCListMainWin.h"
#include <string.h>
#include "GlobalSanityCheck.h"
#include "GlobalTrace.h"
#include "MenuDefs.h"
#include "TFWindowHandler.h"



#if 0
// dummy table to trick xgettext into extracting the translatable strings
char *foobar[] = {
				N_("/Hide"),
				N_("/Show"),
				N_("/Clone"),
				N_("/Close"),
};
#endif



/*
 *  constructor: inherit CList and provide signal implementations
 * 	to handle the different events the CList can handle. 
 */
TFCListMainWin::TFCListMainWin (int nCols)
		: Gtk_CList (nCols)
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ TFCListMainWin\n");

	p_itemFactory = NULL;
	buildMenu ();
	//connect_to_method (this->select_row, this, &TFCListMainWin::TFCListMainWin);
	//connect_to_method (this->click_column, this, &TFCListMainWin::TFCListMainWin);
}


/*
 *  destructor: clean up 
 */
TFCListMainWin::~TFCListMainWin()
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- TFCListMainWin\n");
}



/*
 *  buildMenu: build the popup menu
 */
void TFCListMainWin::buildMenu ()
{
	Gtk_AccelGroup		accGrp;
	char			*s = NULL;

	p_itemFactory = new Gtk_ItemFactory_Menu ("<CListPopup>", accGrp);

	{
	// uglier than above but without compiler warning
	Gtk_ObjectHandle<Gtk_Menu> a(p_itemFactory->get_menu_widget(""));
	d_menuHandle = a;
	}

	SanityCheck::bailout ((!d_menuHandle.get_object()), "d_menuHandle.get_object failed", "TFCListMainWin::buildMenu");

	s = strdup (_(MENU_CLIST_HIDE));
	p_itemFactory->create_item (s, 0, "", 
		ItemFactoryConnector<TFCListMainWin, string> (this,&TFCListMainWin::menuCallback, s));
	s = strdup (_(MENU_CLIST_SHOW));
	p_itemFactory->create_item (s, 0, "", 
		ItemFactoryConnector<TFCListMainWin, string>(this,&TFCListMainWin::menuCallback, s));
	p_itemFactory->create_item ("/", 0, "<Separator>", 0);
	s = strdup (_(MENU_CLIST_CLONE));
	p_itemFactory->create_item (s, 0, "", 
		ItemFactoryConnector<TFCListMainWin, string>(this,&TFCListMainWin::menuCallback, s));
	p_itemFactory->create_item ("/", 0, "<Separator>", 0);
	s = strdup (_(MENU_CLIST_CLOSE));
	p_itemFactory->create_item (s, 0, "", 
		ItemFactoryConnector<TFCListMainWin, string>(this,&TFCListMainWin::menuCallback, s));
}



/*
 *  menuCallback: process a menu choice in the file menu
 */
void TFCListMainWin::menuCallback (string m)
{
	int		rc=0;
	char		t[256],
			*menuitem = const_cast<char*>(m.c_str());
	string 		*s;
	Gdk_Pixmap	pix;
	Gdk_Bitmap	mask;
	Gtk_Pixmap	*pixmap;
	TFWindowHandler	*tfWin1, *tfWin2;

	tfWin1 = static_cast<TFWindowHandler*>(TFWindowBase::getWinList()->El(d_rowClicked));
	tfWin2 = static_cast<TFWindowHandler*>(this->get_row_data(d_rowClicked));
	// make sure all lists are in sync
	SanityCheck::bailout((!tfWin1), "tfWin1==NULL", "TFCListMainWin::button_press_event_impl");
	SanityCheck::bailout((tfWin1!=tfWin2), "tfWin1!=TFWin2", "TFCListMainWin::button_press_event_impl");

	if (!strcmp (menuitem, _(MENU_CLIST_HIDE)))
		{
		tfWin1->set_sensitive (FALSE);
		tfWin1->getWindow()->hide ();

		//sprintf (t, "%s/%s", TF_DATADIR, "window_hidden.xpm");
		//s = new string (t);
		//pix.create (*d_parent, mask, Gdk_Color(), *s);
		//pix.create ((Gdk_Drawable)get_window(), mask, Gdk_Color(), (string)*s);
		//this->set_pixmap (d_rowClicked, d_colClicked, pix, mask);

		//pixmap = new Gtk_Pixmap (*this, *s);
		//pixmap->get (pix, mask);
		//this->set_pixmap (d_rowClicked, d_colClicked, pix, mask);
		//delete s;
		}
	else
	if (!strcmp (menuitem, _(MENU_CLIST_SHOW)))
		{
		tfWin1->set_sensitive (TRUE);
		tfWin1->getWindow()->show ();
		}
	else
	if (!strcmp (menuitem, _(MENU_CLIST_CLOSE)))
		{
		string		s (_(MENU_FILE_CLOSE));
		tfWin1->fileMenuCallback (s);
		}
	else
	if (!strcmp (menuitem, _(MENU_CLIST_CLONE)))
		{
		string		s (_(MENU_HF_CLONE));
		tfWin1->hfMenuCallback (s);
		}
	else
		SanityCheck::bailout (TRUE, "uncaught <file> menuitem", "TFCListMainWin::clistMenuCallback");

	if (rc)
		g_print ("Warning: last command returned an Error (%d)\n", rc);
	fflush (stdout);
}


/*
 *  click_column_impl: implementation of virtual base function to handle a click
 */
gint TFCListMainWin::button_press_event_impl (GdkEventButton *e)
{
	int 	row, col;

	if (this->get_selection_info (e->x, e->y, &row, &col))
		{
		this->cause_select_row (row, col);
		d_rowClicked = row;
		d_colClicked = col;
		if (e->button == 2 || e->button == 3)
			{
			Gtk_ObjectHandle<Gtk_MenuItem>		mShow, mHide;
			TFWindowHandler				*tfWin1,
								*tfWin2;

			tfWin1 = static_cast<TFWindowHandler*>(TFWindowBase::getWinList()->El(d_rowClicked));
			tfWin2 = static_cast<TFWindowHandler*>(this->get_row_data(d_rowClicked));
			// make sure all lists are in sync
			SanityCheck::bailout((!tfWin1), "tfWin1==NULL", "TFCListMainWin::button_press_event_impl");
			SanityCheck::bailout((tfWin1!=tfWin2), "tfWin1!=TFWin2", "TFCListMainWin::button_press_event_impl");

			mShow = p_itemFactory->get_menuitem_widget(MENU_CLIST_SHOW);
			mHide = p_itemFactory->get_menuitem_widget(MENU_CLIST_HIDE);

			if (tfWin1->is_sensitive())
				{
				//Gdk_Pixmap p = new Gtk_Pixmap 
				mShow->set_sensitive (FALSE);
				mHide->set_sensitive (TRUE);
				}
			else
				{
				mShow->set_sensitive (TRUE);
				mHide->set_sensitive (FALSE);
				}

			d_menuHandle->popup (NULL, NULL, e->button, e->time);
			}
		}
		

	return 0;
}
