/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "TFBaseDialogYN.h"
#include "GuiColormap.h"
#include "GuiColormapBands.h"
#include "GuiDialogOAC.h"
#include "GlobalSanityCheck.h"
#include "GlobalTrace.h"



/*
 *  constructor: initialize all data members 
 */
TFBaseDialogYN::TFBaseDialogYN (HeightField *HF, HeightFieldDraw *HFD, 
				  char *winTitle, char *paramTitle)
	        : GuiDialogYN (winTitle, paramTitle),
		  d_vBoxOptions (TRUE, 5)
{
	SanityCheck::bailout ((!HF), "HF==NULL", "TFBaseDialogYN::TFBaseDialogYN");
	SanityCheck::bailout ((!HFD), "HFD==NULL", "TFBaseDialogYN::TFBaseDialogYN");

	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ TFBaseDialogYN\n");

	d_HF = NULL;
	d_HFD = NULL;
	d_HFO = NULL;
}


/*
 *  destructor: clean up 
 */
TFBaseDialogYN::~TFBaseDialogYN ()
{
	if (d_HFO)
		delete d_HFO;

	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- TFBaseDialogYN\n");
}


/*
 *  setHFobjs: set the HF objects we operate on and generate a scaled 
 * 	down version for the preview 
 */
void TFBaseDialogYN::setHFobjs (HeightField *HF, HeightFieldDraw *HFD)
{
	SanityCheck::bailout ((!HF), "HF==NULL", "TFBaseDialogYN::setHFobjs");
	SanityCheck::bailout ((!HFD), "HFD==NULL", "TFBaseDialogYN::setHFobjs");

	if (HF!=d_HF || HFD!=d_HFD)
		{
		if (d_HFO)
			delete d_HFO;
		d_HF = HF;
		d_HFD = HFD;
		d_HFO = new HeightFieldOps (d_HF);
		}
}


