/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _HEIGHT_FIELD_READER_H
#define _HEIGHT_FIELD_READER_H


#include "HeightField.h"
#include "HeightFieldIO.h"
#include "glibconfig.h"			// for the gint32 and gint16 types





/*
 *  HeightFieldReader: read a Height Field from file
 * 	Depends on being declared a friend to HeightField
 */
class HeightFieldReader
	{
	public:
				HeightFieldReader (HeightField *HF, FileIO *Fio);
				~HeightFieldReader ();
		int		readPGM ();
		int		readTGA ();
		int		readMAT ();
		int		readOCT ();
		int		readDEM ();
		int		readGTOPO ();
		int		readBMP ();
#ifdef HAVE_IMLIB
		int		readImlib ();
#endif

	private:
		void		checkRead (unsigned long points_read, 
						   unsigned long npoints);
		void		readOK ();

		// DEM methods
		int		DEMfindint ();
		int		DEMnextint ();
		float		DEMnextfloat ();
		double 		DEMnextdouble ();

		// BMP methods
		int		BMPreadColormap (unsigned char buf[256][3], 
					int number, int size, int *gray);
		int		BMPreadImage (int len, int height, 
					unsigned char buf[256][3], 
					int ncols, int bpp, int compression, 
					int spzeile, int gray);
		gint32		BMPToL (unsigned char *buffer);
		gint16		BMPToS (unsigned char *buffer);


		HeightField			*p_HF;
		FileIO				*p_Fio;
		struct Bitmap_File_Head_Struct 	*Bitmap_File_Head;
		struct Bitmap_Head_Struct	*Bitmap_Head;
		struct Bitmap_OS2_Head_Struct	*Bitmap_OS2_Head;
	};


#endif // _HEIGHT_FIELD_READER_H

